/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm;

import com.ibm.jvm.ProgramOption;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

class MessageFile
extends ProgramOption {
    List messageFiles = new LinkedList();

    MessageFile() {
    }

    @Override
    String getDescription() {
        String string = System.getProperty("line.separator", "\n");
        return "A comma separated list of files containing the trace format strings. By default the following files are used:" + string + "  $JAVA_HOME/lib/J9TraceFormat.dat" + string + "  $JAVA_HOME/lib/OMRTraceFormat.dat";
    }

    @Override
    String getName() {
        return "datfile";
    }

    @Override
    String getUsage() {
        return "-datfile=file";
    }

    @Override
    Object getValue() {
        return this.messageFiles;
    }

    @Override
    void setValue(String string) throws IllegalArgumentException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String string2 = "";
        try {
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                File file = new File(string2);
                if (!file.exists()) {
                    throw new IllegalArgumentException("dat file \"" + string2 + "\" not found");
                }
                this.messageFiles.add(file);
            }
        }
        catch (SecurityException securityException) {
            throw new IllegalArgumentException("The application does not have permission to access the specified dat file, \"" + string2 + "\"");
        }
    }

    @Override
    void setDefault() {
        String string = System.getProperty("java.home");
        string = string.concat(File.separator).concat("lib").concat(File.separator);
        this.setValue(string + "J9TraceFormat.dat");
        this.setValue(string + "OMRTraceFormat.dat");
    }
}

