/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.trace.format.api;

import com.ibm.jvm.trace.format.api.DataHeader;
import com.ibm.jvm.trace.format.api.TraceContext;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Vector;

public class ActiveSection {
    TraceContext context;
    String textSummary;
    private Vector options = new Vector();

    public ActiveSection(TraceContext traceContext, ByteBuffer byteBuffer) throws IllegalArgumentException {
        this.context = traceContext;
        DataHeader dataHeader = new DataHeader(traceContext, byteBuffer, "UTTA");
        if (traceContext.debugStream != null) {
            traceContext.debug(this, 1, dataHeader);
        }
        byte[] byArray = new byte[dataHeader.length - 16];
        byteBuffer.get(byArray);
        this.splitActivationData(byArray);
    }

    private void splitActivationData(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] != 0) continue;
            if (i != n) {
                String string;
                try {
                    string = new String(byArray, n, i - n, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    string = new String(byArray, n, i - n);
                }
                this.options.add(string);
            }
            n = i + 1;
        }
        if (this.context.debugStream != null) {
            this.context.debug(this, 1, this.summary());
        }
    }

    public String toString() {
        return "Trace activation information:";
    }

    public String summary() {
        if (this.textSummary == null) {
            StringBuilder stringBuilder = new StringBuilder(this.toString() + ":" + System.getProperty("line.separator"));
            for (int i = 0; i < this.options.size(); ++i) {
                stringBuilder.append("        ");
                stringBuilder.append(this.options.get(i)).append(System.getProperty("line.separator"));
            }
            this.textSummary = stringBuilder.toString();
        }
        return this.textSummary;
    }
}

