/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.pay;

import javax.annotation.Nonnull;

public final class FreeTrialPeriod {
    private final int numberOfUnits;
    @Nonnull
    private final PeriodUnit unit;

    public FreeTrialPeriod(int numberOfUnits, PeriodUnit unit) {
        this.numberOfUnits = numberOfUnits;
        this.unit = unit;
    }

    public int getNumberOfUnits() {
        return this.numberOfUnits;
    }

    @Nonnull
    public PeriodUnit getUnit() {
        return this.unit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FreeTrialPeriod that = (FreeTrialPeriod)o;
        if (this.numberOfUnits != that.numberOfUnits) {
            return false;
        }
        return this.unit == that.unit;
    }

    public int hashCode() {
        int result = this.numberOfUnits;
        result = 31 * result + this.unit.hashCode();
        return result;
    }

    public static enum PeriodUnit {
        DAY,
        MONTH,
        WEEK,
        YEAR;


        public static PeriodUnit parse(char character) {
            switch (character) {
                case 'D': {
                    return DAY;
                }
                case 'W': {
                    return WEEK;
                }
                case 'M': {
                    return MONTH;
                }
                case 'Y': {
                    return YEAR;
                }
            }
            throw new IllegalArgumentException("Character not mapped to PeriodUnit: " + character);
        }
    }
}

