/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.ent.die;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector3;
import com.tann.dice.Main;
import com.tann.dice.gameplay.content.ent.Ent;
import com.tann.dice.gameplay.content.ent.die.Die;
import com.tann.dice.gameplay.content.ent.die.DieContainer;
import com.tann.dice.gameplay.content.ent.die.side.EntSide;
import com.tann.dice.gameplay.effect.eff.Eff;
import com.tann.dice.gameplay.effect.eff.keyword.Keyword;
import com.tann.dice.gameplay.effect.targetable.DieTargetable;
import com.tann.dice.gameplay.effect.targetable.ability.ui.AbilityHolder;
import com.tann.dice.gameplay.fightLog.EntSideState;
import com.tann.dice.gameplay.fightLog.EntState;
import com.tann.dice.gameplay.fightLog.FightLog;
import com.tann.dice.gameplay.phase.PhaseManager;
import com.tann.dice.gameplay.trigger.global.Global;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.screens.dungeon.RollManager;
import com.tann.dice.statics.bullet.BulletStuff;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Colours;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EntDie
extends Die<EntSide> {
    public final Ent ent;
    Map<Integer, Integer> glowMap = new HashMap<Integer, Integer>();
    DieTargetable dieTargetable;

    public EntDie(Ent ent) {
        super((int)(Math.random() * 6.0));
        this.ent = ent;
        this.init();
    }

    public static int opposite(int sideIndex, boolean nice) {
        if (!nice) {
            switch (sideIndex) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 0;
                }
                case 4: {
                    return 5;
                }
                case 5: {
                    return 4;
                }
                case 2: {
                    return 3;
                }
                case 3: {
                    return 2;
                }
            }
            return -69;
        }
        switch (sideIndex) {
            case 0: {
                return 4;
            }
            case 4: {
                return 0;
            }
            case 1: {
                return 5;
            }
            case 5: {
                return 1;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 2;
            }
        }
        return -69;
    }

    protected EntSide[] initSides() {
        return Arrays.copyOf(this.ent.getSides(), 6);
    }

    @Override
    public EntSide getCurrentSide() {
        int side = this.getSideIndex();
        if (side >= 0) {
            return (EntSide)this.getSide(side);
        }
        return null;
    }

    @Override
    public Color getColour() {
        if (this.ent == null) {
            return Colours.dark;
        }
        return this.ent.getColour();
    }

    @Override
    protected TextureRegion getSideTexture(int side) {
        return this.ent.getState(FightLog.Temporality.Visual).getSideState((EntSide)this.getSide(side)).getCalculatedTexture();
    }

    @Override
    protected float getPipFloat(int side, boolean bonus) {
        EntSideState ess = this.ent.getState(FightLog.Temporality.Visual).getSideState((EntSide)this.getSide(side));
        if (bonus) {
            return ess.getTotalBonus();
        }
        Eff e = ess.getCalculatedEffect();
        if (e.hasValue()) {
            return Math.max(0, e.getValue());
        }
        return bonus ? 0.0f : -1.0f;
    }

    @Override
    protected float getBonusPipFloat(int side) {
        if (this.glowMap.get(side) == null) {
            EntSideState ess = this.ent.getState(FightLog.Temporality.Visual).getSideState((EntSide)this.getSide(side));
            this.glowMap.put(side, ess.getBonusColIndex());
        }
        return this.glowMap.get(side).intValue();
    }

    @Override
    public void clearTextureCache() {
        super.clearTextureCache();
        this.glowMap = new HashMap<Integer, Integer>();
    }

    @Override
    public float[] getKeywordLocs() {
        if (this.keywordLocs != null) {
            return this.keywordLocs;
        }
        this.keywordLocs = new float[96];
        EntState es = this.ent.getState(FightLog.Temporality.Visual);
        float regionWidth = 512.0f;
        float regionHeight = 512.0f;
        for (int sideIndex = 0; sideIndex < 6; ++sideIndex) {
            List<Keyword> bonuses = es.getSideState(sideIndex).getBonusKeywords();
            for (int keywordIndex = 0; keywordIndex < 4 && keywordIndex < bonuses.size(); ++keywordIndex) {
                Keyword k = bonuses.get(keywordIndex);
                int mainIndex = sideIndex * 16 + keywordIndex * 4;
                TextureRegion image = k.getImage(this.ent.getSize());
                this.keywordLocs[mainIndex + 0] = (float)image.getRegionX() / 512.0f;
                this.keywordLocs[mainIndex + 1] = (float)image.getRegionY() / 512.0f;
                this.keywordLocs[mainIndex + 2] = k.isFlipCorner() ? 1.0f : 0.0f;
                this.keywordLocs[mainIndex + 3] = image.getRegionHeight() * 20 + image.getRegionWidth();
            }
        }
        return this.keywordLocs;
    }

    @Override
    protected TextureRegion getLapelTexture() {
        return this.ent.getLapel();
    }

    @Override
    protected void locked() {
        this.ent.locked();
    }

    @Override
    protected void stopped() {
        this.ent.stopped();
    }

    @Override
    public float getPixelSize() {
        return this.ent.getPixelSize();
    }

    @Override
    protected DieContainer getDieContainer() {
        return this.ent.getEntPanel();
    }

    @Override
    public void setState(Die.DieState state) {
        this.dieTargetable = null;
        super.setState(state);
    }

    public DieTargetable getTargetable() {
        if (this.dieTargetable == null) {
            this.dieTargetable = new DieTargetable(this.ent, this.getSideIndex());
        }
        return this.dieTargetable;
    }

    public void toggleLock() {
        RollManager rm;
        if (!PhaseManager.get().getPhase().canRoll()) {
            return;
        }
        if (!(Main.getSettings().hasAttemptedLevel() || (rm = DungeonScreen.get().rollManager).allDiceNotState(Die.DieState.Rolling) && rm.allDiceNotState(Die.DieState.Unlocking))) {
            return;
        }
        boolean allowToggle = true;
        boolean currentlyLocked = this.getState().isLockedOrLocking();
        EntState es = this.ent.getState(FightLog.Temporality.Present);
        if (es.getSnapshot().getRolls() == 0 && this.getState().isLockedOrLocking()) {
            return;
        }
        if (currentlyLocked) {
            allowToggle &= !es.isAutoLock();
        }
        for (Global gt : es.getSnapshot().getGlobals()) {
            allowToggle &= gt.allowToggleLock(currentlyLocked, es.getSnapshot().getStates(true, false));
        }
        if (!currentlyLocked && DungeonScreen.get().rollManager.getHeroDiceAvailableToRoll().size() == 1) {
            allowToggle = true;
        }
        if (!allowToggle) {
            Sounds.playSound(Sounds.error);
            String action = currentlyLocked ? "reroll" : "lock";
            String msg = this.ent.getName(true) + " can't be " + action + "ed";
            AbilityHolder.showInfo(msg, Colours.red);
            return;
        }
        switch (this.getState()) {
            case Stopped: 
            case Unlocking: {
                if (this.getSideIndex() == -1) {
                    return;
                }
                Sounds.playSound(Sounds.lock);
                this.slideToPanel();
                break;
            }
            case Locked: 
            case Locking: {
                Sounds.playSound(Sounds.unlock);
                this.getDieContainer().unlockDie();
                this.returnToPlay(null, false, EntDie.getBaseInterpSpeed());
            }
        }
        if (DungeonScreen.get().rollManager.allDiceStoppedEnoughToSave()) {
            DungeonScreen.get().mildSave();
        }
    }

    public static void organiseDiceIntoLine(List<EntDie> dice) {
        if (dice.size() == 0) {
            Sounds.playSound(Sounds.error);
            return;
        }
        Sounds.playSound(Sounds.lock);
        int numDice = dice.size();
        for (int i = 0; i < numDice; ++i) {
            EntDie d = dice.get(i);
            if (d == null || d.getState() != Die.DieState.Stopped) continue;
            d.setState(Die.DieState.SlidingToMiddle);
            d.moveTo(EntDie.getLineLoc(d), d.getSideQuaternion(d.getSideIndex(), false), null, 0.3f);
        }
    }

    public static Vector3 getLineLoc(EntDie d) {
        float dieRadius = d.physical.radius;
        float dieGap = dieRadius * 1.13f;
        Vector3 middle = BulletStuff.getMiddle();
        middle.y += d.getSafeY();
        List<EntDie> dice = BulletStuff.getDice(true);
        int numDice = dice.size();
        int i = dice.indexOf(d);
        float zDistanceMult = i % 5 - 2;
        float xDistMult = (float)(i / 5) - (float)((numDice - 1) / 5) / 2.0f;
        return middle.cpy().add(xDistMult * dieGap, 0.0f, zDistanceMult * dieGap);
    }

    public boolean isDisposed() {
        return this.disposed;
    }
}

