/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.gen.pipe.entity.hero.generate;

import com.tann.dice.gameplay.content.ent.die.side.EntSide;
import com.tann.dice.gameplay.content.ent.type.HeroCol;
import com.tann.dice.gameplay.content.ent.type.HeroType;
import com.tann.dice.gameplay.content.ent.type.bill.HTBill;
import com.tann.dice.gameplay.content.ent.type.lib.HeroTypeLib;
import com.tann.dice.gameplay.content.ent.type.lib.HeroTypeUtils;
import com.tann.dice.gameplay.content.gen.pipe.entity.hero.generate.PipeHeroGenerated;
import com.tann.dice.gameplay.content.gen.pipe.entity.hero.generate.SingleAttempt;
import com.tann.dice.gameplay.content.gen.pipe.regex.PipeRegexNamed;
import com.tann.dice.gameplay.content.gen.pipe.regex.prnPart.PRNPart;
import com.tann.dice.gameplay.content.gen.pipe.regex.prnPart.pos.PRNMid;
import com.tann.dice.util.Tann;
import com.tann.dice.util.TannLog;
import com.tann.dice.util.bsRandom.Checker;
import com.tann.dice.util.bsRandom.RandomCheck;
import com.tann.dice.util.bsRandom.Supplier;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class PipeHeroAdjust
extends PipeRegexNamed<HeroType> {
    public static final PRNPart SEP = new PRNMid("adj");

    public PipeHeroAdjust() {
        super(HERO, SEP, SINGLE_DIGIT_TIER);
    }

    @Override
    protected HeroType internalMake(String[] groups) {
        String heroName = groups[0];
        String tier = groups[1];
        return this.make(heroName, tier);
    }

    private HeroType make(String heroName, String tierSt) {
        if (PipeHeroAdjust.bad(heroName, tierSt)) {
            return null;
        }
        HeroType ht = HeroTypeLib.byName(heroName);
        if (ht.isMissingno()) {
            return null;
        }
        if (!Tann.isInt(tierSt)) {
            return null;
        }
        int tier = Integer.parseInt(tierSt);
        return PipeHeroAdjust.makeHero(ht, tier);
    }

    public static HeroType makeHero(HeroCol col, int tier) {
        return PipeHeroAdjust.makeHero(HeroTypeUtils.getRandom(col, Tann.randomExcept(new Integer[]{1, 2, 3}, tier)), tier);
    }

    public static HeroType makeHeroAlternate(final HeroCol col, final int tier) {
        HeroType ht2;
        HeroType ht = RandomCheck.checkedRandom(new Supplier<HeroType>(){

            @Override
            public HeroType supply() {
                return PipeHeroAdjust.makeHero(col, tier);
            }
        }, new Checker<HeroType>(){

            @Override
            public boolean check(HeroType heroType) {
                return heroType != null;
            }
        }, HeroTypeUtils.byName("arjghkjehrg"));
        if (ht.isMissingno()) {
            TannLog.log("uhoh");
        }
        if ((ht2 = HeroTypeLib.byName(ht + ".n." + PipeHeroAdjust.reVowel(ht.getName(false), tier))).isMissingno()) {
            TannLog.log("uhoh2");
        }
        return ht2;
    }

    private static String reVowel(String name, int tier) {
        return name.split("\\.")[0].replaceFirst("[aeiouy]", tier + "");
    }

    public static HeroType makeHero(HeroType src, int tier) {
        String name = src.getName(false);
        if (name.equalsIgnoreCase("statue") || name.equalsIgnoreCase("Twin")) {
            return null;
        }
        if (src.getTier() == tier) {
            return src;
        }
        int seed = Math.abs(tier + src.getName(false).hashCode() % 900);
        HeroType result = PipeHeroGenerated.multiAttempt(src.heroCol, tier, seed, Arrays.asList(src.sides), PipeHeroAdjust.makeName(src, tier), 1.0f, PipeHeroAdjust.makeSA(src), src.portrait);
        if (result.isMissingno()) {
            TannLog.error("Failed to make PHWT " + src.getName(false) + ":" + tier);
            return null;
        }
        return result;
    }

    private static String makeName(HeroType ht, int tier) {
        return ht.getName(false) + SEP + tier;
    }

    public static SingleAttempt makeSA(final HeroType base) {
        return new SingleAttempt(){

            @Override
            public EntSide getRandomSide(Random r, HTBill builder, List<EntSide> options, float targetStrength, float STRENGTH_CUTOFF, HeroType example, int sideIndex) {
                EntSide newSide = Tann.random(base.sides, r).copy();
                PipeHeroGenerated.affectValue(newSide, example, targetStrength, r);
                return newSide;
            }
        };
    }

    @Override
    public HeroType example() {
        return PipeHeroAdjust.makeHero(Tann.random(HeroCol.basics()), Tann.randomInt(10));
    }
}

