/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.gen.pipe.item;

import com.tann.dice.gameplay.content.gen.pipe.regex.PipeRegexNamed;
import com.tann.dice.gameplay.content.gen.pipe.regex.prnPart.PRNPart;
import com.tann.dice.gameplay.content.gen.pipe.regex.prnPart.pos.PRNPref;
import com.tann.dice.gameplay.content.item.ItBill;
import com.tann.dice.gameplay.content.item.Item;
import com.tann.dice.gameplay.effect.targetable.ability.Ability;
import com.tann.dice.gameplay.effect.targetable.ability.AbilityUtils;
import com.tann.dice.gameplay.trigger.personal.spell.learn.LearnAbility;

public class PipeItemAbility
extends PipeRegexNamed<Item> {
    public static final PRNPart PREF = new PRNPref("learn");

    public PipeItemAbility() {
        super(PREF, ABILITY);
    }

    @Override
    protected Item internalMake(String[] groups) {
        String heroName = groups[0];
        Ability a = AbilityUtils.byName(heroName);
        if (a == null) {
            return null;
        }
        return this.makeInternal(a);
    }

    private Item makeInternal(Ability ab) {
        if (ab == null) {
            return null;
        }
        float tier = AbilityUtils.likeFromHeroTier(ab);
        int approxTier = Float.isNaN(tier) ? 0 : Math.round(AbilityUtils.heroTierFactorToItemTier(tier));
        return new ItBill(approxTier, PREF + ab.getTitle(), ab.getImage()).trigger(LearnAbility.make(ab)).bItem();
    }

    @Override
    public boolean canGenerate(boolean wild) {
        return true;
    }

    @Override
    protected Item generateInternal(boolean wild) {
        Item i;
        if (!wild) {
            // empty if block
        }
        if ((i = this.makeInternal(AbilityUtils.random())).getTier() == 0) {
            return null;
        }
        return i;
    }

    @Override
    public Item example() {
        return this.generateInternal(false);
    }

    @Override
    public boolean showHigher() {
        return true;
    }
}

