/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.gen.pipe.mod.level;

import com.tann.dice.gameplay.content.gen.pipe.regex.PipeRegexNamed;
import com.tann.dice.gameplay.modifier.Modifier;
import com.tann.dice.gameplay.modifier.ModifierLib;
import com.tann.dice.gameplay.modifier.generation.CurseDistribution;
import com.tann.dice.gameplay.trigger.Collision;
import com.tann.dice.gameplay.trigger.global.Global;
import com.tann.dice.gameplay.trigger.global.scaffolding.levelRequirement.GlobalLevelRequirement;
import com.tann.dice.gameplay.trigger.global.scaffolding.levelRequirement.LevelRequirementMod;
import com.tann.dice.util.Tann;

public class PipeModNthFight
extends PipeRegexNamed<Modifier> {
    public PipeModNthFight() {
        super(PipeModNthFight.prnS("e"), DIGIT_2_9, PipeModNthFight.prnS("\\."), MOD);
    }

    @Override
    protected Modifier internalMake(String[] groups) {
        String n = groups[0];
        String m = groups[1];
        if (PipeModNthFight.bad(n, m)) {
            return null;
        }
        if (!Tann.isInt(n)) {
            return null;
        }
        int nInt = Integer.parseInt(n);
        return this.make(nInt, ModifierLib.byName(m));
    }

    private Modifier make(int n, Modifier mod) {
        if (mod.isMissingno()) {
            return null;
        }
        if (n <= 0 || n >= 10) {
            return null;
        }
        if (n == 1) {
            return mod;
        }
        Global g = mod.getSingleGlobalOrNull();
        if (g == null || g.allLevelsOnly()) {
            return null;
        }
        float tier = (float)mod.getTier() * CurseDistribution.getMultLevelRange(20 - 20 / n, 20);
        return new Modifier(tier, "e" + n + "." + mod.getName(), new GlobalLevelRequirement(new LevelRequirementMod(n, 0), g));
    }

    @Override
    public Modifier example() {
        Modifier m = ModifierLib.random();
        if (Collision.collides(m.getCollisionBits(), Collision.ITEM_REWARD | Collision.LEVELUP_REWARD)) {
            return null;
        }
        return this.make(Tann.randomInt(2, 8), ModifierLib.random());
    }

    @Override
    public boolean canGenerate(boolean wild) {
        return wild;
    }

    @Override
    protected Modifier generateInternal(boolean wild) {
        return this.example();
    }

    @Override
    public boolean skipAPI() {
        return true;
    }
}

