/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.gen.pipe.regex.meta.srcAlg;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.tann.dice.gameplay.content.ent.die.side.EntSide;
import com.tann.dice.gameplay.content.ent.type.HeroType;
import com.tann.dice.gameplay.content.ent.type.bill.HTBill;
import com.tann.dice.gameplay.content.ent.type.lib.EntTypeUtils;
import com.tann.dice.gameplay.content.ent.type.lib.HeroTypeLib;
import com.tann.dice.gameplay.content.ent.type.lib.HeroTypeUtils;
import com.tann.dice.gameplay.content.gen.pipe.regex.PipeRegexNamed;
import com.tann.dice.gameplay.content.gen.pipe.regex.meta.srcAlg.DataSource;
import com.tann.dice.gameplay.effect.eff.Eff;
import com.tann.dice.gameplay.trigger.personal.Personal;
import com.tann.dice.gameplay.trigger.personal.RenameHero;
import com.tann.dice.gameplay.trigger.personal.weird.DescribeOnlyTrait;
import java.util.List;

public class DataSourceHero
extends DataSource<HeroType> {
    public DataSourceHero() {
        super(PipeRegexNamed.HERO);
    }

    @Override
    public HeroType combine(HeroType heroType, TextureAtlas.AtlasRegion ar, String realName) {
        return ((HTBill)((HTBill)HeroTypeUtils.copy(heroType).arOverride(ar)).name(realName)).bEntType();
    }

    @Override
    public HeroType makeT(String name) {
        HeroType ht = HeroTypeLib.byName(name);
        if (ht.isMissingno()) {
            return null;
        }
        return ht;
    }

    @Override
    public HeroType exampleBase() {
        return HeroTypeUtils.random();
    }

    @Override
    public TextureAtlas.AtlasRegion getImage(HeroType heroType) {
        return heroType.portrait;
    }

    @Override
    public HeroType upscale(HeroType heroType, int multiplier) {
        return DataSourceHero.multiplyHero(heroType, multiplier);
    }

    @Override
    public HeroType rename(HeroType ht, String rename, String realName) {
        if (ht.isMissingno()) {
            return null;
        }
        RenameHero rh = new RenameHero(rename);
        return HeroTypeUtils.withPassive(ht, realName, (Personal)rh, null);
    }

    @Override
    public HeroType document(HeroType heroType, String documentation, String realName) {
        HTBill mtb = EntTypeUtils.copy(heroType);
        mtb.trait(new DescribeOnlyTrait(documentation));
        mtb.name(realName);
        return mtb.bEntType();
    }

    @Override
    public HeroType retier(HeroType heroType, int newTier, String realName) {
        if (newTier < 0 || newTier > 999) {
            return null;
        }
        return ((HTBill)HeroTypeUtils.copy(heroType).name(realName)).tier(newTier).bEntType();
    }

    @Override
    public HeroType makeIndexed(long val) {
        if (val < 0L) {
            return null;
        }
        List<HeroType> all = HeroTypeLib.getMasterCopy();
        if (val < (long)all.size()) {
            return all.get((int)val);
        }
        return null;
    }

    @Override
    public HeroType renameUnderlying(HeroType heroType, String rename) {
        return ((HTBill)HeroTypeUtils.copy(heroType).name(rename)).bEntType();
    }

    public static int reverseIndex(HeroType ht) {
        return HeroTypeLib.getMasterCopy().indexOf(ht);
    }

    private static HeroType multiplyHero(HeroType ht, int mult) {
        if (ht.getName(false).matches(".*x\\d.*")) {
            return null;
        }
        if (mult <= 1) {
            return ht;
        }
        HTBill htb = HeroTypeUtils.copy(ht);
        htb.hp(ht.hp * mult);
        htb.name("x" + mult + "." + ht.getName());
        htb.tier(ht.level * mult);
        EntSide[] transformedSides = new EntSide[6];
        for (int si = 0; si < 6; ++si) {
            EntSide src = ht.sides[si];
            Eff base = src.getBaseEffect();
            EntSide replace = base.hasValue() ? src.withValue(src.getBaseEffect().getValue() * mult) : src.copy();
            transformedSides[si] = replace;
        }
        htb.sidesRaw(transformedSides);
        return htb.bEntType();
    }
}

