/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.gen.pipe.regex.meta.srcAlg;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.tann.dice.gameplay.content.gen.pipe.item.PipeItemPerTier;
import com.tann.dice.gameplay.content.gen.pipe.regex.PipeRegexNamed;
import com.tann.dice.gameplay.content.gen.pipe.regex.meta.RenameUtils;
import com.tann.dice.gameplay.content.gen.pipe.regex.meta.srcAlg.DataSource;
import com.tann.dice.gameplay.content.item.ItBill;
import com.tann.dice.gameplay.content.item.Item;
import com.tann.dice.gameplay.content.item.ItemLib;
import com.tann.dice.gameplay.trigger.personal.Personal;
import com.tann.dice.gameplay.trigger.personal.item.PersonalTextureReplaced;
import com.tann.dice.gameplay.trigger.personal.linked.perN.PersonalPerN;
import com.tann.dice.gameplay.trigger.personal.weird.DescribeOnly;
import java.util.List;

public class DataSourceItem
extends DataSource<Item> {
    public DataSourceItem() {
        super(PipeRegexNamed.ITEM);
    }

    @Override
    public Item combine(Item src, TextureAtlas.AtlasRegion ar, String realName) {
        ItBill ib = new ItBill(src.getTier(), realName, ar).trigger(src.getPersonalTriggers());
        if (!DataSourceItem.hasPTR(ib)) {
            ib.trigger(new PersonalTextureReplaced());
        }
        return ib.bItem();
    }

    @Override
    public Item makeT(String name) {
        Item i = ItemLib.byName(name);
        if (i.isMissingno()) {
            return null;
        }
        return i;
    }

    @Override
    public Item exampleBase() {
        return ItemLib.random();
    }

    @Override
    public TextureAtlas.AtlasRegion getImage(Item heroType) {
        return DataSourceItem.wrap(heroType.getImage());
    }

    @Override
    public Item upscale(Item item, int multiplier) {
        return DataSourceItem.multiMake(item, multiplier);
    }

    @Override
    public Item rename(Item src, String rename, String realName) {
        if (rename == null || rename.isEmpty() || src.isMissingno()) {
            return null;
        }
        ItBill ib = RenameUtils.copy(src, realName);
        RenameUtils.rename(ib, rename, true);
        return ib.bItem();
    }

    @Override
    public Item document(Item item, String documentation, String realName) {
        return RenameUtils.copy(item, realName).triggerFirst(new DescribeOnly(documentation)).bItem();
    }

    @Override
    public Item retier(Item item, int newTier, String realName) {
        return new ItBill(newTier, realName, item.getImage()).trigger(item.getPersonalTriggers()).bItem();
    }

    @Override
    public Item makeIndexed(long val) {
        List<Item> cpy = ItemLib.getMasterCopy();
        if (val >= 0L && val < (long)cpy.size()) {
            return cpy.get((int)val);
        }
        return null;
    }

    @Override
    public Item renameUnderlying(Item item, String rename) {
        return RenameUtils.copy(item, rename).bItem();
    }

    public static Item multiMake(Item src, int mul) {
        if (src.isMissingno() || !src.isMultiplable(true)) {
            return null;
        }
        float tier = src.getTier() * mul;
        TextureRegion tr = src.getImage();
        ItBill ib = new ItBill(Math.round(tier), "x" + mul + "." + src.getName(), tr);
        List<Personal> personalTriggers = src.getPersonalTriggers();
        for (int i = 0; i < personalTriggers.size(); ++i) {
            Personal p = personalTriggers.get(i);
            if (PipeItemPerTier.shouldMult(p)) {
                ib.trigger(PersonalPerN.basicMultiple(mul, p));
                continue;
            }
            ib.trigger(p);
        }
        return ib.bItem();
    }

    public static boolean hasPTR(ItBill ib) {
        for (int i = 0; i < ib.getTriggers().size(); ++i) {
            if (!(ib.getTriggers().get(i) instanceof PersonalTextureReplaced)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasPTR(Item i) {
        for (int i1 = 0; i1 < i.getPersonalTriggers().size(); ++i1) {
            if (!(i.getPersonalTriggers().get(i1) instanceof PersonalTextureReplaced)) continue;
            return true;
        }
        return false;
    }
}

