/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.item;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.tann.dice.gameplay.content.gen.pipe.regex.meta.srcAlg.DataSourceItem;
import com.tann.dice.gameplay.content.item.Item;
import com.tann.dice.gameplay.effect.targetable.ability.Ability;
import com.tann.dice.gameplay.effect.targetable.ability.spell.SpellBill;
import com.tann.dice.gameplay.trigger.personal.Personal;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.AffectSides;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.condition.AffectSideCondition;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.condition.SpecificSidesCondition;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.condition.SpecificSidesType;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.effect.AffectSideEffect;
import com.tann.dice.gameplay.trigger.personal.spell.learn.LearnAbility;
import com.tann.dice.statics.ImageUtils;
import java.util.ArrayList;
import java.util.List;

public class ItBill {
    private final String name;
    private final TextureRegion image;
    private final int tier;
    private List<Personal> triggers = new ArrayList<Personal>();
    private boolean hidden;
    private boolean confirmed;

    public static ItBill make(int tier, String name, TextureRegion override, String defaultString) {
        if (override != null) {
            return new ItBill(tier, name, override);
        }
        return new ItBill(tier, name, defaultString);
    }

    public static ItBill make(int tier, String name, Item src, String defaultString) {
        if (DataSourceItem.hasPTR(src)) {
            return new ItBill(tier, name, src.getImage());
        }
        return new ItBill(tier, name, defaultString);
    }

    public static ItBill make(int tier, String name, Item src, Item src2, String defaultString) {
        if (DataSourceItem.hasPTR(src)) {
            return new ItBill(tier, name, src.getImage());
        }
        if (DataSourceItem.hasPTR(src2)) {
            return new ItBill(tier, name, src2.getImage());
        }
        return new ItBill(tier, name, defaultString);
    }

    public ItBill(int tier, String name, TextureRegion img) {
        this.tier = tier;
        this.name = name;
        this.image = img;
        if (img instanceof TextureAtlas.AtlasRegion) {
            String string = ((TextureAtlas.AtlasRegion)img).name;
        }
    }

    public ItBill(int tier, String name, String imgPath) {
        this(tier, name, ImageUtils.loadExt("item/" + imgPath));
    }

    public ItBill(int tier, String name) {
        this(tier, name, ItBill.getImageFromName(name));
    }

    public ItBill(int tier, SpellBill sb) {
        this(tier, sb.bSpell());
    }

    public ItBill(int tier, Ability ability) {
        this(tier, "Learn " + ability.getTitle(), ability.getImage());
        this.trigger(LearnAbility.make(ability));
    }

    public Item bItem() {
        return new Item(this.tier, this.name, this.image, this.triggers, this.makeDescription(), this.hidden, this.confirmed);
    }

    private String makeDescription() {
        if (this.triggers.size() == 1) {
            return this.triggers.get(0).describeForSelfBuff();
        }
        String s = "";
        for (int i = 0; i < this.triggers.size(); ++i) {
            Personal t;
            String desc;
            if (s.length() > 0) {
                s = s + "[n][n2]";
            }
            if ((desc = (t = this.triggers.get(i)).describeForSelfBuff()) == null) continue;
            s = s + desc;
        }
        return s;
    }

    public ItBill trigger(List<Personal> triggers) {
        this.triggers.addAll(triggers);
        return this;
    }

    public ItBill trigger(AffectSideEffect ase) {
        return this.trigger(new AffectSides(ase));
    }

    public ItBill trigger(AffectSideCondition asc, AffectSideEffect ase) {
        return this.trigger(new AffectSides(asc, ase));
    }

    public ItBill trigger(SpecificSidesType sst, AffectSideEffect ase) {
        return this.trigger(new SpecificSidesCondition(sst), ase);
    }

    public ItBill trigger(Personal t) {
        this.triggers.add(t);
        return this;
    }

    public ItBill triggerFirst(Personal t) {
        this.triggers.add(0, t);
        return this;
    }

    public ItBill hidden() {
        this.hidden = true;
        return this;
    }

    public ItBill confirmed() {
        this.confirmed = true;
        return this;
    }

    private static TextureRegion getImageFromName(String name) {
        String transformedName = name.replaceAll("[ ':]", "-").toLowerCase();
        String path = "item/" + transformedName;
        TextureRegion result = ImageUtils.loadExtNull(path);
        if (result != null) {
            return result;
        }
        return ImageUtils.loadExt("item/placeholder");
    }

    public List<Personal> getTriggers() {
        return this.triggers;
    }
}

