/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.effect;

import com.tann.dice.gameplay.effect.eff.Eff;
import com.tann.dice.gameplay.effect.eff.TargetingType;
import com.tann.dice.gameplay.fightLog.EntState;
import com.tann.dice.gameplay.trigger.personal.Cleansed;
import com.tann.dice.gameplay.trigger.personal.Dodge;
import com.tann.dice.gameplay.trigger.personal.Personal;
import com.tann.dice.gameplay.trigger.personal.Stunned;
import com.tann.dice.gameplay.trigger.personal.immunity.DamageImmunity;
import com.tann.dice.gameplay.trigger.personal.merge.Merge;
import com.tann.dice.util.tp.TP;

public class Buff {
    public int turns;
    public Personal trigger;
    boolean expired;
    private boolean skipFirstTick;

    public Buff(int turns, Personal trigger) {
        this.turns = turns;
        this.trigger = trigger.transformForBuff();
        this.trigger.buff = this;
    }

    public Buff(Personal trigger) {
        this(-1, trigger);
    }

    public void turn() {
        this.trigger.clearDescCache();
        if (this.skipFirstTick) {
            return;
        }
        if (this.turns > 0) {
            --this.turns;
        }
        if (this.turns == 0) {
            this.expire();
        }
    }

    public void unskip() {
        this.skipFirstTick = false;
    }

    public void skipFirstTick() {
        this.skipFirstTick = true;
    }

    private void expire() {
        this.expired = true;
    }

    public Buff copy() {
        Buff b = new Buff(this.turns, this.trigger);
        if (this.skipFirstTick) {
            b.skipFirstTick();
        }
        return b;
    }

    public String toNiceString(Eff source) {
        String giveText;
        TargetingType tt = source.getTargetingType();
        if (tt == TargetingType.Self) {
            giveText = this.trigger instanceof DamageImmunity ? "Become " + this.trigger.describeForSelfBuff().toLowerCase() : this.trigger.describeForSelfBuff();
        } else {
            giveText = this.trigger.describeForGiveBuff(source);
            if (tt == TargetingType.Group) {
                giveText = giveText.replaceAll("target's", source.isFriendly() ? "allied" : "enemy");
            }
        }
        if (this.isInfinite()) {
            return giveText + " this fight";
        }
        String result = giveText;
        return result + this.getTurnsString();
    }

    public String getTurnsString() {
        if (this.isInfinite()) {
            return "";
        }
        if (this.turns == 0 || this.turns == 1 && !this.skipFirstTick) {
            if (this.trigger instanceof Stunned || this.trigger instanceof Dodge) {
                return "";
            }
            return " this turn";
        }
        if (this.turns == 1 && this.skipFirstTick) {
            return " next turn";
        }
        return " for " + this.turns + " turns";
    }

    public Cleansed.CleanseType getCleanseType() {
        return this.trigger.getCleanseType();
    }

    public boolean expired() {
        return this.expired;
    }

    public boolean canMerge(Buff buff) {
        if (!(this.trigger instanceof Merge)) {
            return false;
        }
        return ((Merge)this.trigger).canMerge(buff.trigger) && this.turns == buff.turns && this.skipFirstTick == buff.skipFirstTick;
    }

    public void merge(Buff buff) {
        if (!this.canMerge(buff)) {
            throw new RuntimeException("Invalid buff merger");
        }
        if (this.trigger instanceof Merge) {
            Merge cpy = ((Merge)this.trigger).copy();
            cpy.merge(buff.trigger);
            cpy.clearDescCache();
            this.trigger = cpy;
        }
    }

    public boolean isRecommendedTarget(EntState sourceState, EntState targetPresent, EntState targetFuture) {
        return this.trigger.isRecommended(sourceState, targetPresent, targetFuture);
    }

    public float getEffectTier(int pips, int tier) {
        return this.trigger.getEffectTier(pips, tier);
    }

    public TP<Integer, Boolean> cleanseBy(int cleanseAmt) {
        TP<Integer, Boolean> result = this.trigger.cleanseBy(cleanseAmt);
        this.trigger.clearDescCache();
        return result;
    }

    public boolean isInfinite() {
        return this.turns == -1;
    }
}

