/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.mode.creative.custom;

import com.tann.dice.gameplay.content.ent.type.HeroType;
import com.tann.dice.gameplay.content.ent.type.MonsterType;
import com.tann.dice.gameplay.content.gen.pipe.mod.PipeModAllItem;
import com.tann.dice.gameplay.content.gen.pipe.mod.PipeModPermaItem;
import com.tann.dice.gameplay.content.gen.pipe.mod.PipeModSpirit;
import com.tann.dice.gameplay.content.item.Item;
import com.tann.dice.gameplay.modifier.Modifier;
import com.tann.dice.gameplay.modifier.ModifierLib;
import com.tann.dice.gameplay.trigger.global.eff.GlobalSummonMonsterStartTurn;
import com.tann.dice.gameplay.trigger.global.level.GlobalAddMonster;
import com.tann.dice.util.Tann;
import java.util.ArrayList;
import java.util.List;

public class AlternateModifier {
    public static List<Modifier> showMonsterMods(MonsterType mt) {
        ArrayList<Modifier> result = new ArrayList<Modifier>();
        for (boolean b : Tann.BOTH) {
            result.add(GlobalSummonMonsterStartTurn.makeGenerated(mt, b));
            result.add(GlobalAddMonster.makeGenerated(mt, b));
        }
        result.add(PipeModSpirit.make(mt));
        for (int i = result.size() - 1; i >= 0; --i) {
            if (result.get(i) != null && !((Modifier)result.get(i)).isMissingno()) continue;
            result.remove(i);
        }
        return result;
    }

    public static List<Modifier> showHeroMods(HeroType ht) {
        ArrayList<Modifier> result = new ArrayList<Modifier>();
        result.add(ModifierLib.safeByName("add." + ht.getName()));
        for (int i = result.size() - 1; i >= 0; --i) {
            if (result.get(i) != null && !((Modifier)result.get(i)).isMissingno()) continue;
            result.remove(i);
        }
        return result;
    }

    public static List<Modifier> showItemMods(Item item) {
        ArrayList<Modifier> result = new ArrayList<Modifier>();
        for (boolean b : Tann.BOTH) {
            result.add(PipeModAllItem.makeItemAll(item, b));
        }
        result.add(PipeModPermaItem.make(item));
        for (int i = result.size() - 1; i >= 0; --i) {
            if (result.get(i) != null && !((Modifier)result.get(i)).isMissingno()) continue;
            result.remove(i);
        }
        return result;
    }
}

