/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.phase;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.tann.dice.Main;
import com.tann.dice.gameplay.context.DungeonContext;
import com.tann.dice.gameplay.fightLog.FightLog;
import com.tann.dice.gameplay.phase.PhaseManager;
import com.tann.dice.gameplay.phase.endPhase.runEnd.RunEndPhase;
import com.tann.dice.gameplay.phase.gameplay.DamagePhase;
import com.tann.dice.gameplay.phase.gameplay.EnemyRollingPhase;
import com.tann.dice.gameplay.phase.gameplay.PlayerRollingPhase;
import com.tann.dice.gameplay.phase.gameplay.TargetingPhase;
import com.tann.dice.gameplay.phase.levelEndPhase.LevelEndPanel;
import com.tann.dice.gameplay.phase.levelEndPhase.LevelEndPhase;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.MessagePhase;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.MissingnoPhase;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.challenge.ChallengePhase;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.ChoicePhase;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.SimpleChoicePhase;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.meta.BooleanPhase;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.meta.LinkedPhase;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.meta.MetaPhase;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.meta.SeqPhase;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.misc.HeroChangePhase;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.misc.ItemCombinePhase;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.misc.PositionSwapPhase;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.reveal.RandomRevealPhase;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.trade.TradePhase;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.resetPhase.ResetPhase;
import com.tann.dice.gameplay.trigger.global.phase.addPhase.phaseGen.PhaseProducer;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.screens.dungeon.panels.book.page.helpPage.HelpType;
import com.tann.dice.screens.dungeon.panels.tutorial.TutorialHolder;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.test.util.TestRunner;
import com.tann.dice.util.Colours;
import com.tann.dice.util.TannLog;
import com.tann.dice.util.TannStageUtils;
import com.tann.dice.util.ui.standardButton.StandardButton;
import java.util.Arrays;
import java.util.List;

public abstract class Phase
implements PhaseProducer {
    boolean activated;
    long switchStart = -1L;
    protected boolean fromSave;

    protected Phase() {
    }

    public void internalActivate() {
        if (!this.activated) {
            this.activated = true;
            boolean actual = this.checkedActivate();
            if (!actual) {
                return;
            }
        } else {
            this.reactivate();
        }
        if (DungeonScreen.get() != null) {
            DungeonScreen.get().enterPhase(this);
        }
    }

    private boolean checkedActivate() {
        try {
            this.activate();
            return true;
        }
        catch (Exception e) {
            if (TestRunner.isTesting()) {
                throw e;
            }
            Main.getCurrentScreen().popAllMedium();
            String ctx = "activating " + this.getClass().getSimpleName();
            TannLog.error(e, ctx);
            DungeonScreen.get().showDialog(e, ctx);
            PhaseManager.get().deletePhase(this);
            PhaseManager.get().activateCurrentPhase();
            return false;
        }
    }

    public void reactivate() {
    }

    public void hide() {
    }

    public abstract void activate();

    public abstract void deactivate();

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public final void checkIfDone() {
        if (this.doneCheck()) {
            if (this.switchStart == -1L) {
                this.switchStart = System.currentTimeMillis();
            }
            if (System.currentTimeMillis() - this.switchStart >= this.getSwitchingDelay()) {
                this.switchStart = -1L;
                PhaseManager.get().popPhase();
            }
        }
    }

    public void tick(float delta) {
    }

    public long getSwitchingDelay() {
        return 0L;
    }

    protected boolean doneCheck() {
        return false;
    }

    public boolean canRoll() {
        return false;
    }

    public boolean canTarget() {
        return false;
    }

    public void refreshPhase() {
    }

    public HelpType getHelpType() {
        return null;
    }

    public void confirmClicked(boolean fromClick) {
    }

    public String serialise() {
        String s = "Invalid phase to serialise " + this.getClass().getSimpleName();
        TannLog.log(s, TannLog.Severity.error);
        throw new RuntimeException(s);
    }

    public static Phase deserialise(String saved) {
        return Phase.deserialise(saved, true);
    }

    public static Phase deserialise(String saved, boolean safe) {
        Phase p = Phase.actuallyDeserialise(saved, safe);
        p.markFromSave();
        return p;
    }

    private void markFromSave() {
        this.fromSave = true;
    }

    private static Phase actuallyDeserialise(String saved, boolean safe) {
        char phaseId = saved.charAt(0);
        String data = saved.substring(1);
        try {
            switch (phaseId) {
                case '0': {
                    return new PlayerRollingPhase(data);
                }
                case '1': {
                    return new TargetingPhase(data);
                }
                case '2': {
                    return new LevelEndPhase(data);
                }
                case '3': {
                    return new EnemyRollingPhase();
                }
                case '4': {
                    return new MessagePhase(data);
                }
                case '5': {
                    return new HeroChangePhase(data);
                }
                case '6': {
                    return new ResetPhase();
                }
                case '7': {
                    return new ItemCombinePhase(data);
                }
                case '8': {
                    return new PositionSwapPhase(data);
                }
                case '9': {
                    return ChallengePhase.make(data);
                }
                case 'd': {
                    return new DamagePhase();
                }
                case 'e': {
                    return new RunEndPhase(data);
                }
                case 'm': {
                    return new MetaPhase(data);
                }
                case 't': {
                    return TradePhase.makeFrom(data);
                }
                case 's': {
                    return new SeqPhase(data);
                }
                case 'c': {
                    return new ChoicePhase(data);
                }
                case '!': {
                    return new SimpleChoicePhase(data);
                }
                case 'r': {
                    return new RandomRevealPhase(data);
                }
                case 'l': {
                    return new LinkedPhase(data);
                }
                case 'b': {
                    return new BooleanPhase(data);
                }
                case 'x': {
                    return new MissingnoPhase(data);
                }
            }
            Phase.defaultWithError(null, saved, safe);
        }
        catch (Exception e) {
            return Phase.defaultWithError(e, saved, safe);
        }
        return Phase.defaultWithError(null, saved, safe);
    }

    private static Phase defaultWithError(Exception e, String fromString, boolean safe) {
        String errString = "err creating phase from " + fromString;
        if (e != null) {
            e.printStackTrace();
            errString = e.getClass().getSimpleName() + errString;
        }
        TannLog.error(errString);
        if (safe) {
            return new MissingnoPhase(errString);
        }
        throw new RuntimeException(errString);
    }

    public void positionTutorial(TutorialHolder tutorialHolder) {
    }

    public final StandardButton getLevelEndButton() {
        return this.getLevelEndButtonInternal();
    }

    protected StandardButton getLevelEndButtonInternal() {
        return new StandardButton(this.getClass().getSimpleName());
    }

    public boolean hasActivated() {
        return this.activated;
    }

    public void reset() {
        this.activated = false;
    }

    public boolean highlightDice() {
        return false;
    }

    public boolean keyPress(int keycode) {
        switch (keycode) {
            case 37: {
                if (TannStageUtils.isMouseHeld()) {
                    Sounds.playSound(Sounds.flap);
                    return true;
                }
                if (!this.showCornerInventory()) break;
                LevelEndPanel.showPartyPanel();
                return true;
            }
        }
        return false;
    }

    public boolean canEquip() {
        return this.showCornerInventory();
    }

    public boolean showCornerInventory() {
        return false;
    }

    public Color getLevelEndColour() {
        return Colours.pink;
    }

    public boolean isPositive() {
        return false;
    }

    protected FightLog getFightLog() {
        return DungeonScreen.get().getFightLog();
    }

    protected DungeonContext getContext() {
        return this.getFightLog().getContext();
    }

    public boolean requiresSerialisation() {
        return true;
    }

    public boolean isDuringCombat() {
        return false;
    }

    public abstract boolean canSave();

    public boolean isPastey() {
        return this.canSave();
    }

    public boolean canFlee() {
        return false;
    }

    @Override
    public List<Phase> get(DungeonContext dc) {
        return Arrays.asList(this);
    }

    public boolean disallowRescale() {
        return false;
    }

    public Actor makeDungeonActor() {
        return null;
    }

    public boolean showTargetButton() {
        return false;
    }

    public boolean isInvalid() {
        return false;
    }

    public boolean updateDice() {
        return this.canRoll();
    }

    public Phase copy() {
        return Phase.deserialise(this.serialise());
    }
}

