/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.challenge;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.tann.dice.Main;
import com.tann.dice.gameplay.battleTest.Zone;
import com.tann.dice.gameplay.battleTest.testProvider.TierStats;
import com.tann.dice.gameplay.content.ent.Hero;
import com.tann.dice.gameplay.content.ent.Monster;
import com.tann.dice.gameplay.content.ent.type.MonsterType;
import com.tann.dice.gameplay.content.ent.type.lib.MonsterTypeLib;
import com.tann.dice.gameplay.context.DungeonContext;
import com.tann.dice.gameplay.fightLog.FightLog;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.challenge.ChallengePhase;
import com.tann.dice.gameplay.progress.chievo.unlock.UnUtil;
import com.tann.dice.screens.dungeon.panels.Explanel.DiePanel;
import com.tann.dice.screens.dungeon.panels.book.views.MonsterLedgerView;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.ChanceHaver;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Tann;
import com.tann.dice.util.lang.Words;
import com.tann.dice.util.listener.TannListener;
import java.util.ArrayList;
import java.util.List;

public class ChallengeType {
    List<String> extraMonsters;

    public ChallengeType(List<String> extraMonsters) {
        this.extraMonsters = extraMonsters;
    }

    public ChallengeType() {
    }

    public static ChallengeType generate(ChallengePhase.ChallengeDifficulty challengeDifficulty, int currentLevelNumber) {
        int attempts = 10;
        for (int attempt = 0; attempt < attempts; ++attempt) {
            ChallengeType challengeType = ChallengeType.generateHandPicked(currentLevelNumber, challengeDifficulty);
            if (challengeType == null) continue;
            return challengeType;
        }
        return null;
    }

    public static ChallengeType generateHandPicked(int currentLevelNumber, ChallengePhase.ChallengeDifficulty challengeDifficulty) {
        float levelRatio = TierStats.getLevelRatio(currentLevelNumber);
        switch (challengeDifficulty) {
            case Easy: {
                List<MonsterType> options = Tann.asList(MonsterTypeLib.byName("slimelet"), MonsterTypeLib.byName("rat"), MonsterTypeLib.byName("archer"), MonsterTypeLib.byName("caw egg"), MonsterTypeLib.byName("dragon egg"), MonsterTypeLib.byName("Illusion"));
                for (int i = options.size() - 1; i >= 0; --i) {
                    if (!UnUtil.isLocked(options.get(i))) continue;
                    options.remove(i);
                }
                ArrayList<MonsterType> actual = new ArrayList<MonsterType>();
                MonsterType chosen = (MonsterType)Tann.randomChanced((ChanceHaver[])options.toArray(new MonsterType[0]));
                int amt = Math.round(Math.max(1.0f, levelRatio / chosen.getSummonValue() * 2.4f));
                for (int i = 0; i < amt; ++i) {
                    actual.add(chosen);
                }
                return new ChallengeType(MonsterTypeLib.serialise(actual));
            }
            case Standard: {
                float rand = Tann.random();
                Zone lt = Zone.guessFromLevel(currentLevelNumber);
                ArrayList<MonsterType> validMonsters = new ArrayList<MonsterType>();
                for (MonsterType mt : lt.validMonsters) {
                    if (UnUtil.isLocked(mt) || !mt.isAllowedInChallenges() || !mt.validRarity(rand)) continue;
                    validMonsters.add(mt);
                }
                float targetStrength = (float)(4 + currentLevelNumber) * 0.33f;
                int ATTEMPTS = 1000;
                ArrayList<MonsterType> currentAttempt = new ArrayList<MonsterType>();
                for (int attempt = 0; attempt < 1000; ++attempt) {
                    currentAttempt.clear();
                    int amtToAdd = (int)(1.0 + Math.random() * 2.0);
                    for (int i = 0; i < amtToAdd; ++i) {
                        currentAttempt.add((MonsterType)Tann.random(validMonsters));
                    }
                    float strength = 0.0f;
                    for (MonsterType mt : currentAttempt) {
                        strength += mt.getSimulatedStrength();
                    }
                    if (!(strength >= targetStrength) || !(strength / targetStrength < 1.2f)) continue;
                    return new ChallengeType(MonsterTypeLib.serialise(currentAttempt));
                }
                currentAttempt.clear();
                for (int i = 0; i < 1 + currentLevelNumber / 4; ++i) {
                    currentAttempt.add(MonsterTypeLib.byName("missingno"));
                }
                return new ChallengeType(MonsterTypeLib.serialise(currentAttempt));
            }
        }
        return new ChallengeType(MonsterTypeLib.serialise(MonsterTypeLib.listName("bug")));
    }

    public List<MonsterType> getMonsterTypes() {
        ArrayList<MonsterType> monsters = new ArrayList<MonsterType>();
        for (String s : this.extraMonsters) {
            monsters.add(MonsterTypeLib.byName(s));
        }
        return monsters;
    }

    public Actor makeActor() {
        Pixl p = new Pixl(2);
        p.text("[text]Extra " + Words.plural("monster", this.getMonsterTypes().size())).row();
        for (final MonsterType mt : this.getMonsterTypes()) {
            MonsterLedgerView mav = new MonsterLedgerView(mt, false);
            mav.addListener(new TannListener(){

                @Override
                public boolean info(int button, float x, float y) {
                    Sounds.playSound(Sounds.pip);
                    DiePanel diePanel = new DiePanel(new Monster(mt));
                    Main.getCurrentScreen().push(diePanel, true, true, true, 0.7f);
                    Tann.center(diePanel);
                    return true;
                }
            });
            p.actor(mav, 100.0f);
        }
        return p.pix();
    }

    public void activate(FightLog fightLog) {
        DungeonContext context = fightLog.getContext();
        List<MonsterType> mTypes = context.getCurrentLevel().getMonsterList();
        mTypes.addAll(this.getMonsterTypes());
        ArrayList<Monster> result = new ArrayList<Monster>();
        for (MonsterType mt : mTypes) {
            result.add(new Monster(mt));
        }
        List<Hero> heroes = context.getParty().getHeroes();
        fightLog.resetDueToFiddling(heroes, result);
    }

    public float getPower() {
        float total = 0.0f;
        for (MonsterType monsterType : this.getMonsterTypes()) {
            total += monsterType.getSummonValue();
        }
        return total;
    }
}

