/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.meta;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.tann.dice.Main;
import com.tann.dice.gameplay.phase.Phase;
import com.tann.dice.gameplay.phase.PhaseManager;
import com.tann.dice.gameplay.phase.levelEndPhase.LevelEndData;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Tann;
import com.tann.dice.util.TannLog;
import com.tann.dice.util.listener.TannListener;
import com.tann.dice.util.ui.TextWriter;
import com.tann.dice.util.ui.standardButton.StandardButton;
import java.util.Arrays;
import java.util.List;

public class MetaPhase
extends Phase {
    final List<Phase> contained;
    Actor a;

    public MetaPhase(List<Phase> contained) {
        this.contained = contained;
    }

    public MetaPhase(Phase ... contained) {
        this(Arrays.asList(contained));
    }

    public MetaPhase(String saved) {
        this(Main.getJson().fromJson(LevelEndData.class, saved).makePhases());
    }

    @Override
    public String serialise() {
        return "m" + Main.getJson(true).toJson(new LevelEndData(this.contained));
    }

    @Override
    public void activate() {
        Sounds.playSound(Sounds.pip);
        final DungeonScreen ds = DungeonScreen.get();
        if (ds == null) {
            TannLog.error("Activating metaphase when not in dungeonscreen");
            return;
        }
        Pixl p = new Pixl(8, 8).border(Colours.grey);
        p.text("[text]Choose one only").row();
        for (final Phase ph : this.contained) {
            StandardButton butt = ph.getLevelEndButton();
            p.actor(butt, (float)Main.width * 0.5f);
            butt.addListener(new TannListener(){

                @Override
                public boolean action(int button, int pointer, float x, float y) {
                    MetaPhase.this.pickPhase(ph);
                    return true;
                }

                @Override
                public boolean info(int button, float x, float y) {
                    ds.showDialog(ph.getClass().getSimpleName());
                    return true;
                }
            });
        }
        this.a = p.pix();
        ds.addActor(this.a);
        Tann.center(this.a);
        Tann.slideIn(this.a, Tann.TannPosition.Top, (int)((float)(Main.height / 2) - this.a.getHeight() / 2.0f));
    }

    private void pickPhase(Phase ph) {
        Sounds.playSound(Sounds.pip);
        PhaseManager.get().forceNext(ph);
        PhaseManager.get().popPhase(this.getClass());
        DungeonScreen.get().save();
    }

    @Override
    public void deactivate() {
        Tann.slideAway(this.a, Tann.TannPosition.Bot, true);
    }

    @Override
    public boolean canSave() {
        return true;
    }

    @Override
    public Color getLevelEndColour() {
        return Colours.purple;
    }

    @Override
    protected StandardButton getLevelEndButtonInternal() {
        return new StandardButton(TextWriter.getTag(this.getLevelEndColour()) + "meta", this.getLevelEndColour(), 53, 20);
    }
}

