/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.progress;

import com.tann.dice.Main;
import com.tann.dice.gameplay.context.config.ContextConfig;
import com.tann.dice.gameplay.mode.Mode;
import com.tann.dice.gameplay.progress.RunHistoryData;
import com.tann.dice.gameplay.save.RunHistory;
import com.tann.dice.util.TannLog;
import com.tann.dice.util.saves.Prefs;
import java.util.ArrayList;
import java.util.List;

public class RunHistoryStore {
    private List<RunHistory> runHistoryList;

    public void addRunHistory(RunHistory rh) {
        this.runHistoryList.add(rh);
        while (this.runHistoryList.size() > 5000) {
            this.runHistoryList.remove(0);
        }
        this.saveAll();
    }

    public List<RunHistory> getRunHistoryList() {
        return this.runHistoryList;
    }

    public List<RunHistory> getRuns(Mode mode) {
        ArrayList<RunHistory> result = new ArrayList<RunHistory>();
        for (RunHistory rhd : this.runHistoryList) {
            if (!rhd.getModeName().equalsIgnoreCase(mode.getSaveKey())) continue;
            result.add(rhd);
        }
        return result;
    }

    public List<RunHistory> getRuns(ContextConfig config) {
        ArrayList<RunHistory> result = new ArrayList<RunHistory>();
        for (RunHistory rhd : this.runHistoryList) {
            if (!rhd.getModeAndDifficultyDescription().equalsIgnoreCase(config.getEndTitle())) continue;
            result.add(rhd);
        }
        return result;
    }

    public void loadAll() {
        RunHistoryData rhd = this.loadData();
        this.runHistoryList = new ArrayList<RunHistory>();
        if (rhd != null) {
            this.runHistoryList = rhd.runHistory;
        }
    }

    public void saveEdit() {
        this.saveAll();
    }

    private void saveAll() {
        RunHistoryData rhd = new RunHistoryData(this.runHistoryList);
        String json = Main.getJson(true).toJson(rhd);
        Prefs.setString("run_history", json);
    }

    private RunHistoryData loadData() {
        String save = Prefs.getString("run_history", "");
        if (save.isEmpty()) {
            return null;
        }
        try {
            return Main.getJson().fromJson(RunHistoryData.class, save);
        }
        catch (Exception e) {
            e.printStackTrace();
            TannLog.log("Failed to load run history  - " + e.getMessage(), TannLog.Severity.error);
            return null;
        }
    }

    public void reset() {
        this.runHistoryList.clear();
        this.saveAll();
    }
}

