/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.save;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.tann.dice.Main;
import com.tann.dice.gameplay.content.ent.type.lib.MonsterTypeLib;
import com.tann.dice.gameplay.context.DungeonContext;
import com.tann.dice.gameplay.context.config.ContextConfig;
import com.tann.dice.gameplay.context.config.ContextConfigUtils;
import com.tann.dice.gameplay.fightLog.FightLog;
import com.tann.dice.gameplay.phase.Phase;
import com.tann.dice.gameplay.save.LoadCrashException;
import com.tann.dice.gameplay.save.SaveStateData;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Tann;
import com.tann.dice.util.VersionUtils;
import com.tann.dice.util.online.BugReport;
import com.tann.dice.util.saves.Prefs;
import com.tann.dice.util.ui.TextWriter;
import com.tann.dice.util.ui.standardButton.StandardButton;
import java.util.List;

public class SaveState {
    public final DungeonContext dungeonContext;
    public final List<String> commandData;
    public final String sides;
    public final List<String> phases;
    public final String saveVersion;

    public SaveState(DungeonContext dungeonContext, List<String> commandData, String sides, List<String> phases) {
        this(dungeonContext, commandData, sides, phases, null);
    }

    public SaveState(DungeonContext dungeonContext, List<String> commandData, String sides, List<String> phases, String saveVersion) {
        this.dungeonContext = dungeonContext;
        this.commandData = commandData;
        this.sides = sides;
        this.phases = phases;
        this.saveVersion = saveVersion;
    }

    public String getSaveString() {
        return Main.getJson().toJson(this.toData());
    }

    public SaveStateData toData() {
        return new SaveStateData(this.dungeonContext.toData(), this.commandData, this.sides, this.phases);
    }

    public void save() {
        if (this.dungeonContext.getContextConfig().getGeneralSaveKey() == null) {
            throw new RuntimeException("trying to save a null save");
        }
        Prefs.setString(this.dungeonContext.getContextConfig().getGeneralSaveKey(), this.getSaveString());
        Main.getSettings().saveForHs();
    }

    public DungeonScreen makeDungeonScreen() {
        DungeonScreen ds = new DungeonScreen(this.dungeonContext, this.commandData, this.sides, this.phases, this.getSaveString());
        if ("ignore".equalsIgnoreCase(this.saveVersion)) {
            return ds;
        }
        Color col = Colours.red;
        String start = "Save created with";
        String end = "";
        String full = null;
        if (this.saveVersion == null) {
            col = Colours.grey;
            full = start + " unknown version" + end;
        } else if (!this.saveVersion.equals(VersionUtils.PASTE_VERSION)) {
            full = start + " " + this.saveVersion + end;
        }
        if (full != null) {
            if (this.saveVersion != null) {
                full = full + "[n][grey](your version is " + VersionUtils.PASTE_VERSION + ")";
            }
            full = TextWriter.getTag(col) + full;
            ds.abilityHolder.addWisp(full, 2.3f);
        }
        return ds;
    }

    public void start() {
        try {
            Main.self().setScreen(this.makeDungeonScreen());
        }
        catch (LoadCrashException lce) {
            Group panel = BugReport.makeBugReportPanel("[red]Load error", "[text]Something broke loading your save, sorry... Send a bug report?", "crashed loading savestate-", false);
            Main.getCurrentScreen().push(panel, 0.7f);
            Tann.center(panel);
        }
    }

    public static SaveState load(String saveFileKey) {
        if (saveFileKey == null) {
            throw new RuntimeException("trying to load a null save");
        }
        String save = Prefs.getString(saveFileKey, null);
        if (save == null) {
            return null;
        }
        return SaveState.loadRawString(save);
    }

    public static SaveState loadRawString(String raw) {
        return SaveState.loadRawString(raw, null);
    }

    public static SaveState loadPasteModeString(String raw, boolean replaceWithPasteConfig) {
        return SaveState.loadRawString(raw, replaceWithPasteConfig ? "PasteConfig" : null);
    }

    public static SaveState loadRawString(String raw, String replacementCCString) {
        if (raw.contains("{")) {
            raw = raw.substring(raw.indexOf(123));
        }
        if (raw.contains("}")) {
            raw = raw.substring(0, raw.lastIndexOf(125) + 1);
        }
        SaveStateData ssd = Main.getJson().fromJson(SaveStateData.class, raw);
        if (ssd.d.cc != null && replacementCCString != null && !ssd.d.cc.equalsIgnoreCase(replacementCCString) && !replacementCCString.equalsIgnoreCase("storedconfig")) {
            throw new RuntimeException("Invalid paste: msp");
        }
        if (replacementCCString != null || ssd.d.cc == null) {
            ssd.d.cc = replacementCCString;
        }
        return ssd.toState();
    }

    public static boolean hasSave(String saveFileKey) {
        return Prefs.getString(saveFileKey, null) != null;
    }

    public static Group getLoadButton(final String saveFileKey) {
        try {
            String contString = SaveState.loadSaveButtonText(saveFileKey);
            if (contString == null) {
                return null;
            }
            StandardButton loadSave = new StandardButton(contString);
            loadSave.setRunnable(new Runnable(){

                @Override
                public void run() {
                    Sounds.playSound(Sounds.pip);
                    SaveState.load(saveFileKey).start();
                }
            });
            return loadSave;
        }
        catch (Exception e) {
            e.printStackTrace();
            Pixl p = new Pixl(1, 1).fill(Colours.dark);
            p.text("oops, failed to load save").row();
            return p.pix();
        }
    }

    public static DungeonContext loadContext(String saveFileKey) {
        String save = Prefs.getString(saveFileKey, null);
        if (save == null) {
            return null;
        }
        return SaveState.load((String)saveFileKey).dungeonContext;
    }

    public static String loadSaveButtonText(String saveFileKey) {
        String save = Prefs.getString(saveFileKey, null);
        if (save == null) {
            return null;
        }
        SaveStateData ssd = Main.getJson().fromJson(SaveStateData.class, save);
        int level = ssd.d.n;
        ContextConfig cc = ContextConfigUtils.fromJson(ssd.d.cc, ssd.d.c);
        return "[text]Continue (fight " + level + cc.getSaveFileButtonName() + "[p])";
    }

    public FightLog makeFightLog() {
        return new FightLog(this.dungeonContext.getParty().getHeroes(), MonsterTypeLib.monsterList(this.dungeonContext.getCurrentLevel().getMonsterList()), this.commandData, this.sides, this.dungeonContext);
    }

    public boolean validForPaste() {
        Phase p = Phase.deserialise(this.phases.get(0));
        return p.isPastey();
    }
}

