/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.trigger.global.item;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.tann.dice.Main;
import com.tann.dice.gameplay.content.item.Item;
import com.tann.dice.gameplay.context.DungeonContext;
import com.tann.dice.gameplay.phase.PhaseManager;
import com.tann.dice.gameplay.phase.levelEndPhase.LevelEndPhase;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.ChoicePhase;
import com.tann.dice.gameplay.trigger.global.Global;
import com.tann.dice.statics.Images;
import com.tann.dice.util.Colours;
import com.tann.dice.util.ImageActor;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Tann;
import com.tann.dice.util.lang.Words;
import com.tann.dice.util.ui.choice.ChoiceDialog;
import java.util.Arrays;
import java.util.List;

public class GlobalStartWithItem
extends Global {
    public static long SWI_COLL = 0L;
    final Item[] items;
    final boolean blessing;

    public GlobalStartWithItem(Item ... items) {
        this.items = items;
        if (items.length == 0) {
            throw new RuntimeException("invalid trigger");
        }
        this.blessing = items[0].getTier() >= 0;
    }

    public static String nameFor(String name) {
        return "i." + name;
    }

    @Override
    public String describeForSelfBuff() {
        String colTag = this.blessing ? "[green]" : "[purple]";
        return colTag + "(permanent " + Words.plural("item", this.items.length) + ")[cu]";
    }

    @Override
    public void onPick(DungeonContext context) {
        context.getParty().addItems(Arrays.asList(this.items));
        GlobalStartWithItem.onPickItem();
    }

    public static void onPickItem() {
        PhaseManager pm = PhaseManager.get();
        boolean hasAlready = pm.has(LevelEndPhase.class);
        if (!hasAlready) {
            pm.pushPhaseAfter(new LevelEndPhase(true), ChoicePhase.class);
        }
    }

    @Override
    public List<Item> getStartingItems(DungeonContext dc) {
        return Arrays.asList(this.items);
    }

    @Override
    public Actor makePanelActorI(boolean big) {
        boolean[] blArray = Tann.BOTH_R;
        int n = blArray.length;
        for (int i = 0; i < n; ++i) {
            Boolean b = blArray[i];
            Pixl p = new Pixl();
            for (int i2 = 0; i2 < this.items.length; ++i2) {
                if (i2 > 0) {
                    p.gap(2);
                }
                Item e = this.items[i2];
                if (big) {
                    p.actor(e.makeChoosableActor(b, 0), (int)((float)Main.width * 0.8f));
                    continue;
                }
                p.actor(Tann.combineActors(e.makeImageActor(), new ImageActor(Images.itemBorder, Colours.grey)));
            }
            Group g = p.pix();
            if (ChoiceDialog.tooBig(g, 0.8f)) continue;
            return g;
        }
        if (big) {
            return this.makePanelActor(false);
        }
        return new Pixl().text("broekn").pix();
    }

    @Override
    public long getCollisionBits(Boolean player) {
        long bit = SWI_COLL;
        for (Item e : this.items) {
            bit |= e.getCollisionBits();
        }
        return bit;
    }

    @Override
    public boolean skipTest() {
        return true;
    }

    @Override
    public boolean isOnPick() {
        return true;
    }
}

