/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.trigger.global.level;

import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.tann.dice.Main;
import com.tann.dice.gameplay.content.ent.Monster;
import com.tann.dice.gameplay.content.ent.type.MonsterType;
import com.tann.dice.gameplay.content.ent.type.lib.MonsterTypeLib;
import com.tann.dice.gameplay.context.DungeonContext;
import com.tann.dice.gameplay.modifier.Modifier;
import com.tann.dice.gameplay.trigger.global.Global;
import com.tann.dice.gameplay.trigger.global.chance.Rarity;
import com.tann.dice.gameplay.trigger.global.scaffolding.levelRequirement.GlobalLevelRequirement;
import com.tann.dice.gameplay.trigger.global.scaffolding.levelRequirement.LevelRequirementFinal;
import com.tann.dice.gameplay.trigger.global.scaffolding.levelRequirement.LevelRequirementRange;
import com.tann.dice.screens.dungeon.panels.Explanel.DiePanel;
import com.tann.dice.statics.Images;
import com.tann.dice.util.Colours;
import com.tann.dice.util.ImageActor;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Tann;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GlobalSetMonsters
extends Global {
    final MonsterType[] types;

    public GlobalSetMonsters(MonsterType ... types) {
        this.types = types;
    }

    @Override
    public String describeForSelfBuff() {
        if (this.types.length == 0) {
            return "err";
        }
        String start = "Fight";
        String end = "instead";
        if (GlobalSetMonsters.onlyOneType(Arrays.asList(this.types))) {
            String middle = "a " + this.types[0].getName(true).toLowerCase();
            if (this.types.length > 1) {
                middle = this.types.length + "x " + this.types[0].getName(true).toLowerCase();
            }
            return start + " " + middle + " " + end;
        }
        String result = start + " ";
        for (int i = 0; i < this.types.length; ++i) {
            String monName = this.types[i].getName(true).toLowerCase();
            result = result + monName;
            if (i < this.types.length - 2) {
                result = result + ", ";
                continue;
            }
            if (i >= this.types.length - 1) continue;
            result = result + " and ";
        }
        return result + " " + end;
    }

    @Override
    public void affectStartMonsters(List<Monster> monsters) {
        monsters.clear();
        for (MonsterType t : this.types) {
            monsters.add(t.makeEnt());
        }
    }

    @Override
    public Actor makePanelActorI(boolean big) {
        return this.makeBaseActor(big);
    }

    protected Actor makeBaseActor(boolean big) {
        int gap = 2;
        if (big) {
            Pixl p = new Pixl(0);
            Actor a = this.types.length == 1 ? new DiePanel(this.types[0].makeEnt()).withoutDice().getFullActor() : GlobalSetMonsters.multiMonsterPortraits(Arrays.asList(this.types));
            p.actor(a, Main.width / 2);
            return p.pix();
        }
        Pixl p = new Pixl(0);
        p.image(Images.equalsBig, Colours.green).gap(2);
        p.actor(GlobalSetMonsters.multiMonsterPortraits(Arrays.asList(this.types)));
        return p.pix();
    }

    public static boolean onlyOneType(List<MonsterType> types) {
        types = new ArrayList<MonsterType>(types);
        Tann.uniquify(types);
        return types.size() == 1;
    }

    private static Actor multiMonsterPortraits(List<MonsterType> types) {
        if (types.size() == 0) {
            return new Actor();
        }
        if (types.size() == 1) {
            return new ImageActor((TextureRegion)types.get((int)0).portrait, true);
        }
        if (GlobalSetMonsters.onlyOneType(types)) {
            return new Pixl().text(types.size() + "x").gap(1).image(types.get((int)0).portrait).pix();
        }
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < types.size(); ++i) {
            names.add(types.get(i).getName(false));
        }
        Tann.uniquify(names);
        int gap = 2;
        Pixl p = new Pixl();
        for (int i = 0; i < types.size(); ++i) {
            p.image((TextureRegion)types.get((int)i).portrait, true);
            if (i >= types.size() - 1) continue;
            p.gap(2);
        }
        return p.pix();
    }

    @Override
    public void onPick(DungeonContext context) {
        this.resetFightLogOnPick();
    }

    @Override
    public boolean skipTest() {
        return true;
    }

    @Override
    public boolean allTurnsOnly() {
        return true;
    }

    public static List<Modifier> makeGeneratedBlessings() {
        ArrayList<Modifier> result = new ArrayList<Modifier>();
        result.addAll(Arrays.asList(new Modifier(3.0f, "Anticlimax", new GlobalLevelRequirement(new LevelRequirementFinal(), new GlobalSetMonsters(MonsterTypeLib.byName("Illusion")))).rarity(Rarity.FIFTIETH)));
        return result;
    }

    public static List<Modifier> makeDesigned() {
        ArrayList<Modifier> result = new ArrayList<Modifier>();
        result.addAll(Arrays.asList(new Modifier(-1.0f, "Bossilisk", new GlobalLevelRequirement(new LevelRequirementRange(4), new GlobalSetMonsters(MonsterTypeLib.byNames("basilisk", "basilisk")))), new Modifier(-2.0f, "Rude Awakening", new GlobalLevelRequirement(new LevelRequirementRange(1), new GlobalSetMonsters(MonsterTypeLib.byNames("alpha", "wolf")))).rarity(Rarity.HALF), new Modifier(-2.0f, "RNG Nest", new GlobalLevelRequirement(new LevelRequirementRange(3), new GlobalSetMonsters(MonsterTypeLib.byNames("dragon egg", "dragon egg", "dragon egg")))).rarity(Rarity.HUNDREDTH)));
        return result;
    }
}

