/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.trigger.global.linked;

import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.tann.dice.gameplay.content.ent.Ent;
import com.tann.dice.gameplay.content.ent.type.EntType;
import com.tann.dice.gameplay.content.ent.type.MonsterType;
import com.tann.dice.gameplay.fightLog.EntState;
import com.tann.dice.gameplay.trigger.global.linked.DipPanel;
import com.tann.dice.gameplay.trigger.global.linked.GlobalLinked;
import com.tann.dice.gameplay.trigger.personal.Personal;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Tann;
import java.util.Arrays;
import java.util.List;

public class GlobalSpecificEntTypes
extends GlobalLinked {
    final List<EntType> types;
    final Personal personal;

    public GlobalSpecificEntTypes(Personal personal, EntType ... types) {
        super(personal);
        this.personal = personal;
        this.types = Arrays.asList(types);
    }

    public GlobalSpecificEntTypes(EntType type, Personal personal) {
        this(personal, type);
    }

    @Override
    public String describeForSelfBuff() {
        return Tann.commaList(this.types) + ":[n]" + this.personal.describeForSelfBuff();
    }

    @Override
    public Personal getLinkedTrigger(EntState entState) {
        Ent de = entState.getEnt();
        if (this.types.contains(de.entType)) {
            return this.personal;
        }
        return super.getLinkedTrigger(entState);
    }

    @Override
    public Actor makePanelActorI(boolean big) {
        Pixl exception = new Pixl(0);
        for (EntType t : this.types) {
            exception.image((TextureRegion)t.portrait, t instanceof MonsterType).gap(1);
        }
        exception.cancelRowGap();
        return DipPanel.makeSidePanelGroup(big, (Actor)exception.pix(), this.personal, Colours.red);
    }

    @Override
    public long getCollisionBits(Boolean player) {
        return this.personal.getCollisionBits(false);
    }
}

