/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.trigger.global.phase.addPhase.phaseGen;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.tann.dice.gameplay.context.DungeonContext;
import com.tann.dice.gameplay.phase.Phase;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.challenge.ChallengePhase;
import com.tann.dice.gameplay.trigger.global.phase.addPhase.phaseGen.PhaseGeneratorChallenge;
import com.tann.dice.gameplay.trigger.global.phase.addPhase.phaseGen.PhaseGeneratorLevelup;
import com.tann.dice.gameplay.trigger.global.phase.addPhase.phaseGen.PhaseGeneratorMeta;
import com.tann.dice.gameplay.trigger.global.phase.addPhase.phaseGen.PhaseGeneratorPositionSwap;
import com.tann.dice.gameplay.trigger.global.phase.addPhase.phaseGen.PhaseGeneratorReroll;
import com.tann.dice.gameplay.trigger.global.phase.addPhase.phaseGen.PhaseGeneratorStandardLoot;
import com.tann.dice.gameplay.trigger.global.phase.addPhase.phaseGen.PhaseGeneratorTrade;
import com.tann.dice.gameplay.trigger.global.phase.addPhase.phaseGen.PhaseGeneratorTweakPick;
import com.tann.dice.gameplay.trigger.global.phase.addPhase.phaseGen.PhaseProducer;
import java.util.List;
import java.util.Random;

public abstract class PhaseGenerator
implements PhaseProducer {
    protected abstract List<Phase> generate(DungeonContext var1);

    @Override
    public List<Phase> get(DungeonContext dc) {
        return this.generate(dc);
    }

    public String describe() {
        return this.getClass().getSimpleName().toLowerCase().replaceAll("phasegenerator", "") + " phase";
    }

    public static PhaseGenerator rpg(Random r) {
        return PhaseGenerator.indexed(r.nextInt(11));
    }

    public static PhaseGenerator indexed(int index) {
        switch (index) {
            case 0: {
                return new PhaseGeneratorLevelup();
            }
            case 1: {
                return new PhaseGeneratorStandardLoot();
            }
            case 2: {
                return new PhaseGeneratorReroll();
            }
            case 3: {
                return new PhaseGeneratorMeta();
            }
            case 4: {
                return new PhaseGeneratorTweakPick();
            }
            case 5: {
                return new PhaseGeneratorPositionSwap();
            }
            case 6: {
                return new PhaseGeneratorChallenge(ChallengePhase.ChallengeDifficulty.Standard);
            }
            case 7: {
                return new PhaseGeneratorChallenge(ChallengePhase.ChallengeDifficulty.Easy);
            }
            case 8: {
                return new PhaseGeneratorPositionSwap();
            }
            case 9: {
                return new PhaseGeneratorTrade();
            }
        }
        return new PhaseGeneratorStandardLoot();
    }

    public long getCollisionBits(Boolean player) {
        return 0L;
    }

    public Actor makePanel() {
        return null;
    }

    public String hyphenTag() {
        return null;
    }
}

