/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.trigger.global.spell;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.tann.dice.gameplay.effect.eff.Eff;
import com.tann.dice.gameplay.effect.eff.keyword.Keyword;
import com.tann.dice.gameplay.trigger.Collision;
import com.tann.dice.gameplay.trigger.global.Global;
import com.tann.dice.statics.Images;
import com.tann.dice.util.Colours;
import com.tann.dice.util.ImageActor;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Tann;
import com.tann.dice.util.ui.TextWriter;
import java.util.Collections;
import java.util.List;

public class GlobalSpellKeyword
extends Global {
    final String spellName;
    final Keyword keyword;

    public GlobalSpellKeyword(Keyword addKeyword) {
        this(null, addKeyword);
    }

    public GlobalSpellKeyword(String spellName, Keyword addKeyword) {
        if (!addKeyword.spellOnly()) {
            throw new RuntimeException("Adding " + (Object)((Object)addKeyword) + " to spells");
        }
        this.spellName = spellName;
        this.keyword = addKeyword;
    }

    @Override
    public String describeForSelfBuff() {
        String result = "Add " + this.keyword.getColourTaggedString();
        result = result + " to [blue]";
        if (this.spellName == null) {
            return result + "all spells";
        }
        return result + this.spellName;
    }

    @Override
    public Actor makePanelActorI(boolean big) {
        ImageActor ia = new ImageActor(Images.tr_manaSpellBottom, Colours.blue);
        Group g = Tann.makeGroup(ia);
        TextWriter tw = new TextWriter("[grey]+[p]" + this.keyword.getColourTaggedString());
        g.addActor(tw);
        tw.setPosition((int)(g.getWidth() / 2.0f - tw.getWidth() / 2.0f), (int)(8.0f - tw.getHeight() / 2.0f));
        if (this.spellName != null) {
            g = new Pixl().text("[blue]" + this.spellName).row(2).actor(g).pix();
        }
        return g;
    }

    @Override
    public void affectSpell(String title, Eff result) {
        if (this.spellName != null && !title.equalsIgnoreCase(this.spellName)) {
            return;
        }
        result.addKeyword(this.keyword);
    }

    @Override
    public List<Keyword> getReferencedKeywords() {
        return Collections.singletonList(this.keyword);
    }

    @Override
    public long getCollisionBits(Boolean player) {
        return Collision.SPELL;
    }
}

