/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.trigger.personal;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.tann.dice.gameplay.content.ent.type.EntType;
import com.tann.dice.gameplay.effect.eff.Eff;
import com.tann.dice.gameplay.effect.eff.EffBill;
import com.tann.dice.gameplay.effect.eff.TargetingType;
import com.tann.dice.gameplay.effect.targetable.SimpleTargetable;
import com.tann.dice.gameplay.effect.targetable.Targetable;
import com.tann.dice.gameplay.fightLog.EntState;
import com.tann.dice.gameplay.fightLog.Snapshot;
import com.tann.dice.gameplay.fightLog.event.entState.StateEvent;
import com.tann.dice.gameplay.trigger.personal.Dodge;
import com.tann.dice.gameplay.trigger.personal.Personal;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.AffectSides;
import com.tann.dice.gameplay.trigger.personal.position.BackRow;
import com.tann.dice.util.Pixl;

public class OnDamage
extends Personal {
    final Eff triggeredEff;
    final boolean first;
    final StateEvent event;

    public OnDamage(Eff triggeredEff, boolean first, StateEvent event) {
        this.triggeredEff = triggeredEff;
        this.first = first;
        this.event = event;
    }

    @Override
    public Actor makePanelActorI(boolean big) {
        Pixl p = new Pixl();
        if (this.first) {
            p.text("[grey](1st").gap(1);
        }
        p.actor(new EffBill().damage(1).bEff().getBasicImage(""));
        if (this.first) {
            p.text("[grey])");
        }
        p.gap(3).text(":").gap(3);
        p.actor(this.triggeredEff.getBasicImage());
        return p.pix();
    }

    @Override
    protected boolean showInEntPanelInternal() {
        return true;
    }

    @Override
    public String getImageName() {
        switch (this.triggeredEff.getType()) {
            case Buff: {
                Personal t = this.triggeredEff.getBuff().trigger;
                if (t instanceof Dodge) {
                    return "ghostly";
                }
                if (!(t instanceof BackRow)) break;
                return "feather";
            }
            case Shield: {
                return "onDamageShield";
            }
        }
        return super.getImageName();
    }

    @Override
    public String describeForSelfBuff() {
        String s = this.first ? "After taking damage for the first time each turn, " : "After taking damage, ";
        return s + this.triggeredEff.describe().toLowerCase();
    }

    @Override
    public void damageTaken(EntState source, EntState self, Snapshot snapshot, int damage, int damageTakenThisTurn, Eff sourceEff, Targetable targetable, int minTriggerPipHp) {
        if (this.first && damageTakenThisTurn != damage) {
            return;
        }
        if (this.triggeredEff.needsTarget() || this.triggeredEff.getTargetingType() == TargetingType.Self) {
            self.hit(this.triggeredEff, self.getEnt());
        } else {
            snapshot.target(null, new SimpleTargetable(self.getEnt(), this.triggeredEff), false);
        }
        if (this.event != null && this.event.chance()) {
            self.addEvent(this.event);
        }
    }

    @Override
    public float affectStrengthCalc(float total, float avgRawValue, EntType type) {
        switch (this.triggeredEff.getType()) {
            case Buff: {
                Personal t = this.triggeredEff.getBuff().trigger;
                if (t instanceof BackRow) {
                    return total;
                }
                if (t instanceof AffectSides) {
                    return total * ((avgRawValue - 0.7f) / avgRawValue);
                }
                if (!(t instanceof Dodge)) break;
                return total;
            }
        }
        return super.affectStrengthCalc(total, avgRawValue, type);
    }

    @Override
    public float affectTotalHpCalc(float hp, EntType entType) {
        switch (this.triggeredEff.getType()) {
            case Buff: {
                Personal t = this.triggeredEff.getBuff().trigger;
                if (t instanceof AffectSides) {
                    return hp;
                }
                if (t instanceof BackRow) {
                    return hp * 1.17f;
                }
                if (!(t instanceof Dodge)) break;
                return hp * 1.6f;
            }
        }
        return super.affectTotalHpCalc(hp, entType);
    }

    @Override
    public int calcBackRowTurn() {
        switch (this.triggeredEff.getType()) {
            case Buff: {
                Personal t = this.triggeredEff.getBuff().trigger;
                if (!(t instanceof BackRow)) break;
                return 1;
            }
        }
        return super.calcBackRowTurn();
    }

    @Override
    public long getCollisionBits(Boolean player) {
        return this.triggeredEff.getCollisionBits(player);
    }

    @Override
    public boolean isMultiplable() {
        return true;
    }
}

