/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.trigger.personal.affectSideModular;

import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.tann.dice.gameplay.effect.eff.Eff;
import com.tann.dice.gameplay.effect.eff.keyword.Keyword;
import com.tann.dice.gameplay.fightLog.EntSideState;
import com.tann.dice.gameplay.fightLog.EntState;
import com.tann.dice.gameplay.trigger.Collision;
import com.tann.dice.gameplay.trigger.personal.Personal;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.EffectDraw;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.GenericView;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.RandomSidesView;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.condition.AffectSideCondition;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.condition.SpecificSidesCondition;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.condition.SpecificSidesType;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.condition.StateConditionSideCondition;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.condition.TypeCondition;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.effect.AddKeyword;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.effect.AffectSideEffect;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.effect.Flip;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.effect.ReplaceWith;
import com.tann.dice.gameplay.trigger.personal.linked.stateCondition.GenericStateCondition;
import com.tann.dice.statics.Images;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Colours;
import com.tann.dice.util.ImageActor;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Tann;
import com.tann.dice.util.ui.TextWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AffectSides
extends Personal {
    public static final String TO_FROM_SKIP = "SKIP";
    final List<AffectSideCondition> conditions;
    final List<AffectSideEffect> effects;
    boolean combatPriority;
    boolean monsterPassivePriority;
    boolean heroPassivePriority;
    boolean mimicPriority;
    Boolean show;

    @Override
    protected TextureRegion overrideImage() {
        for (AffectSideEffect effect : this.effects) {
            if (effect.overrideImage() == null) continue;
            return effect.overrideImage();
        }
        return null;
    }

    public AffectSides(AffectSideEffect ... affectSide) {
        this(new ArrayList<AffectSideCondition>(), Arrays.asList(affectSide));
    }

    public AffectSides(AffectSideCondition a, AffectSideCondition b, AffectSideEffect c) {
        this(Arrays.asList(a, b), Arrays.asList(c));
    }

    public AffectSides(AffectSideCondition affectSideCondition, AffectSideEffect ... affectSide) {
        this(Arrays.asList(affectSideCondition), Arrays.asList(affectSide));
    }

    public AffectSides(GenericStateCondition stateCondition, AffectSideEffect ... affectSide) {
        this((AffectSideCondition)new StateConditionSideCondition(stateCondition), affectSide);
    }

    public AffectSides(SpecificSidesType specificSidesType, AffectSideEffect ... affectSide) {
        this(Arrays.asList(new SpecificSidesCondition(specificSidesType)), Arrays.asList(affectSide));
    }

    public AffectSides(List<AffectSideCondition> conditions, List<AffectSideEffect> effects) {
        this.conditions = conditions;
        this.effects = effects;
    }

    @Override
    public String describeForSelfBuff() {
        String desc;
        int n;
        ArrayList<String> effects = new ArrayList<String>();
        String toFrom = "to";
        for (AffectSideEffect affectSideEffect : this.effects) {
            String override = affectSideEffect.getOverrideDescription(this.conditions, this.effects);
            if (override != null) {
                return override;
            }
            String desc2 = affectSideEffect.describe();
            if (desc2 != null) {
                effects.add(desc2);
            }
            if (affectSideEffect.getToFrom() == null) continue;
            toFrom = affectSideEffect.getToFrom();
        }
        String result = "";
        for (AffectSideCondition con : this.conditions) {
            if (!con.describeFirst()) continue;
            result = result + con.describe();
        }
        result = result + Tann.commaList(effects);
        if (toFrom != null && !toFrom.equals(TO_FROM_SKIP)) {
            result = result + " " + toFrom;
        }
        if ((n = this.conditions.size()) == 0) {
            return result + " all sides";
        }
        effects.clear();
        boolean hasSpecificSides = false;
        boolean single = false;
        for (AffectSideCondition asc : this.conditions) {
            if (asc.isAfterSides() || asc.describeFirst()) continue;
            if (asc instanceof SpecificSidesCondition) {
                hasSpecificSides = true;
                SpecificSidesCondition ssc = (SpecificSidesCondition)asc;
                boolean bl = single = ssc.specificSidesType.sideIndices.length == 1;
            }
            if ((desc = asc.describe()) == null) continue;
            effects.add(desc);
        }
        if (!hasSpecificSides) {
            result = result + " all";
        }
        if (effects.size() > 0) {
            result = result + " " + Tann.commaList(effects, ", ", ", ");
        }
        if (!hasSpecificSides) {
            result = result + " side" + (single ? "" : "s");
        }
        effects.clear();
        for (AffectSideCondition asc : this.conditions) {
            if (!asc.isAfterSides() || asc.describeFirst() || (desc = asc.describe()) == null) continue;
            effects.add(desc);
        }
        if (effects.size() > 0) {
            result = result + " " + Tann.commaList(effects);
        }
        return result;
    }

    private boolean hasAnyAddGraphics() {
        for (AffectSideEffect ase : this.effects) {
            if (ase.getAddDraw(false, this.conditions) == null) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Actor makePanelActorI(boolean big) {
        void var8_20;
        EffectDraw addDraw;
        boolean notAlone = false;
        for (AffectSideEffect ase : this.effects) {
            Actor overrideActor = ase.getOverrideActor(this.conditions);
            if (overrideActor == null) continue;
            return overrideActor;
        }
        if (!this.hasAnyAddGraphics()) {
            return super.makePanelActorI(big);
        }
        boolean needsGraphic = false;
        boolean hasSideImage = false;
        boolean needsArrow = false;
        for (AffectSideCondition affectSideCondition : this.conditions) {
            needsGraphic |= affectSideCondition.needsGraphic();
            hasSideImage |= affectSideCondition.hasSideImage();
            needsArrow |= affectSideCondition.needsArrow();
        }
        for (AffectSideEffect affectSideEffect : this.effects) {
            needsGraphic |= affectSideEffect.needsGraphic();
        }
        if (!needsGraphic) {
            return super.makePanelActorI(big);
        }
        GenericView base = null;
        for (AffectSideCondition affectSideCondition : this.conditions) {
            GenericView testBase = affectSideCondition.getActor();
            if (testBase == null) continue;
            base = testBase;
            break;
        }
        if (base == null) {
            base = new RandomSidesView(1);
        }
        ArrayList<Actor> arrayList = new ArrayList<Actor>();
        for (AffectSideCondition asc : this.conditions) {
            addDraw = asc.getAddDraw();
            Actor precon = asc.getPrecon();
            if (addDraw != null) {
                base.addDraw(addDraw);
                continue;
            }
            if (precon != null) {
                arrayList.add(precon);
                continue;
            }
            if (asc.overrideDoesntNeedPrecon()) continue;
            arrayList.add(this.makeUnknownPrecondition(asc));
        }
        for (AffectSideEffect ase : this.effects) {
            addDraw = ase.getAddDraw(hasSideImage, this.conditions);
            notAlone |= addDraw.isNotAlone();
            if (addDraw == null) continue;
            base.addDraw(addDraw);
        }
        if (arrayList.size() > 0) {
            int gap = 2;
            Pixl p = new Pixl(0);
            for (Actor a : arrayList) {
                p.actor(a).gap(2);
            }
            if (needsArrow) {
                p.image(Images.arrowRight, Colours.light).gap(2);
            } else {
                p.text(":").gap(2);
            }
            p.actor(base);
            Group group = p.pix();
        } else {
            GenericView genericView = base;
        }
        if (notAlone) {
            var8_20.setName("notalone");
        }
        return var8_20;
    }

    private Actor makeUnknownPrecondition(AffectSideCondition asc) {
        return new TextWriter(asc.describe(), 40);
    }

    @Override
    public void affectSide(EntSideState sideState, EntState owner, int triggerIndex) {
        int index = -1;
        for (AffectSideCondition asc : this.conditions) {
            if (!asc.validFor(sideState, owner, triggerIndex)) {
                return;
            }
            if (index != -1) continue;
            index = asc.indexValid(sideState, owner);
        }
        for (AffectSideEffect affectSideEffect : this.effects) {
            affectSideEffect.affect(sideState, owner, index, this, triggerIndex);
        }
    }

    public AffectSides buffPriority() {
        this.combatPriority = true;
        return this;
    }

    public AffectSides mimicPriority() {
        this.mimicPriority = true;
        return this;
    }

    public AffectSides monsterPassivePriority() {
        this.monsterPassivePriority = true;
        return this;
    }

    public AffectSides heroPassivePriority() {
        this.heroPassivePriority = true;
        return this;
    }

    public AffectSides show(boolean show) {
        this.show = show;
        return this;
    }

    @Override
    public float getPriority() {
        if (this.mimicPriority) {
            return -11.0f;
        }
        if (this.heroPassivePriority) {
            return -11.0f;
        }
        if (this.monsterPassivePriority) {
            return -9.0f;
        }
        if (this.combatPriority) {
            return 0.0f;
        }
        if (this.buff != null) {
            return 0.0f;
        }
        return -10.0f;
    }

    @Override
    public boolean showInEntPanelInternal() {
        if (this.show != null) {
            return this.show;
        }
        for (AffectSideEffect ase : this.effects) {
            if (!ase.showInPanel()) continue;
            return true;
        }
        for (AffectSideCondition asc : this.conditions) {
            if (!asc.showInPanel()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getImageName() {
        String img;
        for (AffectSideCondition asc : this.conditions) {
            img = asc.getImageName();
            if (img == null) continue;
            return img;
        }
        for (AffectSideEffect ase : this.effects) {
            img = ase.getImageName();
            if (img == null) continue;
            return img;
        }
        return super.getImageName();
    }

    @Override
    public boolean isRecommended(EntState sourceState, EntState targetPresent, EntState targetFuture) {
        if (targetPresent.isUsed()) {
            return false;
        }
        EntSideState ess = targetPresent.getCurrentSideState();
        if (ess == null) {
            return false;
        }
        boolean effectValid = false;
        for (AffectSideEffect ase : this.effects) {
            effectValid |= ase.isRecommended(sourceState, targetPresent, targetFuture);
        }
        if (!effectValid) {
            return false;
        }
        for (AffectSideCondition c : this.conditions) {
            if (c.validFor(ess, targetFuture, 0)) continue;
            return false;
        }
        return true;
    }

    @Override
    public long getCollisionBits(Boolean player) {
        long bit = 0L;
        boolean replaces = false;
        boolean hasPosition = false;
        boolean hasIndexed = false;
        for (AffectSideEffect ase : this.effects) {
            bit |= ase.getCollisionBits(player);
            replaces |= ase instanceof ReplaceWith;
            hasIndexed |= ase.isIndexed();
        }
        for (AffectSideCondition asc : this.conditions) {
            hasPosition |= asc instanceof SpecificSidesCondition;
            bit |= asc.getCollisionBits(player);
        }
        if (!hasIndexed) {
            if (!hasPosition && replaces) {
                bit |= Collision.allSides(player);
            }
            if (this.conditions.isEmpty()) {
                bit |= Collision.allSides(player);
            }
        }
        return bit;
    }

    @Override
    public float getEffectTier(int pips, int tier) {
        for (AffectSideEffect ase : this.effects) {
            float val = ase.getEffectTier(pips, tier);
            if (Float.isNaN(val)) continue;
            return val;
        }
        return Float.NaN;
    }

    public List<AffectSideEffect> getEffects() {
        return this.effects;
    }

    public List<AffectSideCondition> getConditions() {
        return this.conditions;
    }

    @Override
    public List<Keyword> getReferencedKeywords() {
        ArrayList<Keyword> result = new ArrayList<Keyword>();
        for (AffectSideEffect ase : this.effects) {
            List<Keyword> extras = ase.getReferencedKeywords();
            if (extras == null) continue;
            result.addAll(extras);
        }
        return result;
    }

    @Override
    public String describeForGiveBuff(Eff source) {
        boolean allKeyword = this.effects.size() > 0;
        for (AffectSideEffect ase : this.effects) {
            allKeyword |= ase instanceof AddKeyword;
        }
        if (allKeyword) {
            return this.describeForSelfBuff().replaceAll("all", "target's");
        }
        return super.describeForGiveBuff(source);
    }

    @Override
    public String[] getSound() {
        if (this.conditions.size() == 1 && this.conditions.get(0) instanceof TypeCondition) {
            return Sounds.boost;
        }
        if (this.effects.size() == 2 && this.effects.get(0) instanceof AddKeyword) {
            return Sounds.boost;
        }
        if (this.effects.get(0) instanceof Flip) {
            return Sounds.flap;
        }
        return null;
    }

    @Override
    public Personal genMult(int mult) {
        ArrayList<AffectSideEffect> newEffects = new ArrayList<AffectSideEffect>();
        for (AffectSideEffect effect : this.effects) {
            AffectSideEffect nASE = effect.genMult(mult);
            if (nASE == null) {
                return null;
            }
            newEffects.add(nASE);
        }
        return new AffectSides(this.conditions, newEffects);
    }

    @Override
    public boolean isMultiplable() {
        for (AffectSideEffect effect : this.effects) {
            if (effect.isMultiplable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String hyphenTag() {
        String s;
        if (this.conditions.size() == 1 && (s = this.conditions.get(0).hyphenTag()) != null) {
            return s;
        }
        if (this.effects.size() != 1) {
            return null;
        }
        return this.effects.get(0).hyphenTag();
    }

    @Override
    public Actor getTraitActor() {
        List<Keyword> list;
        AffectSideEffect ase;
        if (this.conditions.isEmpty() && this.effects.size() == 1 && (ase = this.effects.get(0)) instanceof AddKeyword && (list = ((AddKeyword)ase).getKeywordList()).size() == 1) {
            return new ImageActor(list.get(0).getImage());
        }
        return super.getTraitActor();
    }

    @Override
    public boolean skipMultiplable() {
        for (AffectSideEffect effect : this.effects) {
            if (!effect.skipMultipliable()) continue;
            return true;
        }
        return false;
    }
}

