/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.trigger.personal.affectSideModular.effect;

import com.tann.dice.gameplay.content.ent.Ent;
import com.tann.dice.gameplay.content.ent.Hero;
import com.tann.dice.gameplay.content.ent.die.EntDieUtils;
import com.tann.dice.gameplay.content.ent.die.side.EntSide;
import com.tann.dice.gameplay.content.ent.type.HeroCol;
import com.tann.dice.gameplay.fightLog.EntSideState;
import com.tann.dice.gameplay.fightLog.EntState;
import com.tann.dice.gameplay.phase.Phase;
import com.tann.dice.gameplay.phase.PhaseManager;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.ChoicePhase;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.Choosable;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.special.LevelupHeroChoosable;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.AffectSides;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.condition.AffectSideCondition;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.condition.SpecificSidesType;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.effect.AffectSideEffect;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.effect.ReplaceWith;
import com.tann.dice.util.Tann;
import java.util.List;

public class ReplaceWithOtherHeroSideInOrder
extends AffectSideEffect {
    final int sideIndex;

    public ReplaceWithOtherHeroSideInOrder(int sideIndex) {
        this.sideIndex = sideIndex;
    }

    @Override
    public String describe() {
        return "unimp " + this.getClass().getSimpleName();
    }

    @Override
    public String getOverrideDescription(List<AffectSideCondition> conditions, List<AffectSideEffect> effects) {
        return "Replace my sides with the " + this.descSideIndex() + " base sides of other heroes[n][grey](in petrify order from top to bottom) [col222](before items)";
    }

    private String descSideIndex() {
        return EntDieUtils.fromIndex(this.sideIndex).name().toLowerCase();
    }

    @Override
    public void affect(EntSideState sideState, EntState owner, int index, AffectSides sourceTrigger, int sourceIndex) {
        int actualHeroIndex;
        List<Ent> ents;
        if (owner.getSnapshot() == null) {
            return;
        }
        int ownerLvel = -5;
        HeroCol ownerCol = null;
        if (owner.getEnt() instanceof Hero) {
            Hero ownero = (Hero)owner.getEnt();
            ownerLvel = ownero.getLevel();
            ownerCol = ownero.getHeroCol();
        }
        if (owner.hasOverrideGlobals()) {
            int i;
            Ent ent2;
            PhaseManager pm = PhaseManager.get();
            if (pm == null) {
                return;
            }
            Phase p = pm.getPhase();
            int foundIndex = -1;
            if (p instanceof ChoicePhase) {
                ChoicePhase cp = (ChoicePhase)p;
                List<Choosable> options = cp.getOptions();
                for (int i2 = 0; i2 < options.size(); ++i2) {
                    LevelupHeroChoosable lu;
                    Choosable option = options.get(i2);
                    if (!(option instanceof LevelupHeroChoosable) || (lu = (LevelupHeroChoosable)option).getHeroType() != owner.getEnt().getEntType()) continue;
                    foundIndex = i2;
                }
            }
            if (foundIndex == -1) {
                return;
            }
            ents = owner.getSnapshot().getEntities(true, null);
            if (foundIndex >= ents.size()) {
                return;
            }
            for (Ent ent2 : ents) {
                if (!ent2.getName(false).contains("ousecat")) continue;
                return;
            }
            for (i = 0; i < ents.size(); ++i) {
                Hero h;
                ent2 = ents.get(i);
                if (!(ent2 instanceof Hero) || (h = (Hero)ent2).getLevel() != ownerLvel - 1 || h.getHeroCol() != ownerCol) continue;
                if (foundIndex == 0) {
                    ents.remove(i);
                }
                --foundIndex;
            }
            if (foundIndex != -1) {
                for (i = 0; i < ents.size(); ++i) {
                    Hero h;
                    ent2 = ents.get(i);
                    if (!(ent2 instanceof Hero) || (h = (Hero)ent2).getLevel() != ownerLvel - 1 || h.getHeroCol() != ownerCol) continue;
                    ents.remove(i);
                    break;
                }
            }
        } else {
            ents = owner.getSnapshot().getEntities(true, null);
        }
        if ((actualHeroIndex = Tann.indexOf(SpecificSidesType.PetrifyOrder.sideIndices, sideState.getIndex())) == -1) {
            return;
        }
        Ent copyFrom = this.getIndexedExcept(ents, actualHeroIndex, owner.getEnt());
        if (copyFrom == null) {
            ReplaceWith.replaceSide(sideState, owner.getEnt().getSize().getBlank());
            return;
        }
        EntSide rep = copyFrom.getSides()[this.sideIndex];
        ReplaceWith.replaceSide(sideState, rep.copy());
    }

    private Ent getIndexedExcept(List<Ent> entities, int requestedIndex, Ent ent) {
        if (requestedIndex > entities.size()) {
            return null;
        }
        int counter = 0;
        for (Ent entity : entities) {
            if (entity == ent) continue;
            if (counter == requestedIndex) {
                return entity;
            }
            ++counter;
        }
        return null;
    }

    @Override
    public String getImageName() {
        return "mimic";
    }
}

