/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.trigger.personal.item;

import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.tann.dice.gameplay.content.item.Item;
import com.tann.dice.gameplay.effect.targetable.ability.Ability;
import com.tann.dice.gameplay.fightLog.EntState;
import com.tann.dice.gameplay.fightLog.Snapshot;
import com.tann.dice.gameplay.trigger.personal.Personal;
import java.util.List;

public class AsIfHasItem
extends Personal {
    final Item item;

    public AsIfHasItem(Item item) {
        this.item = item;
    }

    @Override
    public String describeForSelfBuff() {
        return "Gain the effects of the item: '" + this.item.getName(true) + "'[n][grey](" + this.item.getDescription() + ")[cu]";
    }

    @Override
    public boolean skipTraitPanel() {
        for (Personal personalTrigger : this.item.getPersonalTriggers()) {
            if (personalTrigger.getAbility() == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public Actor makePanelActorI(boolean big) {
        if (big) {
            return this.item.makeChoosableActor(big, 0);
        }
        return this.item.makeImageActor();
    }

    @Override
    protected TextureRegion overrideImage() {
        return this.item.getImage();
    }

    @Override
    public List<Personal> getLinkedTriggersNoSnapshot(EntState entState) {
        return this.item.getPersonalTriggers();
    }

    @Override
    public List<Personal> getLinkedTriggers(Snapshot snapshot, EntState entState) {
        return this.getLinkedTriggersNoSnapshot(entState);
    }

    @Override
    public boolean isGenerated() {
        return true;
    }

    @Override
    public boolean skipCalc() {
        return true;
    }

    @Override
    public Ability getAbility() {
        return this.item.getAbility();
    }
}

