/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.trigger.personal.item;

import com.tann.dice.gameplay.content.ent.type.EntType;
import com.tann.dice.gameplay.content.item.Item;
import com.tann.dice.gameplay.content.item.ItemLib;
import com.tann.dice.gameplay.fightLog.EntState;
import com.tann.dice.gameplay.fightLog.Snapshot;
import com.tann.dice.gameplay.fightLog.event.snapshot.SnapshotTextEvent;
import com.tann.dice.gameplay.trigger.personal.Personal;
import com.tann.dice.gameplay.trigger.personal.item.GainItem;
import com.tann.dice.util.Tann;
import java.util.List;

public class Chest
extends Personal {
    final int fleeTurn;
    final int itemLower;
    final int itemHigher;

    public Chest(int fleeTurn, int itemLower, int itemHigher) {
        this.fleeTurn = fleeTurn;
        this.itemLower = itemLower;
        this.itemHigher = itemHigher;
    }

    @Override
    public String getImageName() {
        return "chest";
    }

    @Override
    public boolean showInEntPanelInternal() {
        return true;
    }

    @Override
    public void onDeath(EntState self, Snapshot snapshot) {
        int tier = Tann.randomInt(this.itemLower, this.itemHigher);
        List<Item> list = ItemLib.randomWithExactQuality(1, tier, snapshot.getFightLog().getContext());
        if (list.size() == 1) {
            self.addBuff(new GainItem(list.get(0)));
            snapshot.addEvent(new SnapshotTextEvent("[yellow]+1 item [text](after combat)"));
        }
    }

    @Override
    public void endOfTurn(EntState entState) {
        if (entState.getTurnsElapsed() < this.fleeTurn) {
            return;
        }
        if (entState.getHp() <= 0) {
            return;
        }
        entState.flee();
    }

    @Override
    public int calcBackRowTurn() {
        if (this.fleeTurn == 1) {
            return 1;
        }
        return super.calcBackRowTurn();
    }

    @Override
    public float affectTotalHpCalc(float hp, EntType entType) {
        if (this.fleeTurn == 1) {
            return hp * 0.13f - this.getAvgTier() * 0.28f;
        }
        return hp * (1.0f - 1.0f / ((float)this.fleeTurn + 3.5f));
    }

    @Override
    public float affectStrengthCalc(float total, float avgRawValue, EntType type) {
        return total - this.getAvgTier() * 0.25f;
    }

    private float getAvgTier() {
        return (float)(this.itemHigher - this.itemLower) / 2.0f + (float)this.itemLower;
    }

    @Override
    public String describeForSelfBuff() {
        return this.describeFlees() + " and drop a [grey]t" + this.itemLower + "-" + this.itemHigher + " item[cu] if defeated.";
    }

    private String describeFlees() {
        if (this.fleeTurn == 1) {
            return "I flee at the end of the turn";
        }
        return "I flee at the end of turn " + this.fleeTurn;
    }
}

