/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.dungeon.panels.book.page.cogPage.menuPanel;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.tann.dice.Main;
import com.tann.dice.gameplay.mode.creative.pastey.PasteMode;
import com.tann.dice.gameplay.save.settings.option.Option;
import com.tann.dice.gameplay.save.settings.option.OptionLib;
import com.tann.dice.gameplay.trigger.global.linked.DipPanel;
import com.tann.dice.screens.Screen;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.screens.dungeon.DungeonUtils;
import com.tann.dice.screens.dungeon.panels.book.Book;
import com.tann.dice.screens.dungeon.panels.book.page.stuffPage.StuffPage;
import com.tann.dice.screens.titleScreen.TitleScreen;
import com.tann.dice.statics.Images;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.statics.sound.music.JukeboxUtils;
import com.tann.dice.util.BasicKeyCatch;
import com.tann.dice.util.Colours;
import com.tann.dice.util.ImageActor;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Tann;
import com.tann.dice.util.TannStage;
import com.tann.dice.util.bsRandom.Supplier;
import com.tann.dice.util.listener.TannListener;
import com.tann.dice.util.online.BugReport;
import com.tann.dice.util.ui.choice.ChoiceDialog;
import com.tann.dice.util.ui.standardButton.StandardButton;
import java.util.ArrayList;
import java.util.List;

public abstract class EscMenuUtils {
    public static Actor makeScale(int cWidth) {
        Pixl visual = new Pixl();
        Actor displaySettings = Main.self().control.makeDisplaySettings();
        visual.actor(displaySettings).row();
        return visual.pix();
    }

    public static Actor makeSound(int cWidth) {
        Pixl sound = new Pixl(2, 0);
        for (Option bopt : OptionLib.EscBopType.Top.getOptions()) {
            sound.actor(bopt.makeCogActor()).row();
        }
        sound.actor(JukeboxUtils.makeCurrentlyPlaying()).row().actor(JukeboxUtils.makeEntryButton()).actor(JukeboxUtils.makeSongControls());
        Group a = sound.pix();
        return DipPanel.makeTopPanelGroup(new ImageActor(Images.esc_sound), a, JukeboxUtils.SOUND_COL);
    }

    public static Group makeButtons(int contentWidth) {
        String lap;
        ArrayList<Actor> miscButtons = new ArrayList<Actor>();
        ArrayList<Actor> navButtons = new ArrayList<Actor>();
        boolean inDungeon = Main.getCurrentScreen() instanceof DungeonScreen;
        if (inDungeon) {
            miscButtons.add(PasteMode.makeEscButton());
        }
        miscButtons.add(EscMenuUtils.makeReportButton());
        if (!OptionLib.REMOVE_SAVE_BUTT.c()) {
            miscButtons.add(EscMenuUtils.makeSaveButton());
        }
        if ((lap = Main.getSettings().getLastAlmanacPage()) != null) {
            String tag = lap;
            String[] split = lap.split("-");
            if (split.length >= 2) {
                tag = split[1];
            }
            if (!(tag.contains("Options") || tag.contains("Basics") || tag.contains("Credits"))) {
                navButtons.add(EscMenuUtils.makeBookButton("<- " + tag, lap));
            }
        }
        navButtons.add(EscMenuUtils.makeBookButton("Options", "stuff-options"));
        navButtons.add(EscMenuUtils.makeBookButton("[green]Help", "help-basics"));
        navButtons.add(EscMenuUtils.makeBookButton(StuffPage.StuffSection.Credits.getColourTaggedString(), "stuff-credits"));
        DungeonScreen ds = DungeonScreen.getCurrentScreenIfDungeon(false);
        if (ds != null && ds.canFleePhase()) {
            miscButtons.add(EscMenuUtils.makeFlee());
        }
        if (Gdx.app.getType() != Application.ApplicationType.iOS || ds != null) {
            miscButtons.add(EscMenuUtils.makeQuit());
        }
        int gap = 3;
        Pixl p = new Pixl(gap);
        p.actor(EscMenuUtils.almanacButtonGroup(navButtons, gap, contentWidth)).row().listActor(miscButtons, gap, contentWidth);
        return p.pix();
    }

    private static Actor almanacButtonGroup(List<Actor> actors, int gap, int contentWidth) {
        ImageActor almanac = new ImageActor(Images.almanac);
        almanac.addListener(new TannListener(){

            @Override
            public boolean action(int button, int pointer, float x, float y) {
                Book.openBook(true);
                return true;
            }
        });
        return DipPanel.makeTopPanelGroup(almanac, new Pixl(3).listActor(actors, gap, contentWidth).pix(), Book.BOOK_COL);
    }

    private static Actor makeBookButton(String options, final String path) {
        StandardButton sb = new StandardButton(options);
        sb.setRunnable(new Runnable(){

            @Override
            public void run() {
                Book.openBook(path);
            }
        });
        return sb;
    }

    private static Actor makeFlee() {
        StandardButton flee = new StandardButton("[grey]Flee");
        flee.setRunnable(new Runnable(){

            @Override
            public void run() {
                final DungeonScreen ds = DungeonScreen.getCurrentScreenIfDungeon(false);
                ChoiceDialog choiceDialog = new ChoiceDialog("Flee?[n][red](counts as a loss)", ChoiceDialog.ChoiceNames.RedYes, new Runnable(){

                    @Override
                    public void run() {
                        ds.manualFlee();
                    }
                }, null);
                Sounds.playSound(Sounds.pip);
                Main.getCurrentScreen().push(choiceDialog, 0.8f);
                Tann.center(choiceDialog);
            }
        });
        return flee;
    }

    private static StandardButton makeSaveButton() {
        StandardButton save = new StandardButton("Save");
        save.setRunnable(new Runnable(){

            @Override
            public void run() {
                Sounds.playSound(Sounds.pip);
                Pixl p = new Pixl(3, 3).border(Colours.red);
                p.text("[text]Game saves automatically after each action, this button does nothing!", 110);
                p.row();
                p.actor(OptionLib.REMOVE_SAVE_BUTT.makeCogActor());
                Group a = p.pix();
                Main.getCurrentScreen().push(a, true, true, true, 0.8f);
                Tann.center(a);
            }
        });
        return save;
    }

    private static StandardButton makeReportButton() {
        return BugReport.makeBugReportButton("[green]Welcome to the bug report section!", "[text]Automated bug report includes your highscore-name, game version, recent logs and the current game state.", new Supplier<String>(){

            @Override
            public String supply() {
                String reportString = Main.getCurrentScreen().getReportString();
                if (reportString == null) {
                    reportString = "was null";
                }
                return reportString;
            }
        }, true);
    }

    private static StandardButton makeQuit() {
        String buttString = Main.getCurrentScreen() instanceof TitleScreen ? "[b][red]Exit" : "[b][orange]Quit";
        StandardButton butt = new StandardButton(buttString);
        butt.setRunnable(new Runnable(){

            @Override
            public void run() {
                Screen s = Main.getCurrentScreen();
                if (s instanceof DungeonScreen) {
                    Sounds.playSound(Sounds.confirm);
                    DungeonScreen.get().getDungeonContext().getContextConfig().quitAction();
                } else if (s instanceof TitleScreen) {
                    if (Main.self().control.allowQuit()) {
                        Gdx.app.exit();
                    }
                } else {
                    Main.self().setScreen(new TitleScreen());
                }
            }
        });
        return butt;
    }

    private static StandardButton makeRestore() {
        String buttString = "Restore Purchases";
        StandardButton butt = new StandardButton(buttString);
        butt.setRunnable(new Runnable(){

            @Override
            public void run() {
                Main.self().control.checkPurchase();
            }
        });
        return butt;
    }

    public static boolean refreshIfOnTop() {
        Screen s = Main.getCurrentScreen();
        Actor a = s.getTopPushedActor();
        if (a == null) {
            return false;
        }
        if (!(a instanceof Group)) {
            return false;
        }
        Group g = (Group)a;
        if (Tann.findByClass(g, DungeonUtils.CogTag.class) == null) {
            return false;
        }
        s.popSingleMedium();
        DungeonUtils.showCogMenu();
        return true;
    }

    public static Actor makeFullEscMenu() {
        int cWidth = (int)((float)Main.width * 0.9f);
        ArrayList<Actor> actors = new ArrayList<Actor>();
        actors.add(EscMenuUtils.makeScale(cWidth));
        actors.add(EscMenuUtils.makeSound(cWidth));
        int bWidth = cWidth;
        if (Main.isPortrait()) {
            bWidth = (int)((float)TannStage.maxActorWidth(actors) * 1.2f);
        }
        Group a = new Pixl(4, 5).border(Colours.grey).listActor(actors, 4, cWidth).row().actor(EscMenuUtils.makeButtons(bWidth)).pix();
        a.addActor(new DungeonUtils.CogTag());
        a = new BasicKeyCatch(a);
        a.addListener(new TannListener(){

            @Override
            public boolean action(int button, int pointer, float x, float y) {
                return true;
            }
        });
        return a;
    }
}

