/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.dungeon.panels.book.views;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.tann.dice.Main;
import com.tann.dice.gameplay.content.item.Item;
import com.tann.dice.screens.dungeon.panels.book.views.HeroLedgerView;
import com.tann.dice.screens.dungeon.panels.entPanel.choosablePanel.ItemPanel;
import com.tann.dice.statics.Images;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Draw;
import com.tann.dice.util.ImageActor;
import com.tann.dice.util.Tann;
import com.tann.dice.util.listener.TannListener;

public class ItemLedgerView
extends Group {
    private final Item item;

    public ItemLedgerView(Item i, EquipSeenState ess) {
        Actor actor;
        this.setTransform(false);
        this.item = i;
        switch (ess) {
            case Seen: {
                actor = i.makeImageActor();
                break;
            }
            case Missing: {
                Group g = Tann.makeGroup(i.makeImageActor());
                HeroLedgerView.addUnencountered(g);
                actor = g;
                break;
            }
            default: {
                Group g = Tann.makeGroup(14, 14);
                ImageActor ia = new ImageActor(Images.padlock);
                g.addActor(ia);
                Tann.center(ia);
                actor = g;
                break;
            }
        }
        int gap = 1;
        this.setSize(actor.getWidth() + (float)(gap * 2), actor.getHeight() + (float)(gap * 2));
        this.addActor(actor);
        Tann.center(actor);
        this.setTransform(false);
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        Draw.fillActor(batch, this, Colours.dark, Colours.grey, 1);
        super.draw(batch, parentAlpha);
    }

    public ItemLedgerView addBasicListener() {
        this.addListener(new TannListener(){

            @Override
            public boolean info(int button, float x, float y) {
                Sounds.playSound(Sounds.pip);
                ItemPanel cp = new ItemPanel(ItemLedgerView.this.item, true);
                Main.getCurrentScreen().push(cp, 0.5f);
                Tann.center(cp);
                return true;
            }
        });
        return this;
    }

    public static enum EquipSeenState {
        Seen,
        Missing,
        Locked;

    }
}

