/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.dungeon.panels.combatEffects.beam;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.tann.dice.Main;
import com.tann.dice.gameplay.content.ent.Ent;
import com.tann.dice.gameplay.fightLog.FightLog;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.screens.dungeon.panels.combatEffects.CombatEffectActor;
import com.tann.dice.screens.dungeon.panels.entPanel.EntPanel;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Draw;
import com.tann.dice.util.PixelParticle;
import com.tann.dice.util.RainbowAction;
import com.tann.dice.util.Tann;

public class BeamActor
extends CombatEffectActor {
    private static final float IN = 0.05f;
    private static final float HOLD = 0.15f;
    private static final float OUT = 0.2f;
    private static final float START_SIZE = 2.0f;
    private static final float MAX_SIZE = 8.9f;
    private static final float PARTICLE_SPAWN_TIME = 0.002f;
    final Ent source;
    final Ent target;
    float particleTimer;
    Vector2 start;
    Vector2 end;
    final Color col;

    public BeamActor(Ent source, Ent target, Color col) {
        this.source = source;
        this.target = target;
        this.col = col;
    }

    @Override
    protected void start(FightLog fightLog) {
        Sounds.playSound(Sounds.beam);
        DungeonScreen.get().addActor(this);
        this.start = this.source == null ? new Vector2(-20.0f, Main.height / 2) : Tann.getAbsoluteCoordinates(this.source.getEntPanel(), Tann.TannPosition.Left).cpy();
        EntPanel targetPanel = this.target.getEntPanel();
        this.end = Tann.getAbsoluteCoordinates(targetPanel, Tann.TannPosition.Center).add(0.0f, -4.45f).cpy();
        this.setColor(this.col);
        this.setScaleX(2.0f);
        this.addAction(Actions.sequence((Action)Actions.parallel((Action)Actions.sequence((Action)Actions.scaleTo(8.9f, 0.0f, 0.05f, Interpolation.pow2In), (Action)Actions.delay(0.15f), (Action)Actions.scaleTo(0.0f, 0.0f, 0.2f, Interpolation.pow2Out)), (Action)new RainbowAction(0.4f, Colours.purple, this.col, Colours.purple)), (Action)Actions.removeActor()));
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        this.particleTimer -= delta;
        float moveAmount = this.getScaleX() * 2.0f;
        float MOVE_TIME = 0.3f;
        if (this.getScaleX() > 2.0f) {
            while (this.particleTimer < 0.0f) {
                this.particleTimer += 0.002f;
                PixelParticle pixelParticle = new PixelParticle(Tann.half() ? Colours.light : this.col);
                DungeonScreen.get().addActor(pixelParticle);
                float dist = Tann.random();
                pixelParticle.setPosition(this.start.x + (this.end.x - this.start.x) * dist, this.start.y + (this.end.y - this.start.y) * dist);
                pixelParticle.addAction(Actions.parallel((Action)Actions.moveBy(Tann.random(-moveAmount, moveAmount), Tann.random(-moveAmount, moveAmount), MOVE_TIME, Interpolation.pow2Out), Tann.fadeAndRemove(MOVE_TIME)));
            }
        }
    }

    @Override
    protected float getImpactDuration() {
        return 0.125f;
    }

    @Override
    protected float getExtraDuration() {
        return 0.275f;
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        batch.setColor(this.getColor());
        Draw.drawLine(batch, this.start, this.end, (int)this.getScaleX());
        super.draw(batch, parentAlpha);
    }
}

