/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.dungeon.panels.combatEffects.ice;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.tann.dice.gameplay.content.ent.Ent;
import com.tann.dice.gameplay.fightLog.FightLog;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.screens.dungeon.panels.combatEffects.CombatEffectActor;
import com.tann.dice.screens.dungeon.panels.entPanel.EntPanel;
import com.tann.dice.statics.Images;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Colours;
import com.tann.dice.util.PixelParticle;
import com.tann.dice.util.Tann;

public class FrostActor
extends CombatEffectActor {
    private static final float ALPHA = 0.7f;
    private static final float FADE_IN = 0.1f;
    private static final float HOLD = 0.1f;
    private static final float PARTICLE_SPAWN = 0.1f;
    private static final float PARTICLE_LIFE = 0.4f;
    private static final int SHATTER_PARTICLES = 40;
    EntPanel targetPanel;

    public FrostActor(Ent target) {
        this.targetPanel = target.getEntPanel();
    }

    @Override
    protected void start(FightLog fightLog) {
        this.setSize(20.0f, 10.0f);
        Vector2 pos = Tann.getAbsoluteCoordinates(this.targetPanel).cpy();
        DungeonScreen.get().addActor(this);
        this.setPosition(pos.x + this.targetPanel.getWidth() / 2.0f - this.getWidth() / 2.0f, pos.y + this.targetPanel.getHeight() / 2.0f - this.getHeight() / 2.0f);
        Color col = Colours.shiftedTowards(Colours.light, Colours.blue, 0.5f);
        this.setColor(Colours.withAlpha(col, 0.0f));
        this.addAction(Actions.sequence((Action)Actions.alpha(0.7f, 0.1f), (Action)Actions.delay(0.1f), (Action)Actions.run(new Runnable(){

            @Override
            public void run() {
                FrostActor.this.shatter();
            }
        }), Tann.fadeAndRemove(0.1f)));
    }

    private void shatter() {
        Sounds.playSound(Sounds.iceExplode);
        for (int i = 0; i < 40; ++i) {
            PixelParticle pixelParticle = new PixelParticle(Tann.half() ? Colours.light : Colours.blue);
            Tann.setPosition(pixelParticle, Tann.getAbsoluteCoordinates(this).add(Tann.random(this.getWidth()), Tann.random(this.getHeight())));
            pixelParticle.setScale(2.0f);
            DungeonScreen.get().addActor(pixelParticle);
            pixelParticle.addAction(Actions.sequence((Action)Actions.alpha(0.0f), (Action)Actions.delay((float)i / 40.0f * 0.1f), (Action)Actions.alpha(0.7f), (Action)Actions.parallel(Tann.moveBy(Tann.randomRadial(16.0f), 0.4f, Interpolation.pow2Out), (Action)Actions.scaleTo(1.0f, 1.0f, 0.4f), Tann.fadeAndRemove(0.4f))));
        }
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        batch.setColor(this.getColor());
        Images.icePatch.draw(batch, this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    @Override
    protected float getImpactDuration() {
        return 0.2f;
    }

    @Override
    protected float getExtraDuration() {
        return 0.5f;
    }
}

