/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.shaderFx;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.tann.dice.screens.dungeon.panels.threeD.Actor3d;
import com.tann.dice.screens.shaderFx.FXAcid;
import com.tann.dice.screens.shaderFx.FXBurn;
import com.tann.dice.screens.shaderFx.FXCut;
import com.tann.dice.screens.shaderFx.FXEllipse;
import com.tann.dice.screens.shaderFx.FXSingularity;
import com.tann.dice.screens.shaderFx.ShaderFolder;
import com.tann.dice.statics.Images;
import com.tann.dice.util.Tann;
import com.tann.dice.util.TannStageUtils;
import java.util.HashMap;
import java.util.Map;

public abstract class FXContainer
extends Group {
    protected ShaderProgram program;
    protected final Actor group;
    protected Vector2 originalPosition;
    protected float random;
    private static Map<ShaderFolder, ShaderProgram> cachedShaders = new HashMap<ShaderFolder, ShaderProgram>();

    public FXContainer(Actor group) {
        this.setTransform(false);
        this.group = group;
        this.originalPosition = Tann.getAbsoluteCoordinates(group).cpy();
        ShaderProgram.pedantic = false;
        this.random = Tann.random();
    }

    public static FXContainer randomFx(Actor a) {
        int r = Tann.randomInt(5);
        switch (r) {
            default: {
                return new FXBurn(a);
            }
            case 1: {
                return new FXAcid(a);
            }
            case 2: {
                return new FXCut(a, 1, 0.2f, 0.35f, 20.0f, 0.5f, (float)(0.5 + (Math.random() * 2.0 - 1.0) * (double)0.4f));
            }
            case 3: {
                return new FXEllipse(a);
            }
            case 4: 
        }
        return new FXSingularity(a);
    }

    protected void loadShader(ShaderFolder folder) {
        this.program = FXContainer.fetchShaderCached(folder);
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        this.group.act(delta);
    }

    public void replace() {
        Group parent;
        if (this.group instanceof Group) {
            for (Actor3d a3 : TannStageUtils.getActorsWithClass(Actor3d.class, (Group)this.group)) {
                a3.remove();
            }
        }
        if ((parent = this.group.getParent()) == null) {
            return;
        }
        this.group.remove();
        parent.addActor(this);
    }

    protected void setupNoise(ShaderProgram program) {
        TextureRegion n = Images.noise_packed;
        float atlasWidth = n.getTexture().getWidth();
        float atlasHeight = n.getTexture().getHeight();
        program.setUniformf("u_noiseBounds", (float)n.getRegionX() / atlasWidth, (float)n.getRegionY() / atlasHeight, (float)n.getRegionWidth() / atlasWidth, (float)n.getRegionHeight() / atlasHeight);
    }

    public abstract float getDuration();

    private static ShaderProgram fetchShaderCached(ShaderFolder folderName) {
        ShaderProgram cached = cachedShaders.get((Object)folderName);
        if (cached == null) {
            String frag;
            String vert = Gdx.files.internal("shader/fx/" + (Object)((Object)folderName) + "/vertex.glsl").readString();
            cached = new ShaderProgram(vert, frag = Gdx.files.internal("shader/fx/" + (Object)((Object)folderName) + "/fragment.glsl").readString());
            if (!cached.isCompiled()) {
                System.out.println(cached.getLog());
                cached = SpriteBatch.createDefaultShader();
            }
            cachedShaders.put(folderName, cached);
        }
        return cached;
    }

    public static void clearCaches() {
        cachedShaders = new HashMap<ShaderFolder, ShaderProgram>();
    }

    public static void loadAllShaders() {
        for (ShaderFolder sf : ShaderFolder.values()) {
            FXContainer.fetchShaderCached(sf);
        }
    }
}

