/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.shaderFx;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.tann.dice.screens.shaderFx.FXContainer;
import com.tann.dice.screens.shaderFx.ShaderFolder;
import com.tann.dice.util.Tann;

public class FXCut
extends FXContainer {
    float total;
    final float startHeight;
    final float endHeight;
    final int dir;
    Vector2 leftRightCutRatio = new Vector2(0.5f, 0.5f);

    public FXCut(Actor actor, int dir, float cutTime, float separateTime, float separateDist, float startHeight, float endHeight) {
        super(actor);
        this.setCutRatio(startHeight, endHeight);
        this.loadShader(ShaderFolder.cut);
        this.total = cutTime + separateTime;
        this.dir = dir;
        this.startHeight = startHeight;
        this.endHeight = endHeight;
        this.animate(cutTime, separateTime, separateDist);
    }

    private void randomiseCutRatio() {
        float rand = Tann.random();
        this.setCutRatio(rand, 1.0f - rand);
    }

    public void setCutRatio(float left, float right) {
        this.leftRightCutRatio.set(left, right);
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        ShaderProgram previous = batch.getShader();
        batch.setShader(this.program);
        for (int i = 0; i < 2; ++i) {
            int drawX = (int)this.originalPosition.x;
            int drawY = (int)(this.originalPosition.y + this.getHeight() * (float)(i * 2 - 1) * (float)this.dir);
            int h = (int)this.group.getHeight();
            int w = (int)this.group.getWidth();
            float cutDiff = this.leftRightCutRatio.y - this.leftRightCutRatio.x;
            this.program.setUniformi("u_cutSide", i * 2 - 1);
            this.program.setUniformi("u_disappear", (int)this.getScaleY());
            this.program.setUniformf("u_cutAlpha", this.getWidth());
            this.program.setUniformf("u_intersect", this.dir == 1 ? (float)drawX : (float)(drawX + w), (float)drawY + this.leftRightCutRatio.x * (float)h, this.dir == 1 ? (float)w : (float)(-w), cutDiff * (float)h);
            this.group.setPosition(drawX, drawY);
            this.group.draw(batch, 1.0f);
            batch.flush();
        }
        batch.setShader(previous);
    }

    private void animate(float cutTime, float separateTime, float separateDist) {
        this.clearActions();
        this.setScaleY(0.0f);
        this.setSize(0.0f, 0.0f);
        this.addAction(Actions.sequence((Action)Actions.sizeTo(1.0f, 0.0f, cutTime, Interpolation.pow2Out), (Action)Actions.parallel((Action)Actions.sizeTo(1.0f, separateDist, separateTime, Interpolation.pow2Out), (Action)Actions.scaleTo(0.0f, this.group.getHeight(), separateTime, Interpolation.pow2In)), (Action)Actions.removeActor()));
    }

    @Override
    public float getDuration() {
        return this.total;
    }
}

