/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.titleScreen;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.tann.dice.Main;
import com.tann.dice.gameplay.content.ent.group.Party;
import com.tann.dice.gameplay.content.ent.group.PartyLayoutType;
import com.tann.dice.gameplay.content.ent.type.HeroType;
import com.tann.dice.gameplay.content.ent.type.lib.HeroTypeLib;
import com.tann.dice.gameplay.content.gen.pipe.entity.hero.PipeHero;
import com.tann.dice.gameplay.context.DungeonContext;
import com.tann.dice.gameplay.context.config.ContextConfig;
import com.tann.dice.gameplay.context.config.difficultyConfig.DifficultyConfig;
import com.tann.dice.gameplay.mode.Mode;
import com.tann.dice.gameplay.mode.creative.pastey.PasteMode;
import com.tann.dice.gameplay.mode.meta.folder.FolderType;
import com.tann.dice.gameplay.progress.chievo.unlock.Feature;
import com.tann.dice.gameplay.progress.chievo.unlock.UnUtil;
import com.tann.dice.gameplay.save.SaveState;
import com.tann.dice.gameplay.save.antiCheese.AntiCheeseRerollInfo;
import com.tann.dice.gameplay.save.antiCheese.AnticheeseData;
import com.tann.dice.gameplay.trigger.global.heroLevelupAffect.HeroGenType;
import com.tann.dice.screens.Screen;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.screens.dungeon.panels.tutorial.TutorialManager;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.ChanceHaver;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Tann;
import com.tann.dice.util.TannLog;
import com.tann.dice.util.listener.TannListener;
import com.tann.dice.util.ui.TextWriter;
import com.tann.dice.util.ui.choice.ChoiceDialog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public abstract class GameStart {
    private static boolean andBasic = true;

    public static void start(DungeonContext dungeonContext) {
        Sounds.playSound(Sounds.confirm);
        ContextConfig cc = dungeonContext.getContextConfig();
        if (GameStart.anticheeseOverride(cc)) {
            return;
        }
        if (GameStart.tutStartOverride(cc)) {
            return;
        }
        DungeonScreen ds = new DungeonScreen(dungeonContext);
        Main.self().setScreen(ds);
    }

    public static void startWithPLTChoice(final ContextConfig cc, final AntiCheeseRerollInfo acri) {
        if (!GameStart.shouldUsePartyLayout(cc)) {
            GameStart.basicStartConfirmIfNecessary(cc, new Runnable(){

                @Override
                public void run() {
                    GameStart.start(cc.makeContext(acri));
                }
            });
        } else {
            GameStart.startWithPLTChoice(cc, PipeHero.getGenType(cc.getModeGlobals()), acri, acri != null);
        }
    }

    private static void startWithPLTChoice(final ContextConfig cc, final HeroGenType hgt, final AntiCheeseRerollInfo acri, final boolean reroll) {
        Main.getCurrentScreen().popAllMedium();
        Pixl p = new Pixl(10, 8).border(Colours.grey);
        p.text("Choose party layout").row();
        List<PartyLayoutType> types = GameStart.getTypesFromContext(cc, acri);
        for (final PartyLayoutType type : types) {
            Actor a = type.visualise();
            p.actor(a);
            a.addListener(new TannListener(){

                @Override
                public boolean action(int button, int pointer, float x, float y) {
                    if (cc.hasSave() && !reroll) {
                        GameStart.basicStartConfirmIfNecessary(cc, new Runnable(){

                            @Override
                            public void run() {
                                GameStart.startWithPLTChosen(cc, hgt, acri, type, reroll);
                            }
                        });
                    } else {
                        GameStart.startWithPLTChosen(cc, hgt, acri, type, reroll);
                    }
                    return true;
                }
            });
        }
        Group a = p.pix();
        Main.getCurrentScreen().push(a, 0.8f);
        Tann.center(a);
        Sounds.playSound(Sounds.pip);
    }

    private static void basicStartConfirmIfNecessary(final ContextConfig cc, final Runnable actuallyStart) {
        if (cc.hasSave() && !cc.saveAtRunEnd()) {
            ChoiceDialog choiceDialog = new ChoiceDialog(null, Arrays.asList(new TextWriter("[red]Warning[cu], this will overwrite your in-progress game.[n]Are you sure?", 120)), ChoiceDialog.ChoiceNames.YesCancel, new Runnable(){

                @Override
                public void run() {
                    try {
                        SaveState oldSave = SaveState.load(cc.getGeneralSaveKey());
                        DungeonContext old = oldSave.dungeonContext;
                        old.logDefeatBackground(oldSave);
                    }
                    catch (Exception e) {
                        TannLog.log("Failed to merge stats: " + e.getClass().getSimpleName() + ": " + e.getMessage(), TannLog.Severity.error);
                        e.printStackTrace();
                    }
                    cc.clearSave();
                    actuallyStart.run();
                }
            }, null);
            Main.getCurrentScreen().push(choiceDialog, 0.5f);
            Tann.center(choiceDialog);
            Sounds.playSound(Sounds.pip);
        } else {
            actuallyStart.run();
        }
    }

    public static boolean shouldUsePartyLayout(ContextConfig cc) {
        return !UnUtil.isLocked(Feature.PARTY_LAYOUT_CHOICE) && !cc.mode.disablePartyLayout() && (cc.getAnticheese() == null || cc.getAnticheese().getSaveState() == null || GameStart.currentlyPlayingProbably(cc.mode));
    }

    private static boolean currentlyPlayingProbably(Mode mode) {
        Screen s = Main.getCurrentScreen();
        if (s instanceof DungeonScreen) {
            DungeonScreen ds = (DungeonScreen)s;
            return ds.getDungeonContext().getContextConfig().mode == mode;
        }
        return false;
    }

    public static List<PartyLayoutType> getTypesFromContext(ContextConfig cc, AntiCheeseRerollInfo acri) {
        int index;
        PartyLayoutType plt;
        ChanceHaver[] pool;
        FolderType ft = cc.mode.getFolderType();
        if (ft == FolderType.cursed || ft == FolderType.creative) {
            if (UnUtil.isLocked(HeroTypeLib.byName("housecat"))) {
                return Arrays.asList(PartyLayoutType.Basic, PartyLayoutType.Force);
            }
            return Arrays.asList(PartyLayoutType.Basic, PartyLayoutType.Force, PartyLayoutType.Mountain);
        }
        String finalPart = "";
        finalPart = cc.skipStats() ? Tann.randomString(5) : cc.getWins() + ":" + cc.getLosses();
        String hashString = Main.getSettings().getHighscoreIdentifier() + cc.mode.getName() + cc.describeConfig() + finalPart;
        AnticheeseData acd = cc.getAnticheese();
        if (acd != null) {
            hashString = hashString + acd;
        }
        int hash = hashString.hashCode();
        ChanceHaver[] chanceHaverArray = pool = andBasic ? PartyLayoutType.exceptBasic() : PartyLayoutType.includingBasic();
        if (acri != null && (plt = acri.getLayout()) != null && (index = Tann.indexOf(pool, plt)) != -1 && index != pool.length - 1) {
            PartyLayoutType[] newtmp = new PartyLayoutType[pool.length - 1];
            System.arraycopy(pool, 0, newtmp, 0, newtmp.length);
            newtmp[index] = pool[pool.length - 1];
            pool = newtmp;
        }
        List rc = Tann.randomChanced((ChanceHaver[])pool, (int)2, (Random)Tann.makeStdRandom(hash));
        if (andBasic) {
            rc.add(0, PartyLayoutType.Basic);
        }
        return rc;
    }

    public static void startWithPLTChosen(ContextConfig cc, HeroGenType hgt, AntiCheeseRerollInfo acri, PartyLayoutType plt, boolean reroll) {
        DungeonContext dc;
        ContextConfig.resetCache();
        if (reroll) {
            cc.anticheeseReroll();
        }
        if (acri == null) {
            dc = cc.makeContext(acri, Party.generate(cc.getLevelOffset(), hgt, plt, new ArrayList<HeroType>()));
        } else {
            dc = cc.makeContext(acri, Party.generate(cc.getLevelOffset(), hgt, plt, acri.getOldHeroes()));
            dc.setAntiCheeseRerollModifiers(acri.getOldOptions());
        }
        DungeonScreen ds = new DungeonScreen(dc);
        Main.self().setScreen(ds);
    }

    private static boolean tutStartOverride(ContextConfig cc) {
        DifficultyConfig diffCon;
        String pasteOverride;
        if (Main.getSettings().hasAttemptedLevel()) {
            return false;
        }
        if (cc instanceof DifficultyConfig && (pasteOverride = TutorialManager.getTutOverride(diffCon = (DifficultyConfig)cc)) != null) {
            PasteMode.attemptToStartFromString(pasteOverride, cc);
            return true;
        }
        return false;
    }

    private static boolean anticheeseOverride(ContextConfig cc) {
        AnticheeseData saved;
        String anticheese = cc.getAnticheeseKey();
        if (anticheese != null && (saved = Main.getSettings().getSavedAnticheese(anticheese)) != null && saved.getSaveState() != null) {
            SaveState ss = saved.getSaveState().toState();
            if (!cc.antiCheeseHeroes()) {
                ss.dungeonContext.setParty(cc.getStartingParty(PartyLayoutType.random(), null));
            }
            ss.start();
            return true;
        }
        return false;
    }
}

