/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.statics.bullet;

import com.badlogic.gdx.Gdx;
import com.tann.dice.Main;

public class CameraCalc {
    public static float calcDistFromEstimatedBounds(float w, float h) {
        float res = CameraCalc.twoNineAlphaAlgo(w, h);
        res = CameraCalc.makeExtremeRatioAdjustment(res, w, h);
        res = CameraCalc.makeUserAdjustment(res);
        return res;
    }

    private static float makeUserAdjustment(float res) {
        int v = 0;
        switch (v) {
            default: {
                return res;
            }
            case 1: {
                return res * 1.3f;
            }
            case 2: 
        }
        return res * 0.85f;
    }

    private static float makeExtremeRatioAdjustment(float res, float w, float h) {
        if (Main.isPortrait()) {
            return res;
        }
        float estHeight = h * (float)Gdx.graphics.getHeight();
        float estWidth = w * (float)Gdx.graphics.getWidth() - 0.0f;
        float dr = Math.min(9.0f, estWidth / estHeight - 1.5f) * 0.6f;
        if (dr > 0.0f) {
            System.out.println("aab" + dr);
            return res + dr;
        }
        return res;
    }

    private static float twoNineAlphaAlgo(float w, float h) {
        float estHeight = h * (float)Gdx.graphics.getHeight();
        float estWidth = w * (float)Gdx.graphics.getWidth() - 0.0f;
        float cancelNaturalHeightScale = estHeight * 0.015f;
        float calc = 1.0f / (estWidth * estHeight);
        float pow = 0.5f;
        float mult = 300.0f;
        float res = (float)(Math.pow(calc, pow) * (double)mult) * cancelNaturalHeightScale;
        return res *= Main.isPortrait() ? 1.6f : 1.0f;
    }
}

