/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.test;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.tann.dice.Main;
import com.tann.dice.gameplay.battleTest.Difficulty;
import com.tann.dice.gameplay.battleTest.Zone;
import com.tann.dice.gameplay.content.ent.EntSize;
import com.tann.dice.gameplay.content.ent.die.side.EntSide;
import com.tann.dice.gameplay.content.ent.die.side.EntSidesLib;
import com.tann.dice.gameplay.content.ent.die.side.blob.ESB;
import com.tann.dice.gameplay.content.ent.die.side.blob.EntSidesBlobBig;
import com.tann.dice.gameplay.content.ent.group.Party;
import com.tann.dice.gameplay.content.ent.type.EntType;
import com.tann.dice.gameplay.content.ent.type.HeroCol;
import com.tann.dice.gameplay.content.ent.type.HeroType;
import com.tann.dice.gameplay.content.ent.type.MonsterType;
import com.tann.dice.gameplay.content.ent.type.lib.EntTypeUtils;
import com.tann.dice.gameplay.content.ent.type.lib.HeroTypeLib;
import com.tann.dice.gameplay.content.ent.type.lib.HeroTypeUtils;
import com.tann.dice.gameplay.content.ent.type.lib.MonsterTypeLib;
import com.tann.dice.gameplay.content.gen.pipe.Pipe;
import com.tann.dice.gameplay.content.gen.pipe.PipeMaster;
import com.tann.dice.gameplay.content.gen.pipe.entity.hero.generate.PipeHeroGenerated;
import com.tann.dice.gameplay.content.gen.pipe.entity.monster.PipeMonsterJinx;
import com.tann.dice.gameplay.content.gen.pipe.mod.PipeMod;
import com.tann.dice.gameplay.content.item.Item;
import com.tann.dice.gameplay.content.item.ItemLib;
import com.tann.dice.gameplay.context.DungeonContext;
import com.tann.dice.gameplay.context.config.ContextConfig;
import com.tann.dice.gameplay.context.config.EventUtils;
import com.tann.dice.gameplay.context.config.cursed.CurseConfig;
import com.tann.dice.gameplay.context.config.difficultyConfig.ClassicConfig;
import com.tann.dice.gameplay.context.config.difficultyConfig.LootConfig;
import com.tann.dice.gameplay.context.config.event.EventGenerator;
import com.tann.dice.gameplay.effect.Trait;
import com.tann.dice.gameplay.effect.eff.Eff;
import com.tann.dice.gameplay.effect.eff.EffType;
import com.tann.dice.gameplay.effect.eff.TargetingType;
import com.tann.dice.gameplay.effect.eff.VisualEffectType;
import com.tann.dice.gameplay.effect.eff.keyword.KUtils;
import com.tann.dice.gameplay.effect.eff.keyword.Keyword;
import com.tann.dice.gameplay.effect.targetable.ability.Ability;
import com.tann.dice.gameplay.effect.targetable.ability.AbilityUtils;
import com.tann.dice.gameplay.effect.targetable.ability.spell.Spell;
import com.tann.dice.gameplay.effect.targetable.ability.spell.SpellLib;
import com.tann.dice.gameplay.effect.targetable.ability.spell.SpellUtils;
import com.tann.dice.gameplay.level.Level;
import com.tann.dice.gameplay.mode.Mode;
import com.tann.dice.gameplay.mode.creative.custom.CustomPreset;
import com.tann.dice.gameplay.modifier.ModifierLib;
import com.tann.dice.gameplay.modifier.modBal.ModTierUtils;
import com.tann.dice.gameplay.phase.Phase;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.ChoicePhase;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.Choosable;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.ChoosableUtils;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.special.ReplaceChoosable;
import com.tann.dice.gameplay.progress.UnlockManager;
import com.tann.dice.gameplay.progress.chievo.AchLib;
import com.tann.dice.gameplay.progress.chievo.Achievement;
import com.tann.dice.gameplay.progress.chievo.achievementTypes.debug.PlaceholderAchievement;
import com.tann.dice.gameplay.progress.chievo.achievementTypes.timing.equip.EquipAchievement;
import com.tann.dice.gameplay.progress.chievo.unlock.Unlockable;
import com.tann.dice.gameplay.progress.stats.stat.Stat;
import com.tann.dice.gameplay.progress.stats.stat.StatLib;
import com.tann.dice.gameplay.save.SaveState;
import com.tann.dice.gameplay.save.settings.option.Option;
import com.tann.dice.gameplay.save.settings.option.OptionLib;
import com.tann.dice.gameplay.trigger.Collision;
import com.tann.dice.gameplay.trigger.Trigger;
import com.tann.dice.gameplay.trigger.global.Global;
import com.tann.dice.gameplay.trigger.global.chance.GlobalRarity;
import com.tann.dice.gameplay.trigger.global.item.GlobalStartWithItem;
import com.tann.dice.gameplay.trigger.global.linked.GlobalLinked;
import com.tann.dice.gameplay.trigger.global.linked.all.GlobalAllEntities;
import com.tann.dice.gameplay.trigger.global.linked.all.GlobalHeroes;
import com.tann.dice.gameplay.trigger.global.phase.addPhase.GlobalAddPhase;
import com.tann.dice.gameplay.trigger.global.phase.addPhase.phaseGen.PhaseGeneratorDifficulty;
import com.tann.dice.gameplay.trigger.global.scaffolding.levelRequirement.LevelRequirement;
import com.tann.dice.gameplay.trigger.global.scaffolding.levelRequirement.LevelRequirementHash;
import com.tann.dice.gameplay.trigger.global.scaffolding.turnRequirement.GlobalTurnRequirement;
import com.tann.dice.gameplay.trigger.global.spell.GlobalLearnSpell;
import com.tann.dice.gameplay.trigger.personal.AvoidDeathPenalty;
import com.tann.dice.gameplay.trigger.personal.ForceEquip;
import com.tann.dice.gameplay.trigger.personal.IncomingEffBonus;
import com.tann.dice.gameplay.trigger.personal.KeepShields;
import com.tann.dice.gameplay.trigger.personal.LostOnDeath;
import com.tann.dice.gameplay.trigger.personal.MultiplyDamageTaken;
import com.tann.dice.gameplay.trigger.personal.OnOverheal;
import com.tann.dice.gameplay.trigger.personal.OnRescue;
import com.tann.dice.gameplay.trigger.personal.Permadeath;
import com.tann.dice.gameplay.trigger.personal.Personal;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.AffectSides;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.condition.SpecificSidesCondition;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.condition.SpecificSidesType;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.effect.AddKeyword;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.effect.AffectByIndex;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.effect.AffectSideEffect;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.effect.FlatBonus;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.effect.ReplaceWithEnt;
import com.tann.dice.gameplay.trigger.personal.death.DamageAdjacentsOnDeath;
import com.tann.dice.gameplay.trigger.personal.death.OnDeathEffect;
import com.tann.dice.gameplay.trigger.personal.death.OtherDeathEffect;
import com.tann.dice.gameplay.trigger.personal.eff.AfterUseDiceEffect;
import com.tann.dice.gameplay.trigger.personal.eff.EndOfTurnEff;
import com.tann.dice.gameplay.trigger.personal.eff.EndOfTurnMana;
import com.tann.dice.gameplay.trigger.personal.eff.StartOfCombat;
import com.tann.dice.gameplay.trigger.personal.eff.StartOfTurnSelf;
import com.tann.dice.gameplay.trigger.personal.hp.EmptyPips;
import com.tann.dice.gameplay.trigger.personal.hp.MaxHP;
import com.tann.dice.gameplay.trigger.personal.immunity.DamageImmunity;
import com.tann.dice.gameplay.trigger.personal.immunity.HealImmunity;
import com.tann.dice.gameplay.trigger.personal.immunity.ShieldImmunity;
import com.tann.dice.gameplay.trigger.personal.item.ItemSlots;
import com.tann.dice.gameplay.trigger.personal.linked.PersonalTurnRequirement;
import com.tann.dice.gameplay.trigger.personal.linked.TriggerPersonalToGlobal;
import com.tann.dice.gameplay.trigger.personal.specialPips.GhostHP;
import com.tann.dice.gameplay.trigger.personal.specialPips.SpecialHp;
import com.tann.dice.gameplay.trigger.personal.specialPips.resistive.StoneSpecialHp;
import com.tann.dice.gameplay.trigger.personal.spell.AfterUseAbility;
import com.tann.dice.gameplay.trigger.personal.spell.learn.LearnSpell;
import com.tann.dice.gameplay.trigger.personal.spell.learn.LearnTactic;
import com.tann.dice.gameplay.trigger.personal.startBuffed.StartPetrified;
import com.tann.dice.gameplay.trigger.personal.startBuffed.StartPoisoned;
import com.tann.dice.gameplay.trigger.personal.startBuffed.StartRegenned;
import com.tann.dice.screens.dungeon.panels.book.page.stuffPage.PipeType;
import com.tann.dice.screens.dungeon.panels.entPanel.EntPanel;
import com.tann.dice.screens.dungeon.panels.entPanel.choosablePanel.ItemPanel;
import com.tann.dice.screens.dungeon.panels.entPanel.choosablePanel.ModifierPanel;
import com.tann.dice.screens.dungeon.panels.tutorial.TutorialManager;
import com.tann.dice.test.util.Skip;
import com.tann.dice.test.util.SkipNonTann;
import com.tann.dice.test.util.Slow;
import com.tann.dice.test.util.Specific;
import com.tann.dice.test.util.Test;
import com.tann.dice.test.util.TestRunner;
import com.tann.dice.util.Colours;
import com.tann.dice.util.DebugUtilsUseful;
import com.tann.dice.util.Tann;
import com.tann.dice.util.TannLog;
import com.tann.dice.util.TannStageUtils;
import com.tann.dice.util.tp.TP;
import com.tann.dice.util.ui.TextMarquee;
import com.tann.dice.util.ui.TextWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class TestValidation {
    @Test
    public static void basicModifierValidation() {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<com.tann.dice.gameplay.modifier.Modifier> duplicateName = new ArrayList<com.tann.dice.gameplay.modifier.Modifier>();
        for (com.tann.dice.gameplay.modifier.Modifier m : ModifierLib.getAll()) {
            if (names.contains(m.getName())) {
                duplicateName.add(m);
            }
            names.add(m.getName());
        }
        Tann.assertTrue("Should be no modifiers with duplicate names: " + duplicateName, duplicateName.size() == 0);
    }

    @Test
    public static void checkForNullItems() {
        DungeonContext dummy = DebugUtilsUseful.dummyContext();
        ArrayList<com.tann.dice.gameplay.modifier.Modifier> bad = new ArrayList<com.tann.dice.gameplay.modifier.Modifier>();
        for (com.tann.dice.gameplay.modifier.Modifier b : ModifierLib.getAll()) {
            List<Item> list;
            Global gt;
            if (b.getGlobals().size() == 0 || !((gt = b.getGlobals().get(0)) instanceof GlobalStartWithItem) || (list = gt.getStartingItems(dummy)) == null) continue;
            for (Item e : list) {
                if (!e.isMissingno()) continue;
                bad.add(b);
            }
        }
        Tann.assertTrue("Should be no modifiers providing null items: " + bad, bad.size() == 0);
    }

    @Test
    public static void validateSpells() {
        ArrayList<Spell> badSpells = new ArrayList<Spell>();
        List<String> excl = Arrays.asList("Zcx");
        for (Spell s : SpellLib.makeAllSpellsList(false)) {
            if (excl.contains(s.getTitle()) || TestValidation.validateSpell(s)) continue;
            badSpells.add(s);
        }
        Tann.assertTrue("Should be no bad spells: " + badSpells, badSpells.size() == 0);
    }

    private static boolean validateSpell(Spell s) {
        if (s.getBaseEffect() == null || s.getTitle() == null || s.getImage() == null || s.getBaseCost() <= 0) {
            return false;
        }
        TextWriter textWriter = new TextWriter(s.getTitle());
        if (textWriter.getWidth() > 33.0f) {
            return false;
        }
        boolean anyVisual = false;
        Eff e = s.getBaseEffect();
        if (e.getType() == EffType.Or) {
            for (boolean b : Tann.BOTH) {
                anyVisual |= e.getOr(b).getVisual() != VisualEffectType.None;
            }
        }
        anyVisual |= e.getVisual() != VisualEffectType.None;
        anyVisual |= e.getSound() != null;
        Object object = e.getKeywords().iterator();
        while (object.hasNext()) {
            Keyword k = (Keyword)((Object)object.next());
            if (SpellUtils.allowAddingKeyword(k)) continue;
            return false;
        }
        return anyVisual;
    }

    @Test
    public static void checkEquipmentArtSize() {
        ArrayList<String> fails = new ArrayList<String>();
        int expectedSize = 14;
        for (Item i : ItemLib.getMasterCopy()) {
            TextureRegion tr;
            if (i.isMissingno() || i.getAbility() != null || (tr = i.getImage()).getRegionWidth() == 14 && tr.getRegionHeight() == 14) continue;
            fails.add(i.getName(false));
        }
        Tann.assertEquals("should be no fails " + fails, 0, fails.size());
    }

    @Test
    public static void noItemsWithTriggerAllEntities() {
        ArrayList<Item> broken = new ArrayList<Item>();
        for (Item i : ItemLib.getMasterCopy()) {
            if (i.getName(false).contains("Cart") || i.getName(false).contains("Wine")) continue;
            for (Personal pt : i.getPersonalTriggers()) {
                Global gt1 = pt.getGlobalFromPersonalTrigger();
                if (!(gt1 instanceof GlobalAllEntities)) continue;
                broken.add(i);
            }
        }
        Tann.assertTrue("Should be no all items " + broken, broken.size() == 0);
    }

    @Test
    public static void noGreenTriggerPips() {
        ArrayList<MonsterType> types = new ArrayList<MonsterType>();
        for (MonsterType mt : MonsterTypeLib.getMasterCopy()) {
            for (Trait t : mt.traits) {
                if (!(t.personal instanceof SpecialHp)) continue;
                SpecialHp tp = (SpecialHp)t.personal;
                TP<TextureRegion, Color> tannp = tp.getPipTannple(false);
                if (tannp.b != Colours.green) continue;
                types.add(mt);
            }
        }
        Tann.assertTrue("Should be no bad monsters: " + types, types.size() == 0);
    }

    @Test
    public static void noDuplicateModifiers() {
        HashMap<String, com.tann.dice.gameplay.modifier.Modifier> map = new HashMap<String, com.tann.dice.gameplay.modifier.Modifier>();
        ArrayList<com.tann.dice.gameplay.modifier.Modifier> fails = new ArrayList<com.tann.dice.gameplay.modifier.Modifier>();
        for (com.tann.dice.gameplay.modifier.Modifier m : ModifierLib.getAll()) {
            String desc = m.getFullDescription();
            boolean skip = false;
            for (Global gt : m.getGlobals()) {
                skip |= gt instanceof GlobalLearnSpell;
                skip |= gt instanceof GlobalStartWithItem;
            }
            if (skip) continue;
            com.tann.dice.gameplay.modifier.Modifier existing = (com.tann.dice.gameplay.modifier.Modifier)map.get(desc);
            if (existing != null) {
                fails.add(existing);
                fails.add(m);
                continue;
            }
            map.put(desc, m);
        }
        Tann.assertTrue("Should be no dupe mods: " + fails, fails.size() == 0);
    }

    @Test
    public static void detectItemsThatShouldBeModifiers() {
        ArrayList<Item> bad = new ArrayList<Item>();
        for (Item i : ItemLib.getMasterCopy()) {
            boolean hasPersonal = false;
            if (i.getPersonalTriggers().size() == 0) continue;
            for (Personal pt : i.getPersonalTriggers()) {
                if (pt instanceof TriggerPersonalToGlobal || pt instanceof StartOfCombat && ((StartOfCombat)pt).eff.getTargetingType() != TargetingType.Self) continue;
                hasPersonal = true;
            }
            if (hasPersonal) continue;
            bad.add(i);
        }
        Tann.assertTrue("Should be no items with only globals: " + bad, bad.size() == 0);
    }

    @Test
    public static void validateChallenges() {
        ArrayList<Achievement> defaultDifficulty = new ArrayList<Achievement>();
        ArrayList<Achievement> noUnlockable = new ArrayList<Achievement>();
        for (Achievement a : AchLib.getChallenges()) {
            if (a.getDifficulty() == -1.0f) {
                defaultDifficulty.add(a);
                TannLog.log(a + " should have difficulty", TannLog.Severity.error);
            }
            if (a.getUnlockables() != null && a.getUnlockables().length != 0) continue;
            noUnlockable.add(a);
        }
        Tann.assertTrue("Should be no challenges without unlockable: " + noUnlockable, noUnlockable.size() == 0);
        Tann.assertTrue("Should be no challenges with default difficulty: " + defaultDifficulty, defaultDifficulty.size() == 0);
    }

    @Test
    public static void validateSecrets() {
        ArrayList<Achievement> unlockableSecrets = new ArrayList<Achievement>();
        for (Achievement a : AchLib.getSecrets()) {
            if (a.getUnlockables() == null || a.getUnlockables().length <= 0) continue;
            unlockableSecrets.add(a);
        }
        Tann.assertTrue("Should be secrets with unlockables: " + unlockableSecrets, unlockableSecrets.size() == 0);
    }

    @Test
    public static void checkForAchievementDuplicates() {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Unlockable> unlocks = new ArrayList<Unlockable>();
        ArrayList<Unlockable> badUs = new ArrayList<Unlockable>();
        ArrayList<Achievement> badAs = new ArrayList<Achievement>();
        for (Achievement a : AchLib.getAll()) {
            if (names.contains(a.getName())) {
                badAs.add(a);
            }
            names.add(a.getName());
            for (Unlockable unlockable : a.getUnlockables()) {
                if (unlockable == null) continue;
                if (unlocks.contains(unlockable)) {
                    badUs.add(unlockable);
                }
                if (Tann.isMissingno(unlockable)) {
                    badAs.add(a);
                }
                unlocks.add(unlockable);
            }
        }
        Tann.assertTrue("Should be no bad achs or unls: " + badAs + "," + badUs, badAs.size() + badUs.size() == 0);
    }

    @Test
    public static void checkForAchievementMissingno() {
        ArrayList<Achievement> missingnoChievos = new ArrayList<Achievement>();
        ArrayList<Unlockable> missingnos = new ArrayList<Unlockable>();
        missingnos.add(MonsterTypeLib.byName("doirgtj"));
        missingnos.add(HeroTypeUtils.byName("doirgtj"));
        missingnos.add(ItemLib.byName("doirgtj"));
        missingnos.add(ModifierLib.byName("doirgtj"));
        block0: for (Achievement a : AchLib.getAll()) {
            for (Unlockable unlockable : a.getUnlockables()) {
                if (unlockable == null || !missingnos.contains(unlockable)) continue;
                missingnoChievos.add(a);
                continue block0;
            }
        }
        Tann.assertTrue("no missingno chiev: " + missingnoChievos, missingnoChievos.size() == 0);
    }

    @Test
    @Slow
    public static void ensureGeneratedHeroesUseAllSides() {
        ArrayList<String> bad = new ArrayList<String>();
        for (HeroCol col : HeroCol.basics()) {
            ArrayList<TextureRegion> list = new ArrayList<TextureRegion>();
            for (EntSide es : HeroTypeUtils.getSidesWithColour(col, false, false)) {
                TextureRegion tr = es.getTexture();
                if (list.contains(tr)) continue;
                list.add(tr);
            }
            list.remove(ESB.swordRoulette.val(1).getTexture());
            for (int attempt = 0; attempt < 1000; ++attempt) {
                for (int tier = 1; tier <= 3; ++tier) {
                    HeroType ht = PipeHeroGenerated.generate(col, tier);
                    for (EntSide es : ht.sides) {
                        list.remove(es.getTexture());
                    }
                }
                if (list.size() == 0) break;
            }
            for (TextureRegion tr : list) {
                bad.add(col.colName + "-" + ((TextureAtlas.AtlasRegion)tr).name);
            }
        }
        Tann.assertTrue("no bads: " + bad, bad.size() == 0);
    }

    @Test
    public static void testSpellUniqueness() {
        ArrayList<String> descriptions = new ArrayList<String>();
        ArrayList<String> allSpellNames = new ArrayList<String>();
        ArrayList<String> nameCollisions = new ArrayList<String>();
        ArrayList<String> descCollisions = new ArrayList<String>();
        for (HeroType ht : HeroTypeLib.getMasterCopy()) {
            for (Trait t : ht.traits) {
                Ability s = t.personal.getAbility();
                if (s == null) continue;
                String name = s.getTitle();
                if (allSpellNames.contains(name)) {
                    nameCollisions.add(name);
                } else {
                    allSpellNames.add(name);
                }
                String description = s.getClass().getSimpleName() + " " + s.describe();
                if (descriptions.contains(description)) {
                    descCollisions.add(description);
                    continue;
                }
                descriptions.add(description);
            }
        }
        Tann.assertTrue("Name collisions should be empty: " + nameCollisions, nameCollisions.size() == 0);
        Tann.assertTrue("Desc collisions should be empty: " + descCollisions, descCollisions.size() == 0);
    }

    @Test
    public static void testSideDifference() {
        HashMap<Integer, EntSide> map = new HashMap<Integer, EntSide>();
        ArrayList<EntSide> fails = new ArrayList<EntSide>();
        for (HeroType h : HeroTypeLib.getMasterCopy()) {
            if (h.size != EntSize.reg || h.heroCol == HeroCol.green) continue;
            for (EntSide es : h.sides) {
                int hash = EntSide.badHash(es.getBaseEffect());
                if (es.getBaseEffect().getType() == EffType.Blank || hash == -1) continue;
                if (map.get(hash) == null) {
                    map.put(hash, es);
                    continue;
                }
                if (((EntSide)map.get(hash)).getTexture().equals(es.getTexture())) continue;
                fails.add(es);
            }
        }
        TestRunner.assertTrue("No bad sides " + fails, fails.size() == 0);
    }

    @Test
    public static void test6Sides() {
        for (HeroType ht : HeroTypeLib.getMasterCopy()) {
            if (ht.sides.length == 6) continue;
            TestRunner.assertEquals(ht.getName(false) + " should have 6 sides", 6, ht.sides.length);
        }
        for (MonsterType mt : MonsterTypeLib.getMasterCopy()) {
            if (mt.sides.length == 6) continue;
            TestRunner.assertEquals(mt.getName(false) + " should have 6 sides", 6, mt.sides.length);
        }
    }

    @Test
    public static void testMonsterStats() {
        for (MonsterType mt : MonsterTypeLib.getMasterCopy()) {
            TestRunner.assertEquals("nan effective hp: " + mt.getName(false), false, Float.isNaN(mt.getEffectiveHp()));
            TestRunner.assertEquals("nan avg dmg: " + mt.getName(false), false, Float.isNaN(mt.getAvgEffectTier()));
        }
    }

    @Test
    public static void nameCollision() {
        DungeonContext dummy = DebugUtilsUseful.dummyContext();
        ArrayList<String> itemNames = new ArrayList<String>();
        for (Item item : ItemLib.getMasterCopy()) {
            if (itemNames.contains(item.getName(false))) {
                throw new RuntimeException("duplicate item name: " + item.getName(false));
            }
            itemNames.add(item.getName(false).toLowerCase());
        }
        ArrayList<String> entNames = new ArrayList<String>();
        for (EntType entType : EntTypeUtils.getAll()) {
            if (entNames.contains(entType.getName(false))) {
                throw new RuntimeException("duplicate hero name: " + entType.getName(false));
            }
            entNames.add(entType.getName(false).toLowerCase());
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (com.tann.dice.gameplay.modifier.Modifier m : ModifierLib.getAll()) {
            int skip = 0;
            for (Global t : m.getGlobals()) {
                if (t.getStartingItems(dummy) == null) continue;
                skip = 1;
            }
            if (skip != 0) continue;
            if (arrayList.contains(m.getName())) {
                throw new RuntimeException("duplicate modifier name: " + m.getName());
            }
            arrayList.add(m.getName().toLowerCase());
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (Keyword k : Keyword.values()) {
            arrayList2.add(k.getName().toLowerCase());
        }
        for (String s : arrayList2) {
            if (entNames.contains(s)) {
                throw new RuntimeException("hero/keyword collsision: " + s);
            }
            if (arrayList.contains(s)) {
                throw new RuntimeException("modifier/keyword collsision: " + s);
            }
            if (!itemNames.contains(s)) continue;
            throw new RuntimeException("item/keyword collsision: " + s);
        }
        for (String s : itemNames) {
            if (entNames.contains(s)) {
                throw new RuntimeException("hero/item collsision: " + s);
            }
            if (!arrayList.contains(s)) continue;
            throw new RuntimeException("modifier/item collsision: " + s);
        }
        for (String s : entNames) {
            if (!arrayList.contains(s)) continue;
            throw new RuntimeException("hero/modifier collision: " + s);
        }
    }

    @Test
    public static void indexPipeTest() {
        DungeonContext dummy = DebugUtilsUseful.dummyContext();
        ArrayList<String> itemNames = new ArrayList<String>();
        for (Item item : ItemLib.getMasterCopy()) {
            if (itemNames.contains(item.getName(false))) {
                throw new RuntimeException("duplicate item name: " + item.getName(false));
            }
            itemNames.add(item.getName(false).toLowerCase());
        }
        ArrayList<String> entNames = new ArrayList<String>();
        for (EntType entType : EntTypeUtils.getAll()) {
            if (entNames.contains(entType.getName(false))) {
                throw new RuntimeException("duplicate hero name: " + entType.getName(false));
            }
            entNames.add(entType.getName(false).toLowerCase());
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (com.tann.dice.gameplay.modifier.Modifier modifier : ModifierLib.getAll()) {
            int skip = 0;
            for (Global t : modifier.getGlobals()) {
                if (t.getStartingItems(dummy) == null) continue;
                skip = 1;
            }
            if (skip != 0) continue;
            if (arrayList.contains(modifier.getName())) {
                throw new RuntimeException("duplicate modifier name: " + modifier.getName());
            }
            arrayList.add(modifier.getName().toLowerCase());
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (Keyword k : Keyword.values()) {
            arrayList2.add(k.getName().toLowerCase());
        }
        ArrayList<String> arrayList3 = new ArrayList<String>();
        arrayList3.addAll(arrayList2);
        arrayList3.addAll(itemNames);
        arrayList3.addAll(entNames);
        arrayList3.addAll(arrayList);
        ArrayList<String> bad = new ArrayList<String>();
        for (String s : arrayList3) {
            if (s.length() > 2 || !Tann.contains("zjuq".toCharArray(), s.charAt(0))) continue;
            bad.add(s);
        }
        Tann.assertBads(bad);
    }

    @Test
    public static void checkItemTriggerPriority() {
        List<Class> exclusions = Arrays.asList(MaxHP.class, IncomingEffBonus.class, OnOverheal.class, OnRescue.class, HealImmunity.class, EmptyPips.class, LearnSpell.class, LearnTactic.class, DamageAdjacentsOnDeath.class, StartOfCombat.class, TriggerPersonalToGlobal.class, StartPoisoned.class, StartPetrified.class, StartRegenned.class, AvoidDeathPenalty.class, AfterUseAbility.class, DamageImmunity.class, OnDeathEffect.class, EndOfTurnMana.class, KeepShields.class, ForceEquip.class, StartOfTurnSelf.class, ShieldImmunity.class, ItemSlots.class, SpecialHp.class, StoneSpecialHp.class, OtherDeathEffect.class, EndOfTurnEff.class, Permadeath.class, LostOnDeath.class, MultiplyDamageTaken.class, AfterUseDiceEffect.class, GhostHP.class);
        HashSet<String> bads = new HashSet<String>();
        for (Item e : ItemLib.getMasterCopy()) {
            for (Trigger trigger : e.getPersonalTriggers()) {
                if (exclusions.contains(trigger.getClass()) || trigger.getPriority() == -10.0f) continue;
                bads.add(trigger.getClass().getSimpleName());
            }
        }
        Tann.assertTrue("No bad triggers: " + bads, bads.size() == 0);
    }

    @Test
    @Skip
    public static void testBlankSides() {
        List<EntSide> sides = EntSidesLib.getAllSidesWithValue();
        ArrayList<EntSide> bads = new ArrayList<EntSide>();
        for (EntSide es : sides) {
            Eff e = es.getBaseEffect();
            if (e.getType() != EffType.Blank || e.describe().contains("exert") || !e.getKeywords().isEmpty() || es.size.getBlank() == es || es == ESB.blankPetrified || es == EntSidesBlobBig.blank || es == ESB.blankSingleUsed || es == ESB.blankExerted || e.hasKeyword(Keyword.cleanse) || es == ESB.blankUnset || es == ESB.blankItem || es == ESB.blankCurse || es == ESB.blankFumble || ((TextureAtlas.AtlasRegion)es.getTexture()).name.contains("/generic")) continue;
            bads.add(es);
        }
        if (bads.size() > 0) {
            System.out.println(bads);
        }
        TestRunner.assertTrue("should be no bads " + bads, bads.size() == 0);
    }

    @Test
    @Skip
    public static void testItemsInOrder() {
        List<Item> eqs = ItemLib.getMasterCopy();
        ArrayList<Item> failed = new ArrayList<Item>();
        int prevTier = -99;
        for (Item e : eqs) {
            if (e.getTier() > 0 && e.getTier() < prevTier) {
                failed.add(e);
            }
            prevTier = e.getTier();
        }
        TestRunner.assertEquals("Should be no bad items: " + failed, 0, failed.size());
    }

    @Test
    @Skip
    public static void testAllItemsDescribed() {
        ArrayList<Item> failed = new ArrayList<Item>();
        for (Item e : ItemLib.getMasterCopy()) {
            for (Trigger trigger : e.getPersonalTriggers()) {
                if (trigger.makePanelActor(true) != null) continue;
                failed.add(e);
            }
        }
        Tann.assertEquals("Should be no failed " + failed, 0, failed.size());
    }

    @Test
    public static void checkOmniCollisions() {
        List<String> exceptions = Arrays.asList(new String[0]);
        ArrayList<String> dupes = new ArrayList<String>();
        ArrayList<String> all = new ArrayList<String>();
        for (String s : TestValidation.getAllStrings()) {
            TestValidation.registerString(s, dupes, all);
        }
        dupes.removeAll(exceptions);
        Tann.assertEquals("Should be no dupe names: " + dupes, 0, dupes.size());
    }

    private static List<String> getAllStrings() {
        return TestValidation.getAllStrings(true, true, true, true, true);
    }

    private static List<String> getAllStrings(boolean keyword, boolean spell, boolean item, boolean entity, boolean modifiers) {
        ArrayList<String> result = new ArrayList<String>();
        if (keyword) {
            for (Keyword k : Keyword.values()) {
                result.add(k.getName());
            }
        }
        if (spell) {
            for (Ability s : AbilityUtils.getAll()) {
                result.add(s.getTitle());
            }
        }
        if (item) {
            for (Item e : ItemLib.getMasterCopy()) {
                result.add(e.getName(false));
            }
        }
        if (entity) {
            for (EntType et : EntTypeUtils.getAll()) {
                result.add(et.getName(false));
            }
        }
        if (modifiers) {
            for (com.tann.dice.gameplay.modifier.Modifier m : ModifierLib.getAll()) {
                boolean itemCurse = false;
                for (Global gt : m.getGlobals()) {
                    if (!(gt instanceof GlobalStartWithItem)) continue;
                    itemCurse = true;
                }
                if (itemCurse) continue;
                result.add(m.getName());
            }
        }
        return result;
    }

    private static void registerString(String s, List<String> dupes, List<String> all) {
        if (all.contains(s = s.toLowerCase())) {
            dupes.add(s);
        } else {
            all.add(s);
        }
    }

    @Test
    public static void checkBlight() {
        for (com.tann.dice.gameplay.modifier.Modifier c : PipeMonsterJinx.makeAllCurses()) {
            TestRunner.assertTrue("Should be no null accursed curses", c != null);
            TestRunner.assertTrue("Should be no missingno accursed curses", c != PipeMod.getMissingno());
        }
        PipeMonsterJinx pmj = new PipeMonsterJinx();
        for (int i = 0; i < PipeMonsterJinx.makeAllCurses().size(); ++i) {
            MonsterType mt = pmj.makeIndexed(i);
            TestRunner.assertTrue("Should be no null accursed curse descriptions", !((Trait)mt.traits.get((int)0)).personal.describeForSelfBuff().contains(" random "));
        }
    }

    @Test
    public static void metaOrderingTest() {
        ArrayList<com.tann.dice.gameplay.modifier.Modifier> metaFirst = new ArrayList<com.tann.dice.gameplay.modifier.Modifier>();
        for (com.tann.dice.gameplay.modifier.Modifier m : ModifierLib.getAll()) {
            if (m.getName().equalsIgnoreCase("skip") || !m.getGlobals().get(0).metaOnly()) continue;
            metaFirst.add(m);
        }
        Tann.assertTrue("Should be no metas first: " + metaFirst, metaFirst.size() == 0);
    }

    @Test
    public static void sideSize() {
        ArrayList<EntType> bad = new ArrayList<EntType>();
        for (EntType et : EntTypeUtils.getAll()) {
            EntSize sz = et.size;
            for (EntSide es : et.sides) {
                if (es.size == sz) continue;
                bad.add(et);
            }
        }
        Tann.assertTrue("Should be no bad size: " + bad, bad.size() == 0);
    }

    @Test
    public static void chievoTypes() {
        UnlockManager um = Main.self().masterStats.getUnlockManager();
        List<Achievement> all = um.getAllAchievements();
        List<Achievement> types = um.getAllTypedAchievements();
        Comparator<Achievement> comp = new Comparator<Achievement>(){

            @Override
            public int compare(Achievement o1, Achievement o2) {
                return o2.getName().compareTo(o1.getName());
            }
        };
        Collections.sort(all, comp);
        Collections.sort(types, comp);
        ArrayList<Achievement> tmp = new ArrayList<Achievement>(all);
        tmp.removeAll(types);
        Tann.assertTrue("All should contain none not in types: " + tmp, tmp.isEmpty());
        Tann.assertEquals("Achievement lists should be the same size", all.size(), types.size());
        Tann.assertTrue("Achievement lists should be identical", all.equals(types));
    }

    @Test
    public static void chievoMissingno() {
        EquipAchievement.testMissingno();
    }

    @Test
    public static void unusedPortraits() {
        ArrayList<TextureAtlas.AtlasRegion> used = new ArrayList<TextureAtlas.AtlasRegion>();
        for (MonsterType mt : MonsterTypeLib.getMasterCopy()) {
            used.add(mt.portrait);
        }
        for (HeroType ht : HeroTypeLib.getMasterCopy()) {
            used.add(ht.portrait);
        }
        ArrayList<TextureAtlas.AtlasRegion> bads = new ArrayList<TextureAtlas.AtlasRegion>();
        for (TextureAtlas.AtlasRegion ar : Tann.getRegionsStartingWith(Main.atlas, "portrait")) {
            String tName = ar.name.toLowerCase();
            if (tName.contains("unused/") || tName.contains("placeholder/") || tName.contains("old/") || tName.contains("to") || tName.contains("/rnd/") || tName.contains("Tw1n".toLowerCase()) || tName.contains("error") || tName.contains("special/") || used.contains(ar)) continue;
            bads.add(ar);
        }
        Tann.assertTrue("Should be no unused portraits: " + bads, bads.size() == 0);
    }

    @Test
    public static void validateMonsterSideOrdering() {
        ArrayList<MonsterType> badTypes = new ArrayList<MonsterType>();
        List<TP> tests = Arrays.asList(new TP<Integer, Integer>(0, 1), new TP<Integer, Integer>(1, 4), new TP<Integer, Integer>(4, 5), new TP<Integer, Integer>(2, 5), new TP<Integer, Integer>(3, 5));
        List<MonsterType> list = MonsterTypeLib.getMasterCopy();
        list.removeAll(Arrays.asList(MonsterTypeLib.byName("sudul"), MonsterTypeLib.byName("chaos orb"), MonsterTypeLib.byName("the hand"), MonsterTypeLib.byName("golem")));
        block0: for (MonsterType mt : list) {
            EntSide[] sides = mt.getNiceSides();
            for (TP t : tests) {
                if (sides[(Integer)t.a].getBaseEffect().getValue() >= sides[(Integer)t.b].getBaseEffect().getValue()) continue;
                badTypes.add(mt);
                continue block0;
            }
        }
        Tann.assertTrue("bad types is empty: " + badTypes, badTypes.isEmpty());
    }

    @Test
    public static void duplicateStatNames() {
        List<Stat> allStats = StatLib.makeAllStats();
        HashSet<String> names = new HashSet<String>();
        ArrayList<String> badNames = new ArrayList<String>();
        for (Stat s : allStats) {
            String name = s.getName();
            if (names.contains(name)) {
                badNames.add(name);
                continue;
            }
            names.add(name);
        }
        Tann.assertTrue("no bad names: " + badNames, badNames.size() == 0);
    }

    @Test
    @SkipNonTann
    public static void checkBoptia() {
        ArrayList<Option> fields = new ArrayList<Option>();
        for (Field f : OptionLib.class.getDeclaredFields()) {
            if (!Modifier.isStatic(f.getModifiers()) || !Option.class.isAssignableFrom(f.getType())) continue;
            try {
                fields.add((Option)f.get(null));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        List<Option> method = OptionLib.getAll();
        Tann.assertEquals("Should be equal meth/fie", method.size(), fields.size());
    }

    @Test
    public static void noPlaceholderWhenPrepping() {
        for (Achievement a : AchLib.getAll()) {
            if (!(a instanceof PlaceholderAchievement)) continue;
            throw new RuntimeException("placeholder achievement found");
        }
    }

    @Test
    public static void generateValidationOfDesignedHeroes() {
        ArrayList<HeroType> bads = new ArrayList<HeroType>();
        List<String> excl = Arrays.asList("statue", "Twin", "sidey", "sculpture");
        for (HeroType ht : HeroTypeLib.getMasterCopy()) {
            if (excl.contains(ht.getName(false).toLowerCase()) || PipeHeroGenerated.finalChecks(ht)) continue;
            bads.add(ht);
        }
        Tann.assertTrue("Should be no bads: " + bads, bads.isEmpty());
    }

    @Test
    public static void ensureLootModeCannotGenerateDeepPockets() {
        DungeonContext dc = new LootConfig(Difficulty.Heaven).makeContext();
        int ATTEMPTS = 20;
        for (int i = 0; i < 20; ++i) {
            List<com.tann.dice.gameplay.modifier.Modifier> mods = PhaseGeneratorDifficulty.getModifiersForChoiceDebug(Difficulty.Heaven, dc);
            Tann.assertTrue("no dps", !mods.contains(ModifierLib.byName("Deep Pockets")));
            Tann.assertTrue("no Better Items", !mods.contains(ModifierLib.byName("Better Items")));
        }
    }

    @Test
    public static void ensureCollisionBitsDiffer() {
        Class<Collision> clazz = Collision.class;
        long bits = 0L;
        ArrayList<String> bads = new ArrayList<String>();
        for (Field f : clazz.getFields()) {
            if (f.getType() != Long.TYPE) continue;
            try {
                long val = (Long)f.get(null);
                if ((bits & val) > 0L) {
                    bads.add(f.getName());
                }
                bits |= val;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        Tann.assertTrue("no bads: " + bads, bads.isEmpty());
    }

    @Test
    public static void hoarderCollectorCurator() {
        ArrayList<TextureRegion> allRegions = new ArrayList<TextureRegion>();
        for (String s : new String[]{"hoarder", "collector", "curator"}) {
            HeroType ht = HeroTypeLib.byName(s);
            Tann.assertTrue(!ht.isMissingno());
            for (EntSide es : ht.sides) {
                allRegions.add(es.getTexture());
            }
        }
        Tann.uniquify(allRegions);
        Tann.assertEquals("Should be 18 unique sides", 18, allRegions.size());
    }

    @Test
    public static void noUnnecessaryAlls() {
        ArrayList<Item> fails = new ArrayList<Item>();
        for (Item item : ItemLib.getMasterCopy()) {
            for (Personal personalTrigger : item.getPersonalTriggers()) {
                AffectSideEffect first;
                AffectSides as;
                if (!(personalTrigger instanceof AffectSides) || (as = (AffectSides)personalTrigger).getEffects().size() == 0 || (first = as.getEffects().get(0)) instanceof AffectByIndex || first instanceof ReplaceWithEnt || as.getConditions().size() != 1 || !(as.getConditions().get(0) instanceof SpecificSidesCondition) || ((SpecificSidesCondition)as.getConditions().get((int)0)).specificSidesType != SpecificSidesType.All) continue;
                fails.add(item);
            }
        }
        Tann.assertTrue("Should be no fails: " + fails, fails.isEmpty());
    }

    @Test
    public static void checkSST() {
        ArrayList<String> shorts = new ArrayList<String>();
        for (SpecificSidesType value : SpecificSidesType.values()) {
            shorts.add(value.getShortName());
        }
        int size = shorts.size();
        Tann.uniquify(shorts);
        Tann.assertEquals("Should be no dupe shorts", size, shorts.size());
    }

    @Test
    public static void bannedCharactersInSpellsHeroesModifiersItems() {
        ArrayList<String> banned = new ArrayList<String>(Arrays.asList(":", "add ", "summon "));
        String alsoBanned = "-+'.+#$\u00a3*&%!():;@?,<>\\\"[]{}`\u00ac";
        for (char c : alsoBanned.toCharArray()) {
            banned.add("" + c);
        }
        ArrayList<String> bads = new ArrayList<String>();
        Object object = TestValidation.getAllStrings().iterator();
        while (object.hasNext()) {
            String s = (String)object.next();
            for (String b : banned) {
                if (!s.contains(b)) continue;
                bads.add(s);
            }
        }
        Tann.assertEquals("Should be no bads: " + bads, 0, bads.size());
    }

    @Test
    public static void specificModeAddPhaseCheck() {
        ArrayList<String> bads = new ArrayList<String>();
        for (Mode m : Mode.getAllModes()) {
            List<ContextConfig> confs = m.getConfigs();
            if (confs.size() == 0) continue;
            ContextConfig c = confs.get(0);
            for (Global g : c.getSpecificModeGlobals()) {
                if (!(g instanceof GlobalAddPhase)) continue;
                bads.add(m.getName() + ":" + g.getClass().getSimpleName());
            }
        }
        Tann.assertEquals("Should be no bads: " + bads, 0, bads.size());
    }

    @Test
    public static void checkBoptionDuplication() {
        ArrayList<Option> all = new ArrayList<Option>();
        for (OptionLib.EscBopType value : OptionLib.EscBopType.values()) {
            all.addAll(value.getOptions());
        }
        int amt = all.size();
        Tann.uniquify(all);
        int newAmt = all.size();
        Tann.assertEquals("should be no dupebopt", amt, newAmt);
    }

    @Test
    @Skip
    public static void checkModifiersForMergeableAllEntities() {
        ArrayList<com.tann.dice.gameplay.modifier.Modifier> bads = new ArrayList<com.tann.dice.gameplay.modifier.Modifier>();
        for (com.tann.dice.gameplay.modifier.Modifier modifier : ModifierLib.getAll()) {
            GlobalAllEntities prev = null;
            for (Global global : modifier.getGlobals()) {
                if (!(global instanceof GlobalAllEntities)) continue;
                GlobalAllEntities nw = (GlobalAllEntities)global;
                if (prev != null && prev.getPlayer() == nw.getPlayer()) {
                    bads.add(modifier);
                }
                prev = nw;
            }
        }
        Tann.assertTrue("should be no bads: " + bads, bads.isEmpty());
    }

    @Test
    public static void allShouldReturnSelf() {
        ArrayList<Object> bads = new ArrayList<Object>();
        for (Item item : ItemLib.getMasterCopy()) {
            if (ItemLib.byName(item.getName(false)) == item) continue;
            bads.add(item);
        }
        for (HeroType ht : HeroTypeLib.getMasterCopy()) {
            if (HeroTypeLib.byName(ht.getName(false)) == ht) continue;
            bads.add(ht);
        }
        for (com.tann.dice.gameplay.modifier.Modifier m : ModifierLib.getAll()) {
            if (ModifierLib.byName(m.getName()) == m) continue;
            bads.add(m);
        }
        for (MonsterType mt : MonsterTypeLib.getMasterCopy()) {
            if (MonsterTypeLib.byName(mt.getName(false)) == mt) continue;
            bads.add(mt);
        }
        Tann.assertTrue("should be no bads: " + bads, bads.isEmpty());
    }

    @Test
    public static void noZoneMissingno() {
        ArrayList<Zone> bads = new ArrayList<Zone>();
        for (Zone z : Zone.values()) {
            for (MonsterType validMonster : z.validMonsters) {
                if (!validMonster.isMissingno()) continue;
                bads.add(z);
            }
        }
        Tann.assertTrue("should be no bads: " + bads, bads.isEmpty());
    }

    @Test
    @Skip
    public static void noSpecialCharacterItems() {
        List<Character> isp = TestValidation.getUsedSpecialChars(true, false, false, false);
        Tann.assertTrue("Should be no item spch: " + isp, isp.isEmpty());
    }

    @Test
    @Skip
    public static void noSpecialCharacterHeroMonster() {
        List<Character> isp = TestValidation.getUsedSpecialChars(false, true, true, false);
        Tann.assertTrue("Should be no heromon spch: " + isp, isp.isEmpty());
    }

    @Test
    @Skip
    public static void noSpecialCharacterHeroModifier() {
        List<Character> isp = TestValidation.getUsedSpecialChars(false, false, false, true);
        Tann.assertTrue("Should be no mod spch: " + isp, isp.isEmpty());
    }

    public static List<Character> getUsedSpecialChars(boolean items, boolean heroes, boolean monsters, boolean modifiers) {
        String s;
        String regex = "[a-zA-Z0-9' ]";
        ArrayList<Character> result = new ArrayList<Character>();
        if (items) {
            for (Item item : ItemLib.getMasterCopy()) {
                if (item.getAbility() != null) continue;
                s = item.getName().replaceAll(regex, "");
                for (char c : s.toCharArray()) {
                    result.add(Character.valueOf(c));
                }
            }
        }
        if (heroes) {
            for (HeroType heroType : HeroTypeLib.getMasterCopy()) {
                s = heroType.getName().replaceAll(regex, "");
                for (char c : s.toCharArray()) {
                    result.add(Character.valueOf(c));
                }
            }
        }
        if (monsters) {
            for (MonsterType monsterType : MonsterTypeLib.getMasterCopy()) {
                s = monsterType.getName().replaceAll(regex, "");
                for (char c : s.toCharArray()) {
                    result.add(Character.valueOf(c));
                }
            }
        }
        if (modifiers) {
            for (com.tann.dice.gameplay.modifier.Modifier modifier : ModifierLib.getAll()) {
                s = modifier.getName().replaceAll(regex, "");
                for (char c : s.toCharArray()) {
                    result.add(Character.valueOf(c));
                }
            }
        }
        Tann.uniquify(result);
        return result;
    }

    @Test
    public static void roundtripGenerated() {
        TestValidation.roundtripTest(false);
    }

    @Test
    public static void roundtripWild() {
        TestValidation.roundtripTest(true);
    }

    private static void roundtripTest(boolean wild) {
        List<com.tann.dice.gameplay.modifier.Modifier> mods = PipeMod.makeGenerated(50, null, wild);
        ArrayList<com.tann.dice.gameplay.modifier.Modifier> bads = new ArrayList<com.tann.dice.gameplay.modifier.Modifier>();
        for (com.tann.dice.gameplay.modifier.Modifier mod : mods) {
            String mn = mod.getName();
            if (mn.equalsIgnoreCase(ModifierLib.byName(mn).getName())) continue;
            bads.add(mod);
        }
        Tann.assertTrue("no bad roundtrip mods: " + bads, bads.isEmpty());
    }

    @Test
    public static void sstValToOne() {
        Tann.assertEquals("should add up to 1", Float.valueOf(1.0f), Float.valueOf(ModTierUtils.keywordToSides(SpecificSidesType.All, 1.0f)));
    }

    private static List<com.tann.dice.gameplay.modifier.Modifier> makeAllList(int genAmt) {
        ArrayList<com.tann.dice.gameplay.modifier.Modifier> result = new ArrayList<com.tann.dice.gameplay.modifier.Modifier>(ModifierLib.getAll());
        for (boolean b : Tann.BOTH) {
            result.addAll(PipeMod.makeGenerated(genAmt, null, b));
        }
        return result;
    }

    @Test
    public static void noDoubleRarity() {
        ArrayList<com.tann.dice.gameplay.modifier.Modifier> bads = new ArrayList<com.tann.dice.gameplay.modifier.Modifier>();
        for (com.tann.dice.gameplay.modifier.Modifier modifier : TestValidation.makeAllList(200)) {
            int amt = 0;
            for (Global global : modifier.getGlobals()) {
                if (!(global instanceof GlobalRarity)) continue;
                ++amt;
            }
            if (amt <= true) continue;
            bads.add(modifier);
        }
        Tann.assertTrue("Should be no bads: " + bads, bads.isEmpty());
    }

    @Test
    @Slow
    public static void itemOfferShouldNotCollide() {
        int attempts = 10;
        ArrayList<String> bads = new ArrayList<String>();
        for (int attemptIndex = 0; attemptIndex < 10; ++attemptIndex) {
            for (List<Choosable> makeReward : DebugUtilsUseful.makeRewards(20)) {
                for (int i = 0; i < makeReward.size(); ++i) {
                    for (int j = i + 1; j < makeReward.size(); ++j) {
                        if (!ChoosableUtils.collides(makeReward.get(i), makeReward.get(j))) continue;
                        bads.add(makeReward.get(i) + ":" + makeReward.get(j));
                    }
                }
            }
        }
        Tann.assertTrue("No choice coll: " + bads, bads.isEmpty());
    }

    @Test
    public static void noDesignedItemsShouldNeedMarquee() {
        Group cp;
        ArrayList<String> bads = new ArrayList<String>();
        for (Item item : ItemLib.getMasterCopy()) {
            cp = new ItemPanel(item, false);
            if (!TannStageUtils.hasActor(cp, TextMarquee.class)) continue;
            bads.add(item.getName());
        }
        for (com.tann.dice.gameplay.modifier.Modifier mod : ModifierLib.getAll()) {
            cp = new ModifierPanel(mod, false);
            if (!TannStageUtils.hasActor(cp, TextMarquee.class)) continue;
            bads.add(mod.getName());
        }
        for (EntType e : EntTypeUtils.getAll()) {
            cp = new EntPanel(e.makeEnt());
            ((EntPanel)cp).layout();
            if (!TannStageUtils.hasActor(cp, TextMarquee.class)) continue;
            bads.add(e.getName());
        }
        for (int i = bads.size() - 1; i >= 0; --i) {
            String s = (String)bads.get(i);
            if (!s.contains("enduring") && !s.contains("inflict")) continue;
            bads.remove(i);
        }
        Tann.assertTrue("No designed marquees: " + bads, bads.isEmpty());
    }

    @Test
    public static void pipeType() {
        ArrayList<String> bads = new ArrayList<String>();
        ArrayList<String> all = new ArrayList<String>();
        for (PipeType value : PipeType.values()) {
            for (Pipe content : value.contents) {
                if (content.document().equalsIgnoreCase("undocumented") || content instanceof PipeMaster || content.getClass().getSimpleName().contains("Meta")) continue;
                String cn = content.getClass().getSimpleName();
                List os = content.examples(3);
                if (os.size() == 0 || os.get(0) == null) {
                    bads.add(cn + "(failed)");
                }
                if (cn.equalsIgnoreCase("PipeModAllItem") || cn.equalsIgnoreCase("PipeModAllKeyword")) continue;
                if (all.contains(cn)) {
                    bads.add(cn + "(dupe)");
                }
                all.add(cn);
            }
        }
        Tann.assertTrue("no pipe stuff in wrong section: " + bads, bads.isEmpty());
    }

    @Test
    public static void checkPresetMissingno() {
        ArrayList<String> bads = new ArrayList<String>();
        block0: for (CustomPreset customPreset : CustomPreset.getDefault()) {
            for (com.tann.dice.gameplay.modifier.Modifier contentAsModifier : customPreset.getContentAsModifiers()) {
                if (!contentAsModifier.isMissingno()) continue;
                bads.add(customPreset.getTitle());
                continue block0;
            }
        }
        Tann.assertTrue("no buggy presets: " + bads, bads.isEmpty());
    }

    @Test
    public static void checkSideKeywords() {
        ArrayList<String> bads = new ArrayList<String>();
        for (EntSide entSide : EntSidesLib.getAllSidesWithValue()) {
            Eff e = entSide.getBaseEffect();
            if (e.getType() == EffType.Blank) continue;
            Eff base = e.copy();
            base.clearKeywords();
            for (Keyword keyword : e.getKeywords()) {
                if (KUtils.allowAddingKeyword(keyword, base)) continue;
                bads.add(entSide.getTexture().toString());
            }
        }
        Tann.assertTrue("no buggy side keywords: " + bads, bads.isEmpty());
    }

    @Test
    @Slow
    public static void nameCapitalisation() {
        ArrayList<String> bads = new ArrayList<String>();
        ArrayList<String> blob = new ArrayList<String>();
        for (Item item : ItemLib.getMasterCopy()) {
            blob.add(item.getName());
        }
        for (EntType entType : EntTypeUtils.getAll()) {
            blob.add(entType.getName());
        }
        for (String s : blob) {
            char first;
            if (s.startsWith("spell") || s.startsWith("tactic") || Character.isUpperCase(first = s.charAt(0)) || Tann.isInt(first + "")) continue;
            bads.add(s);
        }
        Tann.assertTrue("no uncap: " + bads, bads.isEmpty());
    }

    @Test
    public static void noGeneratedWithRealRarity() {
        TestValidation.testModifierRarityTypes(true);
    }

    private static void testModifierRarityTypes(boolean generated) {
        ArrayList<String> bads = new ArrayList<String>();
        ArrayList<com.tann.dice.gameplay.modifier.Modifier> mods = new ArrayList<com.tann.dice.gameplay.modifier.Modifier>();
        if (generated) {
            mods.addAll(PipeMod.makeGenerated(100, null, false));
            mods.addAll(PipeMod.makeGenerated(100, null, true));
        } else {
            mods.addAll(ModifierLib.getAll());
        }
        for (com.tann.dice.gameplay.modifier.Modifier m : mods) {
            for (Global global : m.getGlobals()) {
                if (!(global instanceof GlobalRarity)) continue;
                bads.add(m.getName());
            }
        }
        Tann.assertTrue("no rarity mismatch: " + bads, bads.isEmpty());
    }

    @Test
    public static void allBlueRedsShouldHaveSpells() {
        ArrayList<String> bads = new ArrayList<String>();
        ArrayList<HeroType> types = new ArrayList<HeroType>();
        types.addAll(HeroTypeUtils.getFilteredTypes(HeroCol.blue, null, true));
        types.addAll(HeroTypeUtils.getFilteredTypes(HeroCol.red, null, true));
        for (HeroType type : types) {
            if (type.getSpell() != null) continue;
            bads.add(type.getName());
        }
        Tann.assertTrue("No bads: " + bads, bads.isEmpty());
    }

    @Test
    @Skip
    public static void doublePlusBad() {
        ArrayList<String> bads = new ArrayList<String>();
        for (com.tann.dice.gameplay.modifier.Modifier modifier : ModifierLib.getAll()) {
            if (Tann.countCharsInString('+', modifier.getName()) <= 1) continue;
            bads.add(modifier.getName());
        }
        Tann.assertTrue("No bads: " + bads, bads.isEmpty());
    }

    @Test
    @Slow
    public static void noDupesBetweenWildAndGen() {
        ArrayList lgen = new ArrayList();
        ArrayList<String> lwild = new ArrayList<String>();
        int amt = 10;
        int tries = 1000;
        for (boolean wild : Tann.BOTH) {
            ArrayList<String> ta = wild ? lwild : lgen;
            for (int i = 0; i < 1000; ++i) {
                for (com.tann.dice.gameplay.modifier.Modifier modifier : PipeMod.makeGenerated(10, null, wild)) {
                    ta.add(modifier.getName());
                }
            }
        }
        Tann.uniquify(lgen);
        Tann.uniquify(lwild);
        List bad = Tann.getSharedItems(lgen, lwild);
        Tann.assertTrue("No shared items " + bad, bad.isEmpty());
    }

    @Test
    public static void affectSidesEffectOrdering() {
        ArrayList<String> bads = new ArrayList<String>();
        for (Item item : ItemLib.getMasterCopy()) {
            for (Personal personalTrigger : item.getPersonalTriggers()) {
                if (!(personalTrigger instanceof AffectSides) || !TestValidation.badAffectSide((AffectSides)personalTrigger)) continue;
                bads.add(item.getName());
            }
        }
        Tann.assertTrue("no bads; " + bads, bads.isEmpty());
    }

    private static boolean badAffectSide(AffectSides as) {
        boolean flatBonusFound = false;
        for (AffectSideEffect effect : as.getEffects()) {
            if (!(flatBonusFound |= effect instanceof FlatBonus) || !(effect instanceof AddKeyword)) continue;
            return true;
        }
        return false;
    }

    @Test
    public static void mandatoryItems() {
        ArrayList<Item> bads = new ArrayList<Item>();
        for (Item item : ItemLib.getMasterCopy()) {
            boolean mandatory = false;
            for (Personal personalTrigger : item.getPersonalTriggers()) {
                if (!(personalTrigger instanceof ForceEquip)) continue;
                mandatory = true;
            }
            if ((item.getTier() <= 0 || !mandatory) && (item.getTier() >= 0 || mandatory)) continue;
            bads.add(item);
        }
        Tann.assertBads(bads);
    }

    @Test
    @Skip
    public static void badHeroSides() {
        ArrayList<HeroType> bads = new ArrayList<HeroType>();
        block0: for (HeroType heroType : HeroTypeLib.getMasterCopy()) {
            for (int i = 0; i < heroType.sides.length; ++i) {
                EntSide sd = heroType.sides[i];
                ArrayList<EntSide> allTex = new ArrayList<EntSide>();
                allTex.add(sd);
                for (int j = 0; j < heroType.sides.length; ++j) {
                    if (i == j) continue;
                    EntSide sdj = heroType.sides[j];
                    if (sd.getTexture() != sdj.getTexture()) continue;
                    allTex.add(sdj);
                }
                if (allTex.size() != 2 || Math.abs(((EntSide)allTex.get(0)).getBaseEffect().getValue() - ((EntSide)allTex.get(1)).getBaseEffect().getValue()) != 1) continue;
                bads.add(heroType);
                continue block0;
            }
        }
        Tann.assertBads(bads);
    }

    @Test
    public static void testModifierEssenceCollision() {
        ArrayList<String> bads = new ArrayList<String>();
        for (com.tann.dice.gameplay.modifier.Modifier m1 : ModifierLib.getAll()) {
            String essence1 = m1.getEssence();
            if (essence1 == null) continue;
            for (com.tann.dice.gameplay.modifier.Modifier m2 : ModifierLib.getAll()) {
                String essence2 = m2.getEssence();
                if (essence2 == null || !essence1.equalsIgnoreCase(essence2) || Collision.collides(m1.getCollisionBits(), m2.getCollisionBits())) continue;
                bads.add(m1 + ":" + m2);
            }
        }
        Tann.assertBads(bads);
    }

    @Test
    public static void afterItemModifiers() {
        ArrayList<com.tann.dice.gameplay.modifier.Modifier> bads = new ArrayList<com.tann.dice.gameplay.modifier.Modifier>();
        for (com.tann.dice.gameplay.modifier.Modifier modifier : ModifierLib.getAll()) {
            AffectSides as;
            GlobalTurnRequirement gtr;
            Global linked;
            Global g = modifier.getSingleGlobalOrNull();
            if (g == null || !(g instanceof GlobalTurnRequirement) || !((linked = (gtr = (GlobalTurnRequirement)g).debugLinked()) instanceof GlobalHeroes)) continue;
            GlobalAllEntities gae = (GlobalAllEntities)linked;
            Personal p = gae.personal;
            if (!(p instanceof AffectSides) || (as = (AffectSides)p).getPriority() == 0.0f) continue;
            bads.add(modifier);
        }
        Tann.assertBads(bads);
    }

    @Test
    public static void noGlobalLinkedWithPTR() {
        ArrayList<com.tann.dice.gameplay.modifier.Modifier> bads = new ArrayList<com.tann.dice.gameplay.modifier.Modifier>();
        for (com.tann.dice.gameplay.modifier.Modifier modifier : ModifierLib.getAll()) {
            for (Global global : modifier.getGlobals()) {
                GlobalLinked gl;
                Trigger t;
                if (!(global instanceof GlobalLinked) || !((t = (gl = (GlobalLinked)global).linkDebug()) instanceof PersonalTurnRequirement)) continue;
                bads.add(modifier);
            }
        }
        Tann.assertBads(bads);
    }

    @Test
    public static void specialEventsLevelOne() {
        ArrayList<EventGenerator> bad = new ArrayList<EventGenerator>();
        for (EventGenerator evg : EventUtils.makeEvents()) {
            LevelRequirement lr = evg.lr;
            if (!(lr instanceof LevelRequirementHash)) continue;
            LevelRequirementHash lrh = (LevelRequirementHash)lr;
            if (lrh.minLevel > 1) continue;
            bad.add(evg);
        }
        Tann.assertBads(bad);
    }

    @Test
    public static void testTutorialPresets() {
        for (Difficulty difficulty : new Difficulty[]{Difficulty.Easy, Difficulty.Hard}) {
            String s = TutorialManager.getTutOverride(new ClassicConfig(difficulty));
            SaveState result = SaveState.loadPasteModeString(s, false);
            String phase = result.phases.get(0);
            String repd = Phase.deserialise(phase).serialise();
            if (!repd.contains(ModifierLib.getMissingno().getName())) continue;
            throw new RuntimeException("Bad tut: " + s);
        }
    }

    @Test
    @Slow
    public static void anotherCurseAttempt() {
        ArrayList<String> bads = new ArrayList<String>();
        for (int runs = 0; runs < 2; ++runs) {
            DungeonContext dc = new DungeonContext(new CurseConfig(), Party.generate(0));
            for (int i = 0; i < 100; ++i) {
                ArrayList<Phase> phases = new ArrayList<Phase>();
                dc.addPhasesFromCurrentLevel(phases);
                for (Phase phase : phases) {
                    if (!(phase instanceof ChoicePhase)) continue;
                    ChoicePhase cp = (ChoicePhase)phase;
                    List<Choosable> options = cp.getOptions();
                    if (options.get(0) instanceof com.tann.dice.gameplay.modifier.Modifier || options.get(0) instanceof ReplaceChoosable) {
                        boolean v = options.get(0).getTier() > 0;
                        for (Choosable option : options) {
                            if (v == option.getTier() > 0) continue;
                            bads.add("Different valence: " + options + ":" + phases);
                        }
                    }
                    Choosable ch = options.get(0);
                    ch.onChoose(dc, 0);
                }
                if (i > 0 && i % 20 == 0) {
                    dc.clearForLoop();
                }
                dc.nextLevel();
                Level l = dc.getCurrentLevel();
                if (!l.hasMissingno()) continue;
                bads.add("missingno level?");
            }
            List<com.tann.dice.gameplay.modifier.Modifier> currentModifiers = dc.getCurrentModifiers();
            ArrayList<com.tann.dice.gameplay.modifier.Modifier> cpy = new ArrayList<com.tann.dice.gameplay.modifier.Modifier>(currentModifiers);
            Tann.uniquify(cpy);
            if (currentModifiers.size() != cpy.size()) {
                bads.add("Duplicate modifiers: " + currentModifiers);
            }
            for (int i = 0; i < currentModifiers.size(); ++i) {
                com.tann.dice.gameplay.modifier.Modifier a = currentModifiers.get(i);
                if (a.isMissingno()) {
                    bads.add("missingno");
                }
                if (a.getEssence() == null) continue;
                for (int j = i + 1; j < currentModifiers.size(); ++j) {
                    com.tann.dice.gameplay.modifier.Modifier b = currentModifiers.get(j);
                    if (!a.getEssence().equalsIgnoreCase(b.getEssence())) continue;
                    bads.add("same essence: " + a + ":" + b);
                }
            }
        }
        Tann.assertBads(bads);
    }

    @Test
    @Slow
    public static void testRunsActivatePhases() {
        ArrayList<String> bads = new ArrayList<String>();
        for (int runs = 0; runs < 10; ++runs) {
            DungeonContext dc = new DungeonContext(new ClassicConfig(Difficulty.Normal), Party.generate(0));
            for (int i = 0; i < 20; ++i) {
                ArrayList<Phase> phases = new ArrayList<Phase>();
                dc.addPhasesFromCurrentLevel(phases);
                for (int j = 0; j < phases.size(); ++j) {
                    Phase phase = (Phase)phases.get(j);
                    try {
                        phase.activate();
                        phase.deactivate();
                        phase.reactivate();
                        continue;
                    }
                    catch (Exception e) {
                        bads.add(e.getClass().getSimpleName() + ":" + phase.getClass().getSimpleName());
                    }
                }
                dc.nextLevel();
            }
        }
        Tann.assertBads(bads);
    }

    @Specific
    @Test
    @Skip
    public static void noBadDebugSpells() {
        ArrayList<Spell> bad = new ArrayList<Spell>();
        for (Spell spell : SpellLib.makeAllSpellsList(true, true, true)) {
            for (Keyword k : spell.getBaseEffect().getKeywords()) {
                if (SpellUtils.allowAddingKeyword(k)) continue;
                bad.add(spell);
            }
        }
        Tann.assertBads(bad);
    }
}

