/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.util;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.utils.SnapshotArray;
import com.tann.dice.Main;
import com.tann.dice.screens.dungeon.panels.Explanel.DiePanel;
import com.tann.dice.util.Draw;
import com.tann.dice.util.Tann;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class TannStageUtils {
    public static void clearActorsOfType(Group g, Class<? extends Actor> actorClass) {
        SnapshotArray<Actor> children = g.getChildren();
        for (int i = children.size - 1; i >= 0; --i) {
            Actor a = (Actor)children.get(i);
            if (!actorClass.isInstance(a)) continue;
            a.remove();
        }
    }

    public static Actor getRandomActor() {
        return TannStageUtils.getActorWithClass(Actor.class, Main.getCurrentScreen());
    }

    public static <T extends Actor> T getActorWithClass(Class<T> c, Group src) {
        List<T> rs = TannStageUtils.getActorsWithClass(c, src);
        if (rs.size() > 0) {
            return (T)((Actor)rs.get(0));
        }
        return null;
    }

    public static List<Actor> getActorsWithName(String name, Group src) {
        ArrayList<Actor> result = new ArrayList<Actor>();
        List<Actor> acs = TannStageUtils.getAllActors(src);
        for (Actor ac : acs) {
            if (!name.equalsIgnoreCase(ac.getName())) continue;
            result.add(ac);
        }
        return result;
    }

    public static <T extends Actor> List<T> getActorsWithClass(Class<T> c, Group src) {
        ArrayList<Actor> result = new ArrayList<Actor>();
        List<Actor> acs = TannStageUtils.getAllActors(src);
        for (Actor ac : acs) {
            if (!c.isInstance(ac)) continue;
            result.add(ac);
        }
        return result;
    }

    public static List<Actor> getAllActors(Group src) {
        ArrayList<Actor> result = new ArrayList<Actor>();
        result.add(src);
        for (Actor child : src.getChildren()) {
            if (child instanceof Group) {
                result.addAll(TannStageUtils.getAllActors((Group)child));
                continue;
            }
            result.add(child);
        }
        return result;
    }

    public static boolean hasActor(Group cp, Class textMarqueeClass) {
        for (Actor child : cp.getChildren()) {
            if (textMarqueeClass == child.getClass()) {
                return true;
            }
            if (!(child instanceof Group) || !TannStageUtils.hasActor((Group)child, textMarqueeClass)) continue;
            return true;
        }
        return false;
    }

    public static void putBehindAlwaysOnTop(Actor a) {
        Group g = a.getParent();
        if (g == null) {
            return;
        }
        for (Actor child : g.getChildren()) {
            if (!"alwaysontop".equalsIgnoreCase(child.getName())) continue;
            a.setZIndex(child.getZIndex());
            return;
        }
    }

    public static void drawDebug(Stage stage) {
        Batch b = stage.getBatch();
        b.begin();
        TannStageUtils.drawDebug(b, stage.getRoot(), 0, 0);
        b.end();
    }

    private static void drawDebug(Batch b, Group g, int x, int y) {
        TannStageUtils.drawDebugSingle(b, g, x, y);
        for (Actor a : g.getChildren()) {
            if (a instanceof Group) {
                TannStageUtils.drawDebug(b, (Group)a, x + (int)g.getX(), y + (int)g.getY());
                continue;
            }
            TannStageUtils.drawDebugSingle(b, a, x + (int)g.getX(), y + (int)g.getY());
        }
    }

    private static void drawDebugSingle(Batch b, Actor a, int x, int y) {
        int hash = a.getClass().getSimpleName().hashCode();
        Color c = Tann.getHashColour(hash);
        c.a = 0.3f;
        b.setColor(c);
        Draw.fillRectangle(b, (int)((float)x + a.getX()), (int)((float)y + a.getY()), a.getWidth(), a.getHeight());
    }

    public static void sortActorsBySizeBiggestFirst(List<Actor> musicianPanels) {
        Collections.sort(musicianPanels, new Comparator<Actor>(){

            @Override
            public int compare(Actor o1, Actor o2) {
                return (int)(o2.getWidth() * o2.getHeight() - o1.getWidth() * o1.getHeight());
            }
        });
    }

    public static void sortActorsBySizeHeightPerWidth(List<Actor> musicianPanels) {
        Collections.sort(musicianPanels, new Comparator<Actor>(){

            @Override
            public int compare(Actor o1, Actor o2) {
                float o1r = o1.getHeight() / o1.getWidth();
                float o2r = o2.getHeight() / o2.getWidth();
                return Float.compare(o1r, o2r);
            }
        });
    }

    public static void sortActorsBySizeForJukebox(List<Actor> musicianPanels, int contentWidth) {
        TannStageUtils.sortActorsBySizeForJukeboxTailored(musicianPanels, contentWidth);
    }

    private static void sortActorsBySizeForJukeboxTailored(List<Actor> musicianPanels, final int contentWidth) {
        Collections.sort(musicianPanels, new Comparator<Actor>(){

            @Override
            public int compare(Actor o1, Actor o2) {
                int tinyThresh = 30;
                int r = Boolean.compare(o2.getHeight() < (float)tinyThresh, o1.getHeight() < (float)tinyThresh);
                if (r != 0) {
                    return r;
                }
                float hd = -20.0f;
                float o1r = (o1.getHeight() + hd) / o1.getWidth();
                float o2r = (o2.getHeight() + hd) / o2.getWidth();
                float lim = contentWidth / 2 - 2;
                if (o1.getWidth() > lim) {
                    o1r -= 5000.0f;
                }
                if (o2.getWidth() > lim) {
                    o2r -= 5000.0f;
                }
                return Float.compare(o1r, o2r);
            }
        });
    }

    public static void sortActorsBySizeTallestFirst(List<Actor> musicianPanels) {
        Collections.sort(musicianPanels, new Comparator<Actor>(){

            @Override
            public int compare(Actor o1, Actor o2) {
                return (int)(o2.getHeight() - o1.getHeight());
            }
        });
    }

    public static void removeCopyButton(Group g) {
        for (Actor actor : TannStageUtils.getActorsWithName("copy", g)) {
            g.removeActor(actor);
        }
    }

    public static Actor noListener(Actor actor) {
        actor.clearListeners();
        return actor;
    }

    public static boolean isMouseHeld() {
        return Gdx.input.isTouched();
    }

    public static void ensureSafeForScrollpane(Actor a) {
        if (a instanceof Group) {
            for (Actor child : ((Group)a).getChildren()) {
                TannStageUtils.ensureSafeForScrollpane(child);
            }
        }
        if (a instanceof DiePanel) {
            ((DiePanel)a).withoutDice();
        }
    }

    private static void actorFrontOfScreenSomehow(Actor a) {
        if (!Main.self().control.usesMouse()) {
            return;
        }
        if (a instanceof Group) {
            for (Actor child : ((Group)a).getChildren()) {
                TannStageUtils.actorFrontOfScreenSomehow(child);
            }
        }
        if (a instanceof ScrollPane) {
            Main.stage.setScrollFocus(a);
        }
    }

    public static void actorJustPushed(Actor a) {
        TannStageUtils.actorFrontOfScreenSomehow(a);
    }

    public static void actorSurfacedFromOtherPopping(Actor a) {
        TannStageUtils.actorFrontOfScreenSomehow(a);
    }
}

