/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.util.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.tann.dice.Main;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Draw;

public class Glowverlay
extends Actor {
    final Color color;
    private static final float amp = 0.2f;

    public Glowverlay(Color color) {
        this.setTouchable(Touchable.disabled);
        this.color = color;
    }

    public Glowverlay() {
        this(Colours.yellow);
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
        Group parent = this.getParent();
        Glowverlay.drawGlow(batch, this.getX(), this.getY(), parent.getWidth(), parent.getHeight(), this.color);
    }

    public static void drawGlow(Batch batch, Actor a, Color color) {
        Glowverlay.drawGlow(batch, a.getX(), a.getY(), a.getWidth(), a.getHeight(), color);
    }

    public static void drawGlow(Batch batch, float x, float y, float w, float h, Color color) {
        int maxDist = (int)Math.pow((w + h) / 2.0f, 0.35);
        for (int dist = 0; dist < maxDist; ++dist) {
            float alpha = (float)(maxDist - dist) / (float)maxDist;
            float bonus = Main.pulsateFactor() * 0.2f;
            batch.setColor(Colours.withAlpha(color, alpha += bonus));
            for (int i = 0; i < 4; ++i) {
                int startX = i != 3 ? 0 : (int)w - 1;
                int startY = i != 1 ? 0 : (int)h - 1;
                int width = i < 2 ? (int)w : 1;
                int height = i >= 2 ? (int)h : 1;
                switch (i) {
                    case 0: {
                        startX += dist;
                        width -= dist * 2;
                        startY -= dist;
                        break;
                    }
                    case 1: {
                        startX += dist;
                        width -= dist * 2;
                        startY += dist;
                        break;
                    }
                    case 2: {
                        startY += dist;
                        height -= dist * 2;
                        startX -= dist;
                        break;
                    }
                    case 3: {
                        startY += dist;
                        height -= dist * 2;
                        startX += dist;
                    }
                }
                Draw.fillRectangle(batch, (float)startX + x, (float)startY + y, width, height);
            }
        }
    }
}

