/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management.internal;

import com.ibm.lang.management.JvmCpuMonitorInfo;
import com.ibm.lang.management.JvmCpuMonitorMXBean;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class JvmCpuMonitor
implements JvmCpuMonitorMXBean {
    private static JvmCpuMonitor instance = new JvmCpuMonitor();

    public static JvmCpuMonitor getInstance() {
        return instance;
    }

    @Override
    public ObjectName getObjectName() {
        try {
            ObjectName objectName = new ObjectName("com.ibm.lang.management:type=JvmCpuMonitor");
            return objectName;
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            return null;
        }
    }

    @Override
    public JvmCpuMonitorInfo getThreadsCpuUsage(JvmCpuMonitorInfo jvmCpuMonitorInfo) {
        if (null == jvmCpuMonitorInfo) {
            throw new NullPointerException();
        }
        return this.getThreadsCpuUsageImpl(jvmCpuMonitorInfo);
    }

    @Override
    public JvmCpuMonitorInfo getThreadsCpuUsage() {
        JvmCpuMonitorInfo jvmCpuMonitorInfo = new JvmCpuMonitorInfo();
        return this.getThreadsCpuUsageImpl(jvmCpuMonitorInfo);
    }

    @Override
    public int setThreadCategory(long l, String string) {
        if (l <= 0L) {
            throw new IllegalArgumentException();
        }
        Category category = Category.fromString(string);
        switch (category) {
            case THREAD_CATEGORY_RESOURCE_MONITOR: 
            case THREAD_CATEGORY_APPLICATION: 
            case THREAD_CATEGORY_APPLICATION_USER1: 
            case THREAD_CATEGORY_APPLICATION_USER2: 
            case THREAD_CATEGORY_APPLICATION_USER3: 
            case THREAD_CATEGORY_APPLICATION_USER4: 
            case THREAD_CATEGORY_APPLICATION_USER5: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return this.setThreadCategoryImpl(l, category.categoryValue());
    }

    @Override
    public String getThreadCategory(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException();
        }
        int n = this.getThreadCategoryImpl(l);
        Category category = Category.fromInt(n);
        return category.categoryName();
    }

    private native JvmCpuMonitorInfo getThreadsCpuUsageImpl(JvmCpuMonitorInfo var1);

    private native int setThreadCategoryImpl(long var1, int var3);

    private native int getThreadCategoryImpl(long var1);

    private static enum Category {
        THREAD_CATEGORY_INVALID(-1, "Invalid"),
        THREAD_CATEGORY_UNKNOWN(0, "UnKnown"),
        THREAD_CATEGORY_SYSTEM_JVM(1, "System-JVM"),
        THREAD_CATEGORY_GC(2, "GC"),
        THREAD_CATEGORY_JIT(3, "JIT"),
        THREAD_CATEGORY_RESOURCE_MONITOR(10, "Resource-Monitor"),
        THREAD_CATEGORY_APPLICATION(100, "Application"),
        THREAD_CATEGORY_APPLICATION_USER1(101, "Application-User1"),
        THREAD_CATEGORY_APPLICATION_USER2(102, "Application-User2"),
        THREAD_CATEGORY_APPLICATION_USER3(103, "Application-User3"),
        THREAD_CATEGORY_APPLICATION_USER4(104, "Application-User4"),
        THREAD_CATEGORY_APPLICATION_USER5(105, "Application-User5");

        private final int catValue;
        private final String catName;

        private Category(int n2, String string2) {
            this.catValue = n2;
            this.catName = string2;
        }

        public int categoryValue() {
            return this.catValue;
        }

        public String categoryName() {
            return this.catName;
        }

        public static Category fromInt(int n) {
            switch (n) {
                case 0: {
                    return THREAD_CATEGORY_UNKNOWN;
                }
                case 1: {
                    return THREAD_CATEGORY_SYSTEM_JVM;
                }
                case 2: {
                    return THREAD_CATEGORY_GC;
                }
                case 3: {
                    return THREAD_CATEGORY_JIT;
                }
                case 10: {
                    return THREAD_CATEGORY_RESOURCE_MONITOR;
                }
                case 100: {
                    return THREAD_CATEGORY_APPLICATION;
                }
                case 101: {
                    return THREAD_CATEGORY_APPLICATION_USER1;
                }
                case 102: {
                    return THREAD_CATEGORY_APPLICATION_USER2;
                }
                case 103: {
                    return THREAD_CATEGORY_APPLICATION_USER3;
                }
                case 104: {
                    return THREAD_CATEGORY_APPLICATION_USER4;
                }
                case 105: {
                    return THREAD_CATEGORY_APPLICATION_USER5;
                }
            }
            return THREAD_CATEGORY_INVALID;
        }

        public static Category fromString(String string) {
            if (string != null) {
                for (Category category : Category.values()) {
                    if (!string.equalsIgnoreCase(category.catName)) continue;
                    return category;
                }
            }
            return THREAD_CATEGORY_INVALID;
        }
    }
}

