/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management.internal;

import com.ibm.java.lang.management.internal.ManagementUtils;
import com.ibm.oti.util.Msg;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.function.Predicate;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServerConnection;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;

public final class OpenTypeMappingIHandler
implements InvocationHandler {
    private final MBeanServerConnection connection;
    private final MBeanInfo info;
    private final ObjectName mxBeanObjectName;

    private static String[] getOperationSignature(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        String[] stringArray = new String[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            stringArray[i] = classArray[i].getName();
        }
        return stringArray;
    }

    public OpenTypeMappingIHandler(MBeanServerConnection mBeanServerConnection, Class<?> clazz, ObjectName objectName) throws IOException {
        this.connection = mBeanServerConnection;
        this.mxBeanObjectName = objectName;
        this.checkBeanIsRegistered();
        try {
            this.info = mBeanServerConnection.getMBeanInfo(objectName);
        }
        catch (InstanceNotFoundException | IntrospectionException | ReflectionException jMException) {
            throw new IllegalArgumentException(jMException);
        }
    }

    private void checkBeanIsRegistered() throws IOException {
        if (!this.connection.isRegistered(this.mxBeanObjectName)) {
            throw new IllegalArgumentException(Msg.getString("K05F4", this.mxBeanObjectName));
        }
    }

    private MBeanAttributeInfo getAttribInfo(String string) {
        block3: {
            MBeanAttributeInfo[] mBeanAttributeInfoArray;
            block2: {
                mBeanAttributeInfoArray = this.info.getAttributes();
                if (!string.startsWith("get")) break block2;
                String string2 = string.substring("get".length());
                for (MBeanAttributeInfo mBeanAttributeInfo : mBeanAttributeInfoArray) {
                    if (!string2.equals(mBeanAttributeInfo.getName()) || !mBeanAttributeInfo.isReadable()) continue;
                    return mBeanAttributeInfo;
                }
                break block3;
            }
            if (!string.startsWith("is")) break block3;
            String string3 = string.substring("is".length());
            for (MBeanAttributeInfo mBeanAttributeInfo : mBeanAttributeInfoArray) {
                if (!string3.equals(mBeanAttributeInfo.getName()) || !mBeanAttributeInfo.isReadable() || !mBeanAttributeInfo.isIs()) continue;
                return mBeanAttributeInfo;
            }
        }
        return null;
    }

    private String getAttribName(Method method) {
        MBeanAttributeInfo[] mBeanAttributeInfoArray;
        Predicate<MBeanAttributeInfo> predicate;
        String string;
        String string2 = method.getName();
        if (string2.startsWith("get")) {
            string = string2.substring("get".length());
            predicate = mBeanAttributeInfo -> mBeanAttributeInfo.isReadable();
        } else if (string2.startsWith("is")) {
            string = string2.substring("is".length());
            predicate = mBeanAttributeInfo -> mBeanAttributeInfo.isReadable() && mBeanAttributeInfo.isIs();
        } else if (string2.startsWith("set")) {
            string = string2.substring("set".length());
            predicate = mBeanAttributeInfo -> mBeanAttributeInfo.isWritable();
        } else {
            return null;
        }
        for (MBeanAttributeInfo mBeanAttributeInfo2 : mBeanAttributeInfoArray = this.info.getAttributes()) {
            if (!string.equals(mBeanAttributeInfo2.getName()) || !predicate.test(mBeanAttributeInfo2)) continue;
            return string;
        }
        return null;
    }

    private String getAttrOpenType(String string) {
        MBeanAttributeInfo mBeanAttributeInfo = this.getAttribInfo(string);
        return mBeanAttributeInfo.getType();
    }

    private InvokeType getInvokeType(String string) {
        Object object;
        int n;
        int n2;
        Object[] objectArray;
        Object[] objectArray2;
        Object object2;
        if (string.startsWith("get")) {
            object2 = string.substring("get".length());
            objectArray2 = this.info.getAttributes();
            objectArray = objectArray2;
            n2 = objectArray.length;
            for (n = 0; n < n2; ++n) {
                object = objectArray[n];
                if (!((String)object2).equals(((MBeanFeatureInfo)object).getName()) || !((MBeanAttributeInfo)object).isReadable()) continue;
                return InvokeType.ATTRIBUTE_GETTER;
            }
        } else if (string.startsWith("is")) {
            object2 = string.substring("is".length());
            objectArray2 = this.info.getAttributes();
            objectArray = objectArray2;
            n2 = objectArray.length;
            for (n = 0; n < n2; ++n) {
                object = objectArray[n];
                if (!((String)object2).equals(((MBeanFeatureInfo)object).getName()) || !((MBeanAttributeInfo)object).isReadable() || !((MBeanAttributeInfo)object).isIs()) continue;
                return InvokeType.ATTRIBUTE_GETTER;
            }
        } else if (string.startsWith("set")) {
            object2 = string.substring("set".length());
            objectArray2 = this.info.getAttributes();
            objectArray = objectArray2;
            n2 = objectArray.length;
            for (n = 0; n < n2; ++n) {
                object = objectArray[n];
                if (!((String)object2).equals(((MBeanFeatureInfo)object).getName()) || !((MBeanAttributeInfo)object).isWritable()) continue;
                return InvokeType.ATTRIBUTE_SETTER;
            }
        }
        object2 = NotificationEmitter.class.getMethods();
        for (Object object3 : object2) {
            if (!string.equals(((Method)object3).getName())) continue;
            return InvokeType.NOTIFICATION_OP;
        }
        return InvokeType.OPERATION;
    }

    private String getOperationOpenReturnType(Method method) {
        MBeanOperationInfo[] mBeanOperationInfoArray;
        String string = method.getName();
        String[] stringArray = OpenTypeMappingIHandler.getOperationSignature(method);
        block0: for (MBeanOperationInfo mBeanOperationInfo : mBeanOperationInfoArray = this.info.getOperations()) {
            MBeanParameterInfo[] mBeanParameterInfoArray;
            if (!string.equals(mBeanOperationInfo.getName()) || (mBeanParameterInfoArray = mBeanOperationInfo.getSignature()).length != stringArray.length) continue;
            for (int i = 0; i < mBeanParameterInfoArray.length; ++i) {
                if (!stringArray[i].equals(mBeanParameterInfoArray[i].getType())) continue block0;
            }
            return mBeanOperationInfo.getReturnType();
        }
        return null;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        Object object2 = null;
        String string = method.getName();
        switch (this.getInvokeType(string)) {
            case ATTRIBUTE_GETTER: {
                object2 = this.invokeAttributeGetter(method);
                break;
            }
            case ATTRIBUTE_SETTER: {
                object2 = this.invokeAttributeSetter(method, objectArray);
                break;
            }
            case NOTIFICATION_OP: {
                object2 = this.invokeNotificationEmitterOperation(method, objectArray);
                break;
            }
            default: {
                object2 = "toString".equals(string) && (objectArray == null || objectArray.length == 0) ? "MXBeanProxy(" + this.connection + "[" + this.mxBeanObjectName + "])" : ("getObjectName".equals(string) && (objectArray == null || objectArray.length == 0) ? this.mxBeanObjectName : this.invokeOperation(method, objectArray));
            }
        }
        return object2;
    }

    private Object invokeAttributeGetter(Method method) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, SecurityException, IllegalArgumentException, NoSuchMethodException, InvocationTargetException {
        Object object = null;
        String string = method.getReturnType().getName();
        String string2 = this.getAttrOpenType(method.getName());
        PrivilegedExceptionAction<Object> privilegedExceptionAction = () -> this.connection.getAttribute(this.mxBeanObjectName, this.getAttribName(method));
        try {
            object = AccessController.doPrivileged(privilegedExceptionAction);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Throwable throwable = privilegedActionException.getCause();
            if (throwable instanceof AttributeNotFoundException) {
                throw (AttributeNotFoundException)throwable;
            }
            if (throwable instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)throwable;
            }
            if (throwable instanceof MBeanException) {
                throw (MBeanException)throwable;
            }
            if (throwable instanceof ReflectionException) {
                throw (ReflectionException)throwable;
            }
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw new RuntimeException(throwable);
        }
        catch (RuntimeMBeanException runtimeMBeanException) {
            throw runtimeMBeanException.getTargetException();
        }
        if (!string.equals(string2)) {
            object = ManagementUtils.convertFromOpenType(object, Class.forName(string2), Class.forName(string));
        }
        return object;
    }

    private Object invokeAttributeSetter(Method method, Object[] objectArray) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException, InvalidAttributeValueException {
        PrivilegedExceptionAction<Void> privilegedExceptionAction = () -> {
            this.connection.setAttribute(this.mxBeanObjectName, new Attribute(this.getAttribName(method), objectArray[0]));
            return null;
        };
        try {
            AccessController.doPrivileged(privilegedExceptionAction);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Throwable throwable = privilegedActionException.getCause();
            if (throwable instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)throwable;
            }
            if (throwable instanceof AttributeNotFoundException) {
                throw (AttributeNotFoundException)throwable;
            }
            if (throwable instanceof InvalidAttributeValueException) {
                throw (InvalidAttributeValueException)throwable;
            }
            if (throwable instanceof MBeanException) {
                throw (MBeanException)throwable;
            }
            if (throwable instanceof ReflectionException) {
                throw (ReflectionException)throwable;
            }
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw new RuntimeException(throwable);
        }
        catch (RuntimeMBeanException runtimeMBeanException) {
            throw runtimeMBeanException.getTargetException();
        }
        return null;
    }

    private Object invokeNotificationEmitterOperation(Method method, Object[] objectArray) throws InstanceNotFoundException, IOException, ListenerNotFoundException {
        String string = method.getName();
        MBeanNotificationInfo[] mBeanNotificationInfoArray = null;
        if ("addNotificationListener".equals(string)) {
            PrivilegedExceptionAction<Void> privilegedExceptionAction = () -> {
                this.connection.addNotificationListener(this.mxBeanObjectName, (NotificationListener)objectArray[0], (NotificationFilter)objectArray[1], objectArray[2]);
                return null;
            };
            try {
                AccessController.doPrivileged(privilegedExceptionAction);
            }
            catch (PrivilegedActionException privilegedActionException) {
                Throwable throwable = privilegedActionException.getCause();
                if (throwable instanceof InstanceNotFoundException) {
                    throw (InstanceNotFoundException)throwable;
                }
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                throw new RuntimeException(throwable);
            }
            catch (RuntimeMBeanException runtimeMBeanException) {
                throw runtimeMBeanException.getTargetException();
            }
        }
        if ("getNotificationInfo".equals(string)) {
            mBeanNotificationInfoArray = this.info.getNotifications();
        } else if ("removeNotificationListener".equals(string)) {
            if (objectArray.length == 1) {
                PrivilegedExceptionAction<Void> privilegedExceptionAction = () -> {
                    this.connection.removeNotificationListener(this.mxBeanObjectName, (NotificationListener)objectArray[0]);
                    return null;
                };
                try {
                    AccessController.doPrivileged(privilegedExceptionAction);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Throwable throwable = privilegedActionException.getCause();
                    if (throwable instanceof InstanceNotFoundException) {
                        throw (InstanceNotFoundException)throwable;
                    }
                    if (throwable instanceof ListenerNotFoundException) {
                        throw (ListenerNotFoundException)throwable;
                    }
                    if (throwable instanceof IOException) {
                        throw (IOException)throwable;
                    }
                    throw new RuntimeException(throwable);
                }
                catch (RuntimeMBeanException runtimeMBeanException) {
                    throw runtimeMBeanException.getTargetException();
                }
            }
            PrivilegedExceptionAction<Void> privilegedExceptionAction = () -> {
                this.connection.removeNotificationListener(this.mxBeanObjectName, (NotificationListener)objectArray[0], (NotificationFilter)objectArray[1], objectArray[2]);
                return null;
            };
            try {
                AccessController.doPrivileged(privilegedExceptionAction);
            }
            catch (PrivilegedActionException privilegedActionException) {
                Throwable throwable = privilegedActionException.getCause();
                if (throwable instanceof InstanceNotFoundException) {
                    throw (InstanceNotFoundException)throwable;
                }
                if (throwable instanceof ListenerNotFoundException) {
                    throw (ListenerNotFoundException)throwable;
                }
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                throw new RuntimeException(throwable);
            }
            catch (RuntimeMBeanException runtimeMBeanException) {
                throw runtimeMBeanException.getTargetException();
            }
        }
        return mBeanNotificationInfoArray;
    }

    private Object invokeOperation(Method method, Object[] objectArray) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, SecurityException, IllegalArgumentException, NoSuchMethodException, InvocationTargetException {
        PrivilegedExceptionAction<Object> privilegedExceptionAction = () -> this.connection.invoke(this.mxBeanObjectName, method.getName(), objectArray, OpenTypeMappingIHandler.getOperationSignature(method));
        Object object = null;
        try {
            object = AccessController.doPrivileged(privilegedExceptionAction);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Throwable throwable = privilegedActionException.getCause();
            if (throwable instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)throwable;
            }
            if (throwable instanceof MBeanException) {
                throw (MBeanException)throwable;
            }
            if (throwable instanceof ReflectionException) {
                throw (ReflectionException)throwable;
            }
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw new RuntimeException(throwable);
        }
        catch (RuntimeMBeanException runtimeMBeanException) {
            throw runtimeMBeanException.getTargetException();
        }
        String string = method.getReturnType().getName();
        String string2 = this.getOperationOpenReturnType(method);
        if (!string.equals(string2)) {
            object = ManagementUtils.convertFromOpenType(object, Class.forName(string2), Class.forName(string));
        }
        return object;
    }

    private static enum InvokeType {
        ATTRIBUTE_GETTER,
        ATTRIBUTE_SETTER,
        NOTIFICATION_OP,
        OPERATION;

    }
}

