/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.security;

import com.sun.jmx.mbeanserver.GetPropertyAction;
import com.sun.jmx.mbeanserver.Util;
import com.sun.jmx.remote.util.ClassLogger;
import com.sun.jmx.remote.util.EnvHelp;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import javax.management.remote.JMXPrincipal;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class FileLoginModule
implements LoginModule {
    private static final String DEFAULT_PASSWORD_FILE_NAME = AccessController.doPrivileged(new GetPropertyAction("java.home")) + File.separatorChar + "lib" + File.separatorChar + "management" + File.separatorChar + "jmxremote.password";
    private static final String USERNAME_KEY = "javax.security.auth.login.name";
    private static final String PASSWORD_KEY = "javax.security.auth.login.password";
    private static final ClassLogger logger = new ClassLogger("javax.management.remote.misc", "FileLoginModule");
    private boolean useFirstPass = false;
    private boolean tryFirstPass = false;
    private boolean storePass = false;
    private boolean clearPass = false;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private String username;
    private char[] password;
    private JMXPrincipal user;
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map<String, Object> sharedState;
    private Map<String, ?> options;
    private String passwordFile;
    private String passwordFileDisplayName;
    private boolean userSuppliedPasswordFile;
    private boolean hasJavaHomePermission;
    private Properties userCredentials;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> map, Map<String, ?> map2) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = (Map)Util.cast(map);
        this.options = map2;
        this.tryFirstPass = "true".equalsIgnoreCase((String)map2.get("tryFirstPass"));
        this.useFirstPass = "true".equalsIgnoreCase((String)map2.get("useFirstPass"));
        this.storePass = "true".equalsIgnoreCase((String)map2.get("storePass"));
        this.clearPass = "true".equalsIgnoreCase((String)map2.get("clearPass"));
        this.passwordFileDisplayName = this.passwordFile = (String)map2.get("passwordFile");
        this.userSuppliedPasswordFile = true;
        if (this.passwordFile == null) {
            this.passwordFile = DEFAULT_PASSWORD_FILE_NAME;
            this.userSuppliedPasswordFile = false;
            try {
                System.getProperty("java.home");
                this.hasJavaHomePermission = true;
                this.passwordFileDisplayName = this.passwordFile;
            }
            catch (SecurityException securityException) {
                this.hasJavaHomePermission = false;
                this.passwordFileDisplayName = "jmxremote.password";
            }
        }
    }

    @Override
    public boolean login() throws LoginException {
        try {
            this.loadPasswordFile();
        }
        catch (IOException iOException) {
            LoginException loginException = new LoginException("Error: unable to load the password file: " + this.passwordFileDisplayName);
            throw EnvHelp.initCause(loginException, iOException);
        }
        if (this.userCredentials == null) {
            throw new LoginException("Error: unable to locate the users' credentials.");
        }
        if (logger.debugOn()) {
            logger.debug("login", "Using password file: " + this.passwordFileDisplayName);
        }
        if (this.tryFirstPass) {
            try {
                this.attemptAuthentication(true);
                this.succeeded = true;
                if (logger.debugOn()) {
                    logger.debug("login", "Authentication using cached password has succeeded");
                }
                return true;
            }
            catch (LoginException loginException) {
                this.cleanState();
                logger.debug("login", "Authentication using cached password has failed");
            }
        } else if (this.useFirstPass) {
            try {
                this.attemptAuthentication(true);
                this.succeeded = true;
                if (logger.debugOn()) {
                    logger.debug("login", "Authentication using cached password has succeeded");
                }
                return true;
            }
            catch (LoginException loginException) {
                this.cleanState();
                logger.debug("login", "Authentication using cached password has failed");
                throw loginException;
            }
        }
        if (logger.debugOn()) {
            logger.debug("login", "Acquiring password");
        }
        try {
            this.attemptAuthentication(false);
            this.succeeded = true;
            if (logger.debugOn()) {
                logger.debug("login", "Authentication has succeeded");
            }
            return true;
        }
        catch (LoginException loginException) {
            this.cleanState();
            logger.debug("login", "Authentication has failed");
            throw loginException;
        }
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.subject.isReadOnly()) {
            this.cleanState();
            throw new LoginException("Subject is read-only");
        }
        if (!this.subject.getPrincipals().contains(this.user)) {
            this.subject.getPrincipals().add(this.user);
        }
        if (logger.debugOn()) {
            logger.debug("commit", "Authentication has completed successfully");
        }
        this.cleanState();
        this.commitSucceeded = true;
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (logger.debugOn()) {
            logger.debug("abort", "Authentication has not completed successfully");
        }
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.succeeded = false;
            this.cleanState();
            this.user = null;
        } else {
            this.logout();
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        if (this.subject.isReadOnly()) {
            this.cleanState();
            throw new LoginException("Subject is read-only");
        }
        this.subject.getPrincipals().remove(this.user);
        this.cleanState();
        this.succeeded = false;
        this.commitSucceeded = false;
        this.user = null;
        if (logger.debugOn()) {
            logger.debug("logout", "Subject is being logged out");
        }
        return true;
    }

    private void attemptAuthentication(boolean bl) throws LoginException {
        this.getUsernamePassword(bl);
        String string = this.userCredentials.getProperty(this.username);
        if (string == null || !string.equals(new String(this.password))) {
            if (logger.debugOn()) {
                logger.debug("login", "Invalid username or password");
            }
            throw new FailedLoginException("Invalid username or password");
        }
        if (this.storePass && !this.sharedState.containsKey(USERNAME_KEY) && !this.sharedState.containsKey(PASSWORD_KEY)) {
            this.sharedState.put(USERNAME_KEY, this.username);
            this.sharedState.put(PASSWORD_KEY, this.password);
        }
        this.user = new JMXPrincipal(this.username);
        if (logger.debugOn()) {
            logger.debug("login", "User '" + this.username + "' successfully validated");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPasswordFile() throws IOException {
        FileInputStream fileInputStream;
        try {
            fileInputStream = new FileInputStream(this.passwordFile);
        }
        catch (SecurityException securityException) {
            if (this.userSuppliedPasswordFile || this.hasJavaHomePermission) {
                throw securityException;
            }
            FilePermission filePermission = new FilePermission(this.passwordFileDisplayName, "read");
            AccessControlException accessControlException = new AccessControlException("access denied " + filePermission.toString());
            accessControlException.setStackTrace(securityException.getStackTrace());
            throw accessControlException;
        }
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);){
            this.userCredentials = new Properties();
            this.userCredentials.load(bufferedInputStream);
        }
        finally {
            fileInputStream.close();
        }
    }

    private void getUsernamePassword(boolean bl) throws LoginException {
        if (bl) {
            this.username = (String)this.sharedState.get(USERNAME_KEY);
            this.password = (char[])this.sharedState.get(PASSWORD_KEY);
            return;
        }
        if (this.callbackHandler == null) {
            throw new LoginException("Error: no CallbackHandler available to garner authentication information from the user");
        }
        Callback[] callbackArray = new Callback[]{new NameCallback("username"), new PasswordCallback("password", false)};
        try {
            this.callbackHandler.handle(callbackArray);
            this.username = ((NameCallback)callbackArray[0]).getName();
            char[] cArray = ((PasswordCallback)callbackArray[1]).getPassword();
            this.password = new char[cArray.length];
            System.arraycopy((Object)cArray, 0, (Object)this.password, 0, cArray.length);
            ((PasswordCallback)callbackArray[1]).clearPassword();
        }
        catch (IOException iOException) {
            LoginException loginException = new LoginException(iOException.toString());
            throw EnvHelp.initCause(loginException, iOException);
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            LoginException loginException = new LoginException("Error: " + unsupportedCallbackException.getCallback().toString() + " not available to garner authentication information from the user");
            throw EnvHelp.initCause(loginException, unsupportedCallbackException);
        }
    }

    private void cleanState() {
        this.username = null;
        if (this.password != null) {
            Arrays.fill(this.password, ' ');
            this.password = null;
        }
        if (this.clearPass) {
            this.sharedState.remove(USERNAME_KEY);
            this.sharedState.remove(PASSWORD_KEY);
        }
    }
}

