/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayoutInfo;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Hashtable;

public class GridBagLayout
implements LayoutManager2,
Serializable {
    static final int EMPIRICMULTIPLIER = 2;
    protected static final int MAXGRIDSIZE = 512;
    protected static final int MINSIZE = 1;
    protected static final int PREFERREDSIZE = 2;
    protected Hashtable<Component, GridBagConstraints> comptable = new Hashtable();
    protected GridBagConstraints defaultConstraints = new GridBagConstraints();
    protected GridBagLayoutInfo layoutInfo;
    public int[] columnWidths;
    public int[] rowHeights;
    public double[] columnWeights;
    public double[] rowWeights;
    private Component componentAdjusting;
    transient boolean rightToLeft = false;
    static final long serialVersionUID = 8838754796412211005L;

    public void setConstraints(Component component, GridBagConstraints gridBagConstraints) {
        this.comptable.put(component, (GridBagConstraints)gridBagConstraints.clone());
    }

    public GridBagConstraints getConstraints(Component component) {
        GridBagConstraints gridBagConstraints = this.comptable.get(component);
        if (gridBagConstraints == null) {
            this.setConstraints(component, this.defaultConstraints);
            gridBagConstraints = this.comptable.get(component);
        }
        return (GridBagConstraints)gridBagConstraints.clone();
    }

    protected GridBagConstraints lookupConstraints(Component component) {
        GridBagConstraints gridBagConstraints = this.comptable.get(component);
        if (gridBagConstraints == null) {
            this.setConstraints(component, this.defaultConstraints);
            gridBagConstraints = this.comptable.get(component);
        }
        return gridBagConstraints;
    }

    private void removeConstraints(Component component) {
        this.comptable.remove(component);
    }

    public Point getLayoutOrigin() {
        Point point = new Point(0, 0);
        if (this.layoutInfo != null) {
            point.x = this.layoutInfo.startx;
            point.y = this.layoutInfo.starty;
        }
        return point;
    }

    public int[][] getLayoutDimensions() {
        if (this.layoutInfo == null) {
            return new int[2][0];
        }
        int[][] nArrayArray = new int[][]{new int[this.layoutInfo.width], new int[this.layoutInfo.height]};
        System.arraycopy((Object)this.layoutInfo.minWidth, 0, (Object)nArrayArray[0], 0, this.layoutInfo.width);
        System.arraycopy((Object)this.layoutInfo.minHeight, 0, (Object)nArrayArray[1], 0, this.layoutInfo.height);
        return nArrayArray;
    }

    public double[][] getLayoutWeights() {
        if (this.layoutInfo == null) {
            return new double[2][0];
        }
        double[][] dArrayArray = new double[][]{new double[this.layoutInfo.width], new double[this.layoutInfo.height]};
        System.arraycopy((Object)this.layoutInfo.weightX, 0, (Object)dArrayArray[0], 0, this.layoutInfo.width);
        System.arraycopy((Object)this.layoutInfo.weightY, 0, (Object)dArrayArray[1], 0, this.layoutInfo.height);
        return dArrayArray;
    }

    public Point location(int n, int n2) {
        int n3;
        Point point = new Point(0, 0);
        if (this.layoutInfo == null) {
            return point;
        }
        int n4 = this.layoutInfo.startx;
        if (!this.rightToLeft) {
            for (n3 = 0; n3 < this.layoutInfo.width && (n4 += this.layoutInfo.minWidth[n3]) <= n; ++n3) {
            }
        } else {
            for (n3 = this.layoutInfo.width - 1; n3 >= 0 && n4 <= n; n4 += this.layoutInfo.minWidth[n3], --n3) {
            }
            ++n3;
        }
        point.x = n3;
        n4 = this.layoutInfo.starty;
        for (n3 = 0; n3 < this.layoutInfo.height && (n4 += this.layoutInfo.minHeight[n3]) <= n2; ++n3) {
        }
        point.y = n3;
        return point;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
        if (object instanceof GridBagConstraints) {
            this.setConstraints(component, (GridBagConstraints)object);
        } else if (object != null) {
            throw new IllegalArgumentException("cannot add to layout: constraints must be a GridBagConstraint");
        }
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this.removeConstraints(component);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        GridBagLayoutInfo gridBagLayoutInfo = this.getLayoutInfo(container, 2);
        return this.getMinSize(container, gridBagLayoutInfo);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        GridBagLayoutInfo gridBagLayoutInfo = this.getLayoutInfo(container, 1);
        return this.getMinSize(container, gridBagLayoutInfo);
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container container) {
    }

    @Override
    public void layoutContainer(Container container) {
        this.arrangeGrid(container);
    }

    public String toString() {
        return this.getClass().getName();
    }

    protected GridBagLayoutInfo getLayoutInfo(Container container, int n) {
        return this.GetLayoutInfo(container, n);
    }

    private long[] preInitMaximumArraySizes(Container container) {
        Component[] componentArray = container.getComponents();
        int n = 0;
        int n2 = 0;
        long[] lArray = new long[2];
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            if (!component.isVisible()) continue;
            GridBagConstraints gridBagConstraints = this.lookupConstraints(component);
            int n3 = gridBagConstraints.gridx;
            int n4 = gridBagConstraints.gridy;
            int n5 = gridBagConstraints.gridwidth;
            int n6 = gridBagConstraints.gridheight;
            if (n3 < 0) {
                n3 = ++n2;
            }
            if (n4 < 0) {
                n4 = ++n;
            }
            if (n5 <= 0) {
                n5 = 1;
            }
            if (n6 <= 0) {
                n6 = 1;
            }
            n = Math.max(n4 + n6, n);
            n2 = Math.max(n3 + n5, n2);
        }
        lArray[0] = n;
        lArray[1] = n2;
        return lArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GridBagLayoutInfo GetLayoutInfo(Container container, int n) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n2;
            int n3;
            int n4;
            int n5;
            GridBagConstraints gridBagConstraints;
            Component component;
            int n6;
            Component[] componentArray = container.getComponents();
            int n7 = 0;
            int n8 = 0;
            int n9 = 1;
            int n10 = 1;
            int n11 = 0;
            int n12 = 0;
            int n13 = 0;
            int n14 = 0;
            int n15 = -1;
            int n16 = -1;
            long[] lArray = this.preInitMaximumArraySizes(container);
            n11 = 2L * lArray[0] > Integer.MAX_VALUE ? Integer.MAX_VALUE : 2 * (int)lArray[0];
            int n17 = n12 = 2L * lArray[1] > Integer.MAX_VALUE ? Integer.MAX_VALUE : 2 * (int)lArray[1];
            if (this.rowHeights != null) {
                n11 = Math.max(n11, this.rowHeights.length);
            }
            if (this.columnWidths != null) {
                n12 = Math.max(n12, this.columnWidths.length);
            }
            int[] nArray = new int[n11];
            int[] nArray2 = new int[n12];
            boolean bl = false;
            for (n6 = 0; n6 < componentArray.length; ++n6) {
                component = componentArray[n6];
                if (!component.isVisible()) continue;
                gridBagConstraints = this.lookupConstraints(component);
                n7 = gridBagConstraints.gridx;
                n8 = gridBagConstraints.gridy;
                n9 = gridBagConstraints.gridwidth;
                if (n9 <= 0) {
                    n9 = 1;
                }
                if ((n10 = gridBagConstraints.gridheight) <= 0) {
                    n10 = 1;
                }
                if (n7 < 0 && n8 < 0) {
                    if (n16 >= 0) {
                        n8 = n16;
                    } else if (n15 >= 0) {
                        n7 = n15;
                    } else {
                        n8 = 0;
                    }
                }
                if (n7 < 0) {
                    n5 = 0;
                    for (n4 = n8; n4 < n8 + n10; ++n4) {
                        n5 = Math.max(n5, nArray[n4]);
                    }
                    if ((n7 = n5 - n7 - 1) < 0) {
                        n7 = 0;
                    }
                } else if (n8 < 0) {
                    n3 = 0;
                    for (n4 = n7; n4 < n7 + n9; ++n4) {
                        n3 = Math.max(n3, nArray2[n4]);
                    }
                    if ((n8 = n3 - n8 - 1) < 0) {
                        n8 = 0;
                    }
                }
                if (n14 < (n5 = n7 + n9)) {
                    n14 = n5;
                }
                if (n13 < (n3 = n8 + n10)) {
                    n13 = n3;
                }
                for (n4 = n7; n4 < n7 + n9; ++n4) {
                    nArray2[n4] = n3;
                }
                for (n4 = n8; n4 < n8 + n10; ++n4) {
                    nArray[n4] = n5;
                }
                Dimension dimension = n == 2 ? component.getPreferredSize() : component.getMinimumSize();
                gridBagConstraints.minWidth = dimension.width;
                gridBagConstraints.minHeight = dimension.height;
                if (this.calculateBaseline(component, gridBagConstraints, dimension)) {
                    bl = true;
                }
                if (gridBagConstraints.gridheight == 0 && gridBagConstraints.gridwidth == 0) {
                    n15 = -1;
                    n16 = -1;
                }
                if (gridBagConstraints.gridheight == 0 && n16 < 0) {
                    n15 = n7 + n9;
                    continue;
                }
                if (gridBagConstraints.gridwidth != 0 || n15 >= 0) continue;
                n16 = n8 + n10;
            }
            if (this.columnWidths != null && n14 < this.columnWidths.length) {
                n14 = this.columnWidths.length;
            }
            if (this.rowHeights != null && n13 < this.rowHeights.length) {
                n13 = this.rowHeights.length;
            }
            GridBagLayoutInfo gridBagLayoutInfo = new GridBagLayoutInfo(n14, n13);
            n15 = -1;
            n16 = -1;
            Arrays.fill(nArray, 0);
            Arrays.fill(nArray2, 0);
            int[] nArray3 = null;
            int[] nArray4 = null;
            short[] sArray = null;
            if (bl) {
                nArray3 = new int[n13];
                gridBagLayoutInfo.maxAscent = nArray3;
                nArray4 = new int[n13];
                gridBagLayoutInfo.maxDescent = nArray4;
                sArray = new short[n13];
                gridBagLayoutInfo.baselineType = sArray;
                gridBagLayoutInfo.hasBaseline = true;
            }
            block18: for (n6 = 0; n6 < componentArray.length; ++n6) {
                component = componentArray[n6];
                if (!component.isVisible()) continue;
                gridBagConstraints = this.lookupConstraints(component);
                n7 = gridBagConstraints.gridx;
                n8 = gridBagConstraints.gridy;
                n9 = gridBagConstraints.gridwidth;
                n10 = gridBagConstraints.gridheight;
                if (n7 < 0 && n8 < 0) {
                    if (n16 >= 0) {
                        n8 = n16;
                    } else if (n15 >= 0) {
                        n7 = n15;
                    } else {
                        n8 = 0;
                    }
                }
                if (n7 < 0) {
                    if (n10 <= 0 && (n10 += gridBagLayoutInfo.height - n8) < 1) {
                        n10 = 1;
                    }
                    n5 = 0;
                    for (n4 = n8; n4 < n8 + n10; ++n4) {
                        n5 = Math.max(n5, nArray[n4]);
                    }
                    if ((n7 = n5 - n7 - 1) < 0) {
                        n7 = 0;
                    }
                } else if (n8 < 0) {
                    if (n9 <= 0 && (n9 += gridBagLayoutInfo.width - n7) < 1) {
                        n9 = 1;
                    }
                    n3 = 0;
                    for (n4 = n7; n4 < n7 + n9; ++n4) {
                        n3 = Math.max(n3, nArray2[n4]);
                    }
                    if ((n8 = n3 - n8 - 1) < 0) {
                        n8 = 0;
                    }
                }
                if (n9 <= 0 && (n9 += gridBagLayoutInfo.width - n7) < 1) {
                    n9 = 1;
                }
                if (n10 <= 0 && (n10 += gridBagLayoutInfo.height - n8) < 1) {
                    n10 = 1;
                }
                n5 = n7 + n9;
                n3 = n8 + n10;
                for (n4 = n7; n4 < n7 + n9; ++n4) {
                    nArray2[n4] = n3;
                }
                for (n4 = n8; n4 < n8 + n10; ++n4) {
                    nArray[n4] = n5;
                }
                if (gridBagConstraints.gridheight == 0 && gridBagConstraints.gridwidth == 0) {
                    n15 = -1;
                    n16 = -1;
                }
                if (gridBagConstraints.gridheight == 0 && n16 < 0) {
                    n15 = n7 + n9;
                } else if (gridBagConstraints.gridwidth == 0 && n15 < 0) {
                    n16 = n8 + n10;
                }
                gridBagConstraints.tempX = n7;
                gridBagConstraints.tempY = n8;
                gridBagConstraints.tempWidth = n9;
                gridBagConstraints.tempHeight = n10;
                int n18 = gridBagConstraints.anchor;
                if (!bl) continue;
                switch (n18) {
                    case 256: 
                    case 512: 
                    case 768: {
                        if (gridBagConstraints.ascent < 0) continue block18;
                        if (n10 == 1) {
                            nArray3[n8] = Math.max(nArray3[n8], gridBagConstraints.ascent);
                            nArray4[n8] = Math.max(nArray4[n8], gridBagConstraints.descent);
                        } else if (gridBagConstraints.baselineResizeBehavior == Component.BaselineResizeBehavior.CONSTANT_DESCENT) {
                            nArray4[n8 + n10 - 1] = Math.max(nArray4[n8 + n10 - 1], gridBagConstraints.descent);
                        } else {
                            nArray3[n8] = Math.max(nArray3[n8], gridBagConstraints.ascent);
                        }
                        if (gridBagConstraints.baselineResizeBehavior == Component.BaselineResizeBehavior.CONSTANT_DESCENT) {
                            int n19 = n8 + n10 - 1;
                            sArray[n19] = (short)(sArray[n19] | 1 << gridBagConstraints.baselineResizeBehavior.ordinal());
                            continue block18;
                        }
                        int n20 = n8;
                        sArray[n20] = (short)(sArray[n20] | 1 << gridBagConstraints.baselineResizeBehavior.ordinal());
                        continue block18;
                    }
                    case 1024: 
                    case 1280: 
                    case 1536: {
                        n2 = gridBagConstraints.minHeight + gridBagConstraints.insets.top + gridBagConstraints.ipady;
                        nArray3[n8] = Math.max(nArray3[n8], n2);
                        nArray4[n8] = Math.max(nArray4[n8], gridBagConstraints.insets.bottom);
                        continue block18;
                    }
                    case 1792: 
                    case 2048: 
                    case 2304: {
                        n2 = gridBagConstraints.minHeight + gridBagConstraints.insets.bottom + gridBagConstraints.ipady;
                        nArray4[n8] = Math.max(nArray4[n8], n2);
                        nArray3[n8] = Math.max(nArray3[n8], gridBagConstraints.insets.top);
                    }
                }
            }
            gridBagLayoutInfo.weightX = new double[n12];
            gridBagLayoutInfo.weightY = new double[n11];
            gridBagLayoutInfo.minWidth = new int[n12];
            gridBagLayoutInfo.minHeight = new int[n11];
            if (this.columnWidths != null) {
                System.arraycopy((Object)this.columnWidths, 0, (Object)gridBagLayoutInfo.minWidth, 0, this.columnWidths.length);
            }
            if (this.rowHeights != null) {
                System.arraycopy((Object)this.rowHeights, 0, (Object)gridBagLayoutInfo.minHeight, 0, this.rowHeights.length);
            }
            if (this.columnWeights != null) {
                System.arraycopy((Object)this.columnWeights, 0, (Object)gridBagLayoutInfo.weightX, 0, Math.min(gridBagLayoutInfo.weightX.length, this.columnWeights.length));
            }
            if (this.rowWeights != null) {
                System.arraycopy((Object)this.rowWeights, 0, (Object)gridBagLayoutInfo.weightY, 0, Math.min(gridBagLayoutInfo.weightY.length, this.rowWeights.length));
            }
            int n21 = Integer.MAX_VALUE;
            n4 = 1;
            while (n4 != Integer.MAX_VALUE) {
                for (n6 = 0; n6 < componentArray.length; ++n6) {
                    double d;
                    double d2;
                    int n22;
                    double d3;
                    component = componentArray[n6];
                    if (!component.isVisible()) continue;
                    gridBagConstraints = this.lookupConstraints(component);
                    if (gridBagConstraints.tempWidth == n4) {
                        n5 = gridBagConstraints.tempX + gridBagConstraints.tempWidth;
                        d3 = gridBagConstraints.weightx;
                        for (n22 = gridBagConstraints.tempX; n22 < n5; ++n22) {
                            d3 -= gridBagLayoutInfo.weightX[n22];
                        }
                        if (d3 > 0.0) {
                            d2 = 0.0;
                            for (n22 = gridBagConstraints.tempX; n22 < n5; ++n22) {
                                d2 += gridBagLayoutInfo.weightX[n22];
                            }
                            n22 = gridBagConstraints.tempX;
                            while (d2 > 0.0 && n22 < n5) {
                                d = gridBagLayoutInfo.weightX[n22];
                                double d4 = d * d3 / d2;
                                int n23 = n22++;
                                gridBagLayoutInfo.weightX[n23] = gridBagLayoutInfo.weightX[n23] + d4;
                                d3 -= d4;
                                d2 -= d;
                            }
                            int n24 = n5 - 1;
                            gridBagLayoutInfo.weightX[n24] = gridBagLayoutInfo.weightX[n24] + d3;
                        }
                        n2 = gridBagConstraints.minWidth + gridBagConstraints.ipadx + gridBagConstraints.insets.left + gridBagConstraints.insets.right;
                        for (n22 = gridBagConstraints.tempX; n22 < n5; ++n22) {
                            n2 -= gridBagLayoutInfo.minWidth[n22];
                        }
                        if (n2 > 0) {
                            d2 = 0.0;
                            for (n22 = gridBagConstraints.tempX; n22 < n5; ++n22) {
                                d2 += gridBagLayoutInfo.weightX[n22];
                            }
                            n22 = gridBagConstraints.tempX;
                            while (d2 > 0.0 && n22 < n5) {
                                d = gridBagLayoutInfo.weightX[n22];
                                int n25 = (int)(d * (double)n2 / d2);
                                int n26 = n22++;
                                gridBagLayoutInfo.minWidth[n26] = gridBagLayoutInfo.minWidth[n26] + n25;
                                n2 -= n25;
                                d2 -= d;
                            }
                            int n27 = n5 - 1;
                            gridBagLayoutInfo.minWidth[n27] = gridBagLayoutInfo.minWidth[n27] + n2;
                        }
                    } else if (gridBagConstraints.tempWidth > n4 && gridBagConstraints.tempWidth < n21) {
                        n21 = gridBagConstraints.tempWidth;
                    }
                    if (gridBagConstraints.tempHeight == n4) {
                        n3 = gridBagConstraints.tempY + gridBagConstraints.tempHeight;
                        d3 = gridBagConstraints.weighty;
                        for (n22 = gridBagConstraints.tempY; n22 < n3; ++n22) {
                            d3 -= gridBagLayoutInfo.weightY[n22];
                        }
                        if (d3 > 0.0) {
                            d2 = 0.0;
                            for (n22 = gridBagConstraints.tempY; n22 < n3; ++n22) {
                                d2 += gridBagLayoutInfo.weightY[n22];
                            }
                            n22 = gridBagConstraints.tempY;
                            while (d2 > 0.0 && n22 < n3) {
                                d = gridBagLayoutInfo.weightY[n22];
                                double d5 = d * d3 / d2;
                                int n28 = n22++;
                                gridBagLayoutInfo.weightY[n28] = gridBagLayoutInfo.weightY[n28] + d5;
                                d3 -= d5;
                                d2 -= d;
                            }
                            int n29 = n3 - 1;
                            gridBagLayoutInfo.weightY[n29] = gridBagLayoutInfo.weightY[n29] + d3;
                        }
                        n2 = -1;
                        if (bl) {
                            switch (gridBagConstraints.anchor) {
                                case 256: 
                                case 512: 
                                case 768: {
                                    if (gridBagConstraints.ascent < 0) break;
                                    if (gridBagConstraints.tempHeight == 1) {
                                        n2 = nArray3[gridBagConstraints.tempY] + nArray4[gridBagConstraints.tempY];
                                        break;
                                    }
                                    if (gridBagConstraints.baselineResizeBehavior != Component.BaselineResizeBehavior.CONSTANT_DESCENT) {
                                        n2 = nArray3[gridBagConstraints.tempY] + gridBagConstraints.descent;
                                        break;
                                    }
                                    n2 = gridBagConstraints.ascent + nArray4[gridBagConstraints.tempY + gridBagConstraints.tempHeight - 1];
                                    break;
                                }
                                case 1024: 
                                case 1280: 
                                case 1536: {
                                    n2 = gridBagConstraints.insets.top + gridBagConstraints.minHeight + gridBagConstraints.ipady + nArray4[gridBagConstraints.tempY];
                                    break;
                                }
                                case 1792: 
                                case 2048: 
                                case 2304: {
                                    n2 = nArray3[gridBagConstraints.tempY] + gridBagConstraints.minHeight + gridBagConstraints.insets.bottom + gridBagConstraints.ipady;
                                }
                            }
                        }
                        if (n2 == -1) {
                            n2 = gridBagConstraints.minHeight + gridBagConstraints.ipady + gridBagConstraints.insets.top + gridBagConstraints.insets.bottom;
                        }
                        for (n22 = gridBagConstraints.tempY; n22 < n3; ++n22) {
                            n2 -= gridBagLayoutInfo.minHeight[n22];
                        }
                        if (n2 <= 0) continue;
                        d2 = 0.0;
                        for (n22 = gridBagConstraints.tempY; n22 < n3; ++n22) {
                            d2 += gridBagLayoutInfo.weightY[n22];
                        }
                        n22 = gridBagConstraints.tempY;
                        while (d2 > 0.0 && n22 < n3) {
                            d = gridBagLayoutInfo.weightY[n22];
                            int n30 = (int)(d * (double)n2 / d2);
                            int n31 = n22++;
                            gridBagLayoutInfo.minHeight[n31] = gridBagLayoutInfo.minHeight[n31] + n30;
                            n2 -= n30;
                            d2 -= d;
                        }
                        int n32 = n3 - 1;
                        gridBagLayoutInfo.minHeight[n32] = gridBagLayoutInfo.minHeight[n32] + n2;
                        continue;
                    }
                    if (gridBagConstraints.tempHeight <= n4 || gridBagConstraints.tempHeight >= n21) continue;
                    n21 = gridBagConstraints.tempHeight;
                }
                n4 = n21;
                n21 = Integer.MAX_VALUE;
            }
            return gridBagLayoutInfo;
        }
    }

    private boolean calculateBaseline(Component component, GridBagConstraints gridBagConstraints, Dimension dimension) {
        int n = gridBagConstraints.anchor;
        if (n == 256 || n == 512 || n == 768) {
            int n2 = dimension.width + gridBagConstraints.ipadx;
            int n3 = dimension.height + gridBagConstraints.ipady;
            gridBagConstraints.ascent = component.getBaseline(n2, n3);
            if (gridBagConstraints.ascent >= 0) {
                int n4 = gridBagConstraints.ascent;
                gridBagConstraints.descent = n3 - gridBagConstraints.ascent + gridBagConstraints.insets.bottom;
                gridBagConstraints.ascent += gridBagConstraints.insets.top;
                gridBagConstraints.baselineResizeBehavior = component.getBaselineResizeBehavior();
                gridBagConstraints.centerPadding = 0;
                if (gridBagConstraints.baselineResizeBehavior == Component.BaselineResizeBehavior.CENTER_OFFSET) {
                    int n5 = component.getBaseline(n2, n3 + 1);
                    gridBagConstraints.centerOffset = n4 - n3 / 2;
                    if (n3 % 2 == 0) {
                        if (n4 != n5) {
                            gridBagConstraints.centerPadding = 1;
                        }
                    } else if (n4 == n5) {
                        --gridBagConstraints.centerOffset;
                        gridBagConstraints.centerPadding = 1;
                    }
                }
            }
            return true;
        }
        gridBagConstraints.ascent = -1;
        return false;
    }

    protected void adjustForGravity(GridBagConstraints gridBagConstraints, Rectangle rectangle) {
        this.AdjustForGravity(gridBagConstraints, rectangle);
    }

    protected void AdjustForGravity(GridBagConstraints gridBagConstraints, Rectangle rectangle) {
        int n = rectangle.y;
        int n2 = rectangle.height;
        rectangle.x = !this.rightToLeft ? (rectangle.x += gridBagConstraints.insets.left) : (rectangle.x -= rectangle.width - gridBagConstraints.insets.right);
        rectangle.width -= gridBagConstraints.insets.left + gridBagConstraints.insets.right;
        rectangle.y += gridBagConstraints.insets.top;
        rectangle.height -= gridBagConstraints.insets.top + gridBagConstraints.insets.bottom;
        int n3 = 0;
        if (gridBagConstraints.fill != 2 && gridBagConstraints.fill != 1 && rectangle.width > gridBagConstraints.minWidth + gridBagConstraints.ipadx) {
            n3 = rectangle.width - (gridBagConstraints.minWidth + gridBagConstraints.ipadx);
            rectangle.width = gridBagConstraints.minWidth + gridBagConstraints.ipadx;
        }
        int n4 = 0;
        if (gridBagConstraints.fill != 3 && gridBagConstraints.fill != 1 && rectangle.height > gridBagConstraints.minHeight + gridBagConstraints.ipady) {
            n4 = rectangle.height - (gridBagConstraints.minHeight + gridBagConstraints.ipady);
            rectangle.height = gridBagConstraints.minHeight + gridBagConstraints.ipady;
        }
        switch (gridBagConstraints.anchor) {
            case 256: {
                rectangle.x += n3 / 2;
                this.alignOnBaseline(gridBagConstraints, rectangle, n, n2);
                break;
            }
            case 512: {
                if (this.rightToLeft) {
                    rectangle.x += n3;
                }
                this.alignOnBaseline(gridBagConstraints, rectangle, n, n2);
                break;
            }
            case 768: {
                if (!this.rightToLeft) {
                    rectangle.x += n3;
                }
                this.alignOnBaseline(gridBagConstraints, rectangle, n, n2);
                break;
            }
            case 1024: {
                rectangle.x += n3 / 2;
                this.alignAboveBaseline(gridBagConstraints, rectangle, n, n2);
                break;
            }
            case 1280: {
                if (this.rightToLeft) {
                    rectangle.x += n3;
                }
                this.alignAboveBaseline(gridBagConstraints, rectangle, n, n2);
                break;
            }
            case 1536: {
                if (!this.rightToLeft) {
                    rectangle.x += n3;
                }
                this.alignAboveBaseline(gridBagConstraints, rectangle, n, n2);
                break;
            }
            case 1792: {
                rectangle.x += n3 / 2;
                this.alignBelowBaseline(gridBagConstraints, rectangle, n, n2);
                break;
            }
            case 2048: {
                if (this.rightToLeft) {
                    rectangle.x += n3;
                }
                this.alignBelowBaseline(gridBagConstraints, rectangle, n, n2);
                break;
            }
            case 2304: {
                if (!this.rightToLeft) {
                    rectangle.x += n3;
                }
                this.alignBelowBaseline(gridBagConstraints, rectangle, n, n2);
                break;
            }
            case 10: {
                rectangle.x += n3 / 2;
                rectangle.y += n4 / 2;
                break;
            }
            case 11: 
            case 19: {
                rectangle.x += n3 / 2;
                break;
            }
            case 12: {
                rectangle.x += n3;
                break;
            }
            case 13: {
                rectangle.x += n3;
                rectangle.y += n4 / 2;
                break;
            }
            case 14: {
                rectangle.x += n3;
                rectangle.y += n4;
                break;
            }
            case 15: 
            case 20: {
                rectangle.x += n3 / 2;
                rectangle.y += n4;
                break;
            }
            case 16: {
                rectangle.y += n4;
                break;
            }
            case 17: {
                rectangle.y += n4 / 2;
                break;
            }
            case 18: {
                break;
            }
            case 21: {
                if (this.rightToLeft) {
                    rectangle.x += n3;
                }
                rectangle.y += n4 / 2;
                break;
            }
            case 22: {
                if (!this.rightToLeft) {
                    rectangle.x += n3;
                }
                rectangle.y += n4 / 2;
                break;
            }
            case 23: {
                if (!this.rightToLeft) break;
                rectangle.x += n3;
                break;
            }
            case 24: {
                if (this.rightToLeft) break;
                rectangle.x += n3;
                break;
            }
            case 25: {
                if (this.rightToLeft) {
                    rectangle.x += n3;
                }
                rectangle.y += n4;
                break;
            }
            case 26: {
                if (!this.rightToLeft) {
                    rectangle.x += n3;
                }
                rectangle.y += n4;
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal anchor value");
            }
        }
    }

    private void alignOnBaseline(GridBagConstraints gridBagConstraints, Rectangle rectangle, int n, int n2) {
        if (gridBagConstraints.ascent >= 0) {
            if (gridBagConstraints.baselineResizeBehavior == Component.BaselineResizeBehavior.CONSTANT_DESCENT) {
                int n3 = n + n2 - this.layoutInfo.maxDescent[gridBagConstraints.tempY + gridBagConstraints.tempHeight - 1] + gridBagConstraints.descent - gridBagConstraints.insets.bottom;
                if (!gridBagConstraints.isVerticallyResizable()) {
                    rectangle.y = n3 - gridBagConstraints.minHeight;
                    rectangle.height = gridBagConstraints.minHeight;
                } else {
                    rectangle.height = n3 - n - gridBagConstraints.insets.top;
                }
            } else {
                int n4;
                int n5;
                int n6 = gridBagConstraints.ascent;
                int n7 = this.layoutInfo.hasConstantDescent(gridBagConstraints.tempY) ? n2 - this.layoutInfo.maxDescent[gridBagConstraints.tempY] : this.layoutInfo.maxAscent[gridBagConstraints.tempY];
                if (gridBagConstraints.baselineResizeBehavior == Component.BaselineResizeBehavior.OTHER) {
                    n5 = 0;
                    n6 = this.componentAdjusting.getBaseline(rectangle.width, rectangle.height);
                    if (n6 >= 0) {
                        n6 += gridBagConstraints.insets.top;
                    }
                    if (n6 >= 0 && n6 <= n7) {
                        if (n7 + (rectangle.height - n6 - gridBagConstraints.insets.top) <= n2 - gridBagConstraints.insets.bottom) {
                            n5 = 1;
                        } else if (gridBagConstraints.isVerticallyResizable()) {
                            n4 = this.componentAdjusting.getBaseline(rectangle.width, n2 - gridBagConstraints.insets.bottom - n7 + n6);
                            if (n4 >= 0) {
                                n4 += gridBagConstraints.insets.top;
                            }
                            if (n4 >= 0 && n4 <= n6) {
                                rectangle.height = n2 - gridBagConstraints.insets.bottom - n7 + n6;
                                n6 = n4;
                                n5 = 1;
                            }
                        }
                    }
                    if (n5 == 0) {
                        n6 = gridBagConstraints.ascent;
                        rectangle.width = gridBagConstraints.minWidth;
                        rectangle.height = gridBagConstraints.minHeight;
                    }
                }
                rectangle.y = n + n7 - n6 + gridBagConstraints.insets.top;
                if (gridBagConstraints.isVerticallyResizable()) {
                    switch (gridBagConstraints.baselineResizeBehavior) {
                        case CONSTANT_ASCENT: {
                            rectangle.height = Math.max(gridBagConstraints.minHeight, n + n2 - rectangle.y - gridBagConstraints.insets.bottom);
                            break;
                        }
                        case CENTER_OFFSET: {
                            n5 = rectangle.y - n - gridBagConstraints.insets.top;
                            n4 = n + n2 - rectangle.y - gridBagConstraints.minHeight - gridBagConstraints.insets.bottom;
                            int n8 = Math.min(n5, n4);
                            n8 += n8;
                            if (n8 > 0 && (gridBagConstraints.minHeight + gridBagConstraints.centerPadding + n8) / 2 + gridBagConstraints.centerOffset != n7) {
                                --n8;
                            }
                            rectangle.height = gridBagConstraints.minHeight + n8;
                            rectangle.y = n + n7 - (rectangle.height + gridBagConstraints.centerPadding) / 2 - gridBagConstraints.centerOffset;
                            break;
                        }
                        case OTHER: {
                            break;
                        }
                    }
                }
            }
        } else {
            this.centerVertically(gridBagConstraints, rectangle, n2);
        }
    }

    private void alignAboveBaseline(GridBagConstraints gridBagConstraints, Rectangle rectangle, int n, int n2) {
        if (this.layoutInfo.hasBaseline(gridBagConstraints.tempY)) {
            int n3 = this.layoutInfo.hasConstantDescent(gridBagConstraints.tempY) ? n + n2 - this.layoutInfo.maxDescent[gridBagConstraints.tempY] : n + this.layoutInfo.maxAscent[gridBagConstraints.tempY];
            if (gridBagConstraints.isVerticallyResizable()) {
                rectangle.y = n + gridBagConstraints.insets.top;
                rectangle.height = n3 - rectangle.y;
            } else {
                rectangle.height = gridBagConstraints.minHeight + gridBagConstraints.ipady;
                rectangle.y = n3 - rectangle.height;
            }
        } else {
            this.centerVertically(gridBagConstraints, rectangle, n2);
        }
    }

    private void alignBelowBaseline(GridBagConstraints gridBagConstraints, Rectangle rectangle, int n, int n2) {
        if (this.layoutInfo.hasBaseline(gridBagConstraints.tempY)) {
            rectangle.y = this.layoutInfo.hasConstantDescent(gridBagConstraints.tempY) ? n + n2 - this.layoutInfo.maxDescent[gridBagConstraints.tempY] : n + this.layoutInfo.maxAscent[gridBagConstraints.tempY];
            if (gridBagConstraints.isVerticallyResizable()) {
                rectangle.height = n + n2 - rectangle.y - gridBagConstraints.insets.bottom;
            }
        } else {
            this.centerVertically(gridBagConstraints, rectangle, n2);
        }
    }

    private void centerVertically(GridBagConstraints gridBagConstraints, Rectangle rectangle, int n) {
        if (!gridBagConstraints.isVerticallyResizable()) {
            rectangle.y += Math.max(0, (n - gridBagConstraints.insets.top - gridBagConstraints.insets.bottom - gridBagConstraints.minHeight - gridBagConstraints.ipady) / 2);
        }
    }

    protected Dimension getMinSize(Container container, GridBagLayoutInfo gridBagLayoutInfo) {
        return this.GetMinSize(container, gridBagLayoutInfo);
    }

    protected Dimension GetMinSize(Container container, GridBagLayoutInfo gridBagLayoutInfo) {
        int n;
        Dimension dimension = new Dimension();
        Insets insets = container.getInsets();
        int n2 = 0;
        for (n = 0; n < gridBagLayoutInfo.width; ++n) {
            n2 += gridBagLayoutInfo.minWidth[n];
        }
        dimension.width = n2 + insets.left + insets.right;
        n2 = 0;
        for (n = 0; n < gridBagLayoutInfo.height; ++n) {
            n2 += gridBagLayoutInfo.minHeight[n];
        }
        dimension.height = n2 + insets.top + insets.bottom;
        return dimension;
    }

    protected void arrangeGrid(Container container) {
        this.ArrangeGrid(container);
    }

    protected void ArrangeGrid(Container container) {
        int n;
        int n2;
        double d;
        Insets insets = container.getInsets();
        Component[] componentArray = container.getComponents();
        Rectangle rectangle = new Rectangle();
        boolean bl = this.rightToLeft = !container.getComponentOrientation().isLeftToRight();
        if (!(componentArray.length != 0 || this.columnWidths != null && this.columnWidths.length != 0 || this.rowHeights != null && this.rowHeights.length != 0)) {
            return;
        }
        GridBagLayoutInfo gridBagLayoutInfo = this.getLayoutInfo(container, 2);
        Dimension dimension = this.getMinSize(container, gridBagLayoutInfo);
        if (container.width < dimension.width || container.height < dimension.height) {
            gridBagLayoutInfo = this.getLayoutInfo(container, 1);
            dimension = this.getMinSize(container, gridBagLayoutInfo);
        }
        this.layoutInfo = gridBagLayoutInfo;
        rectangle.width = dimension.width;
        rectangle.height = dimension.height;
        int n3 = container.width - rectangle.width;
        if (n3 != 0) {
            d = 0.0;
            for (n2 = 0; n2 < gridBagLayoutInfo.width; ++n2) {
                d += gridBagLayoutInfo.weightX[n2];
            }
            if (d > 0.0) {
                for (n2 = 0; n2 < gridBagLayoutInfo.width; ++n2) {
                    n = (int)((double)n3 * gridBagLayoutInfo.weightX[n2] / d);
                    int n4 = n2;
                    gridBagLayoutInfo.minWidth[n4] = gridBagLayoutInfo.minWidth[n4] + n;
                    rectangle.width += n;
                    if (gridBagLayoutInfo.minWidth[n2] >= 0) continue;
                    rectangle.width -= gridBagLayoutInfo.minWidth[n2];
                    gridBagLayoutInfo.minWidth[n2] = 0;
                }
            }
            n3 = container.width - rectangle.width;
        } else {
            n3 = 0;
        }
        int n5 = container.height - rectangle.height;
        if (n5 != 0) {
            d = 0.0;
            for (n2 = 0; n2 < gridBagLayoutInfo.height; ++n2) {
                d += gridBagLayoutInfo.weightY[n2];
            }
            if (d > 0.0) {
                for (n2 = 0; n2 < gridBagLayoutInfo.height; ++n2) {
                    n = (int)((double)n5 * gridBagLayoutInfo.weightY[n2] / d);
                    int n6 = n2;
                    gridBagLayoutInfo.minHeight[n6] = gridBagLayoutInfo.minHeight[n6] + n;
                    rectangle.height += n;
                    if (gridBagLayoutInfo.minHeight[n2] >= 0) continue;
                    rectangle.height -= gridBagLayoutInfo.minHeight[n2];
                    gridBagLayoutInfo.minHeight[n2] = 0;
                }
            }
            n5 = container.height - rectangle.height;
        } else {
            n5 = 0;
        }
        gridBagLayoutInfo.startx = n3 / 2 + insets.left;
        gridBagLayoutInfo.starty = n5 / 2 + insets.top;
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            if (!component.isVisible()) continue;
            GridBagConstraints gridBagConstraints = this.lookupConstraints(component);
            if (!this.rightToLeft) {
                rectangle.x = gridBagLayoutInfo.startx;
                for (n2 = 0; n2 < gridBagConstraints.tempX; ++n2) {
                    rectangle.x += gridBagLayoutInfo.minWidth[n2];
                }
            } else {
                rectangle.x = container.width - (n3 / 2 + insets.right);
                for (n2 = 0; n2 < gridBagConstraints.tempX; ++n2) {
                    rectangle.x -= gridBagLayoutInfo.minWidth[n2];
                }
            }
            rectangle.y = gridBagLayoutInfo.starty;
            for (n2 = 0; n2 < gridBagConstraints.tempY; ++n2) {
                rectangle.y += gridBagLayoutInfo.minHeight[n2];
            }
            rectangle.width = 0;
            for (n2 = gridBagConstraints.tempX; n2 < gridBagConstraints.tempX + gridBagConstraints.tempWidth; ++n2) {
                rectangle.width += gridBagLayoutInfo.minWidth[n2];
            }
            rectangle.height = 0;
            for (n2 = gridBagConstraints.tempY; n2 < gridBagConstraints.tempY + gridBagConstraints.tempHeight; ++n2) {
                rectangle.height += gridBagLayoutInfo.minHeight[n2];
            }
            this.componentAdjusting = component;
            this.adjustForGravity(gridBagConstraints, rectangle);
            if (rectangle.x < 0) {
                rectangle.width += rectangle.x;
                rectangle.x = 0;
            }
            if (rectangle.y < 0) {
                rectangle.height += rectangle.y;
                rectangle.y = 0;
            }
            if (rectangle.width <= 0 || rectangle.height <= 0) {
                component.setBounds(0, 0, 0, 0);
                continue;
            }
            if (component.x == rectangle.x && component.y == rectangle.y && component.width == rectangle.width && component.height == rectangle.height) continue;
            component.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }
}

