/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.Transient;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ListUI;
import javax.swing.text.Position;
import sun.awt.AWTAccessor;
import sun.swing.SwingUtilities2;

public class JList<E>
extends JComponent
implements Scrollable,
Accessible {
    private static final String uiClassID = "ListUI";
    public static final int VERTICAL = 0;
    public static final int VERTICAL_WRAP = 1;
    public static final int HORIZONTAL_WRAP = 2;
    private int fixedCellWidth = -1;
    private int fixedCellHeight = -1;
    private int horizontalScrollIncrement = -1;
    private E prototypeCellValue;
    private int visibleRowCount = 8;
    private Color selectionForeground;
    private Color selectionBackground;
    private boolean dragEnabled;
    private ListSelectionModel selectionModel;
    private ListModel<E> dataModel;
    private ListCellRenderer<? super E> cellRenderer;
    private ListSelectionListener selectionListener;
    private int layoutOrientation;
    private DropMode dropMode = DropMode.USE_SELECTION;
    private transient DropLocation dropLocation;

    public JList(ListModel<E> listModel) {
        if (listModel == null) {
            throw new IllegalArgumentException("dataModel must be non null");
        }
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.registerComponent(this);
        this.layoutOrientation = 0;
        this.dataModel = listModel;
        this.selectionModel = this.createSelectionModel();
        this.setAutoscrolls(true);
        this.setOpaque(true);
        this.updateUI();
    }

    public JList(final E[] EArray) {
        this(new AbstractListModel<E>(){

            @Override
            public int getSize() {
                return EArray.length;
            }

            @Override
            public E getElementAt(int n) {
                return EArray[n];
            }
        });
    }

    public JList(final Vector<? extends E> vector) {
        this(new AbstractListModel<E>(){

            @Override
            public int getSize() {
                return vector.size();
            }

            @Override
            public E getElementAt(int n) {
                return vector.elementAt(n);
            }
        });
    }

    public JList() {
        this(new AbstractListModel<E>(){

            @Override
            public int getSize() {
                return 0;
            }

            @Override
            public E getElementAt(int n) {
                throw new IndexOutOfBoundsException("No Data Model");
            }
        });
    }

    public ListUI getUI() {
        return (ListUI)this.ui;
    }

    public void setUI(ListUI listUI) {
        super.setUI(listUI);
    }

    @Override
    public void updateUI() {
        this.setUI((ListUI)UIManager.getUI(this));
        ListCellRenderer<E> listCellRenderer = this.getCellRenderer();
        if (listCellRenderer instanceof Component) {
            SwingUtilities.updateComponentTreeUI((Component)((Object)listCellRenderer));
        }
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    private void updateFixedCellSize() {
        ListCellRenderer<E> listCellRenderer = this.getCellRenderer();
        E e = this.getPrototypeCellValue();
        if (listCellRenderer != null && e != null) {
            Component component = listCellRenderer.getListCellRendererComponent(this, e, 0, false, false);
            Font font = component.getFont();
            component.setFont(this.getFont());
            Dimension dimension = component.getPreferredSize();
            this.fixedCellWidth = dimension.width;
            this.fixedCellHeight = dimension.height;
            component.setFont(font);
        }
    }

    public E getPrototypeCellValue() {
        return this.prototypeCellValue;
    }

    public void setPrototypeCellValue(E e) {
        E e2 = this.prototypeCellValue;
        this.prototypeCellValue = e;
        if (e != null && !e.equals(e2)) {
            this.updateFixedCellSize();
        }
        this.firePropertyChange("prototypeCellValue", e2, e);
    }

    public int getFixedCellWidth() {
        return this.fixedCellWidth;
    }

    public void setFixedCellWidth(int n) {
        int n2 = this.fixedCellWidth;
        this.fixedCellWidth = n;
        this.firePropertyChange("fixedCellWidth", n2, this.fixedCellWidth);
    }

    public int getFixedCellHeight() {
        return this.fixedCellHeight;
    }

    public void setFixedCellHeight(int n) {
        int n2 = this.fixedCellHeight;
        this.fixedCellHeight = n;
        this.firePropertyChange("fixedCellHeight", n2, this.fixedCellHeight);
    }

    @Transient
    public ListCellRenderer<? super E> getCellRenderer() {
        return this.cellRenderer;
    }

    public void setCellRenderer(ListCellRenderer<? super E> listCellRenderer) {
        ListCellRenderer<? super E> listCellRenderer2 = this.cellRenderer;
        this.cellRenderer = listCellRenderer;
        if (listCellRenderer != null && !listCellRenderer.equals(listCellRenderer2)) {
            this.updateFixedCellSize();
        }
        this.firePropertyChange("cellRenderer", listCellRenderer2, listCellRenderer);
    }

    public Color getSelectionForeground() {
        return this.selectionForeground;
    }

    public void setSelectionForeground(Color color) {
        Color color2 = this.selectionForeground;
        this.selectionForeground = color;
        this.firePropertyChange("selectionForeground", color2, color);
    }

    public Color getSelectionBackground() {
        return this.selectionBackground;
    }

    public void setSelectionBackground(Color color) {
        Color color2 = this.selectionBackground;
        this.selectionBackground = color;
        this.firePropertyChange("selectionBackground", color2, color);
    }

    public int getVisibleRowCount() {
        return this.visibleRowCount;
    }

    public void setVisibleRowCount(int n) {
        int n2 = this.visibleRowCount;
        this.visibleRowCount = Math.max(0, n);
        this.firePropertyChange("visibleRowCount", n2, n);
    }

    public int getLayoutOrientation() {
        return this.layoutOrientation;
    }

    public void setLayoutOrientation(int n) {
        int n2 = this.layoutOrientation;
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                this.layoutOrientation = n;
                this.firePropertyChange("layoutOrientation", n2, n);
                break;
            }
            default: {
                throw new IllegalArgumentException("layoutOrientation must be one of: VERTICAL, HORIZONTAL_WRAP or VERTICAL_WRAP");
            }
        }
    }

    public int getFirstVisibleIndex() {
        Rectangle rectangle;
        Rectangle rectangle2 = this.getVisibleRect();
        int n = this.getComponentOrientation().isLeftToRight() ? this.locationToIndex(rectangle2.getLocation()) : this.locationToIndex(new Point(rectangle2.x + rectangle2.width - 1, rectangle2.y));
        if (n != -1 && (rectangle = this.getCellBounds(n, n)) != null) {
            SwingUtilities.computeIntersection(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, rectangle);
            if (rectangle.width == 0 || rectangle.height == 0) {
                n = -1;
            }
        }
        return n;
    }

    public int getLastVisibleIndex() {
        Rectangle rectangle;
        boolean bl = this.getComponentOrientation().isLeftToRight();
        Rectangle rectangle2 = this.getVisibleRect();
        Point point = bl ? new Point(rectangle2.x + rectangle2.width - 1, rectangle2.y + rectangle2.height - 1) : new Point(rectangle2.x, rectangle2.y + rectangle2.height - 1);
        int n = this.locationToIndex(point);
        if (n != -1 && (rectangle = this.getCellBounds(n, n)) != null) {
            SwingUtilities.computeIntersection(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, rectangle);
            if (rectangle.width == 0 || rectangle.height == 0) {
                int n2;
                boolean bl2 = this.getLayoutOrientation() == 2;
                Point point2 = bl2 ? new Point(point.x, rectangle2.y) : new Point(rectangle2.x, point.y);
                int n3 = -1;
                int n4 = n;
                n = -1;
                do {
                    n2 = n3;
                    n3 = this.locationToIndex(point2);
                    if (n3 == -1) continue;
                    rectangle = this.getCellBounds(n3, n3);
                    if (n3 != n4 && rectangle != null && rectangle.contains(point2)) {
                        n = n3;
                        if (bl2) {
                            point2.y = rectangle.y + rectangle.height;
                            if (point2.y < point.y) continue;
                            n2 = n3;
                            continue;
                        }
                        point2.x = rectangle.x + rectangle.width;
                        if (point2.x < point.x) continue;
                        n2 = n3;
                        continue;
                    }
                    n2 = n3;
                } while (n3 != -1 && n2 != n3);
            }
        }
        return n;
    }

    public void ensureIndexIsVisible(int n) {
        Rectangle rectangle = this.getCellBounds(n, n);
        if (rectangle != null) {
            this.scrollRectToVisible(rectangle);
        }
    }

    public void setDragEnabled(boolean bl) {
        if (bl && GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        this.dragEnabled = bl;
    }

    public boolean getDragEnabled() {
        return this.dragEnabled;
    }

    public final void setDropMode(DropMode dropMode) {
        if (dropMode != null) {
            switch (dropMode) {
                case USE_SELECTION: 
                case ON: 
                case INSERT: 
                case ON_OR_INSERT: {
                    this.dropMode = dropMode;
                    return;
                }
            }
        }
        throw new IllegalArgumentException((Object)((Object)dropMode) + ": Unsupported drop mode for list");
    }

    public final DropMode getDropMode() {
        return this.dropMode;
    }

    @Override
    DropLocation dropLocationForPoint(Point point) {
        DropLocation dropLocation = null;
        Rectangle rectangle = null;
        int n = this.locationToIndex(point);
        if (n != -1) {
            rectangle = this.getCellBounds(n, n);
        }
        switch (this.dropMode) {
            case USE_SELECTION: 
            case ON: {
                dropLocation = new DropLocation(point, rectangle != null && rectangle.contains(point) ? n : -1, false);
                break;
            }
            case INSERT: {
                if (n == -1) {
                    dropLocation = new DropLocation(point, this.getModel().getSize(), true);
                    break;
                }
                if (this.layoutOrientation == 2) {
                    boolean bl = this.getComponentOrientation().isLeftToRight();
                    if (SwingUtilities2.liesInHorizontal(rectangle, point, bl, false) == SwingUtilities2.Section.TRAILING) {
                        ++n;
                    } else if (n == this.getModel().getSize() - 1 && point.y >= rectangle.y + rectangle.height) {
                        ++n;
                    }
                } else if (SwingUtilities2.liesInVertical(rectangle, point, false) == SwingUtilities2.Section.TRAILING) {
                    ++n;
                }
                dropLocation = new DropLocation(point, n, true);
                break;
            }
            case ON_OR_INSERT: {
                if (n == -1) {
                    dropLocation = new DropLocation(point, this.getModel().getSize(), true);
                    break;
                }
                boolean bl = false;
                if (this.layoutOrientation == 2) {
                    boolean bl2 = this.getComponentOrientation().isLeftToRight();
                    SwingUtilities2.Section section = SwingUtilities2.liesInHorizontal(rectangle, point, bl2, true);
                    if (section == SwingUtilities2.Section.TRAILING) {
                        ++n;
                        bl = true;
                    } else if (n == this.getModel().getSize() - 1 && point.y >= rectangle.y + rectangle.height) {
                        ++n;
                        bl = true;
                    } else if (section == SwingUtilities2.Section.LEADING) {
                        bl = true;
                    }
                } else {
                    SwingUtilities2.Section section = SwingUtilities2.liesInVertical(rectangle, point, true);
                    if (section == SwingUtilities2.Section.LEADING) {
                        bl = true;
                    } else if (section == SwingUtilities2.Section.TRAILING) {
                        ++n;
                        bl = true;
                    }
                }
                dropLocation = new DropLocation(point, n, bl);
                break;
            }
            default: {
                assert (false) : "Unexpected drop mode";
                break;
            }
        }
        return dropLocation;
    }

    @Override
    Object setDropLocation(TransferHandler.DropLocation dropLocation, Object object, boolean bl) {
        Object object2 = null;
        DropLocation dropLocation2 = (DropLocation)dropLocation;
        if (this.dropMode == DropMode.USE_SELECTION) {
            int n;
            if (dropLocation2 == null) {
                if (!bl && object != null) {
                    this.setSelectedIndices(((int[][])object)[0]);
                    n = ((int[][])object)[1][0];
                    int n2 = ((int[][])object)[1][1];
                    SwingUtilities2.setLeadAnchorWithoutSelection(this.getSelectionModel(), n2, n);
                }
            } else {
                if (this.dropLocation == null) {
                    int[] nArray = this.getSelectedIndices();
                    object2 = new int[][]{nArray, {this.getAnchorSelectionIndex(), this.getLeadSelectionIndex()}};
                } else {
                    object2 = object;
                }
                n = dropLocation2.getIndex();
                if (n == -1) {
                    this.clearSelection();
                    this.getSelectionModel().setAnchorSelectionIndex(-1);
                    this.getSelectionModel().setLeadSelectionIndex(-1);
                } else {
                    this.setSelectionInterval(n, n);
                }
            }
        }
        DropLocation dropLocation3 = this.dropLocation;
        this.dropLocation = dropLocation2;
        this.firePropertyChange("dropLocation", dropLocation3, this.dropLocation);
        return object2;
    }

    public final DropLocation getDropLocation() {
        return this.dropLocation;
    }

    public int getNextMatch(String string, int n, Position.Bias bias) {
        ListModel<E> listModel = this.getModel();
        int n2 = listModel.getSize();
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (n < 0 || n >= n2) {
            throw new IllegalArgumentException();
        }
        string = string.toUpperCase();
        int n3 = bias == Position.Bias.Forward ? 1 : -1;
        int n4 = n;
        do {
            String string2;
            E e;
            if ((e = listModel.getElementAt(n4)) == null) continue;
            if (e instanceof String) {
                string2 = ((String)e).toUpperCase();
            } else {
                string2 = e.toString();
                if (string2 != null) {
                    string2 = string2.toUpperCase();
                }
            }
            if (string2 == null || !string2.startsWith(string)) continue;
            return n4;
        } while ((n4 = (n4 + n3 + n2) % n2) != n);
        return -1;
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        if (mouseEvent != null) {
            Rectangle rectangle;
            Point point = mouseEvent.getPoint();
            int n = this.locationToIndex(point);
            ListCellRenderer<E> listCellRenderer = this.getCellRenderer();
            if (n != -1 && listCellRenderer != null && (rectangle = this.getCellBounds(n, n)) != null && rectangle.contains(point.x, point.y)) {
                ListSelectionModel listSelectionModel = this.getSelectionModel();
                Component component = listCellRenderer.getListCellRendererComponent(this, this.getModel().getElementAt(n), n, listSelectionModel.isSelectedIndex(n), this.hasFocus() && listSelectionModel.getLeadSelectionIndex() == n);
                if (component instanceof JComponent) {
                    point.translate(-rectangle.x, -rectangle.y);
                    MouseEvent mouseEvent2 = new MouseEvent(component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), 0);
                    AWTAccessor.MouseEventAccessor mouseEventAccessor = AWTAccessor.getMouseEventAccessor();
                    mouseEventAccessor.setCausedByTouchEvent(mouseEvent2, mouseEventAccessor.isCausedByTouchEvent(mouseEvent));
                    String string = ((JComponent)component).getToolTipText(mouseEvent2);
                    if (string != null) {
                        return string;
                    }
                }
            }
        }
        return super.getToolTipText();
    }

    public int locationToIndex(Point point) {
        ListUI listUI = this.getUI();
        return listUI != null ? listUI.locationToIndex(this, point) : -1;
    }

    public Point indexToLocation(int n) {
        ListUI listUI = this.getUI();
        return listUI != null ? listUI.indexToLocation(this, n) : null;
    }

    public Rectangle getCellBounds(int n, int n2) {
        ListUI listUI = this.getUI();
        return listUI != null ? listUI.getCellBounds(this, n, n2) : null;
    }

    public ListModel<E> getModel() {
        return this.dataModel;
    }

    public void setModel(ListModel<E> listModel) {
        if (listModel == null) {
            throw new IllegalArgumentException("model must be non null");
        }
        ListModel<E> listModel2 = this.dataModel;
        this.dataModel = listModel;
        this.firePropertyChange("model", listModel2, this.dataModel);
        this.clearSelection();
    }

    public void setListData(final E[] EArray) {
        this.setModel(new AbstractListModel<E>(){

            @Override
            public int getSize() {
                return EArray.length;
            }

            @Override
            public E getElementAt(int n) {
                return EArray[n];
            }
        });
    }

    public void setListData(final Vector<? extends E> vector) {
        this.setModel(new AbstractListModel<E>(){

            @Override
            public int getSize() {
                return vector.size();
            }

            @Override
            public E getElementAt(int n) {
                return vector.elementAt(n);
            }
        });
    }

    protected ListSelectionModel createSelectionModel() {
        return new DefaultListSelectionModel();
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    protected void fireSelectionValueChanged(int n, int n2, boolean bl) {
        Object[] objectArray = this.listenerList.getListenerList();
        ListSelectionEvent listSelectionEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ListSelectionListener.class) continue;
            if (listSelectionEvent == null) {
                listSelectionEvent = new ListSelectionEvent(this, n, n2, bl);
            }
            ((ListSelectionListener)objectArray[i + 1]).valueChanged(listSelectionEvent);
        }
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        if (this.selectionListener == null) {
            this.selectionListener = new ListSelectionHandler();
            this.getSelectionModel().addListSelectionListener(this.selectionListener);
        }
        this.listenerList.add(ListSelectionListener.class, listSelectionListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listenerList.remove(ListSelectionListener.class, listSelectionListener);
    }

    public ListSelectionListener[] getListSelectionListeners() {
        return (ListSelectionListener[])this.listenerList.getListeners(ListSelectionListener.class);
    }

    public void setSelectionModel(ListSelectionModel listSelectionModel) {
        if (listSelectionModel == null) {
            throw new IllegalArgumentException("selectionModel must be non null");
        }
        if (this.selectionListener != null) {
            this.selectionModel.removeListSelectionListener(this.selectionListener);
            listSelectionModel.addListSelectionListener(this.selectionListener);
        }
        ListSelectionModel listSelectionModel2 = this.selectionModel;
        this.selectionModel = listSelectionModel;
        this.firePropertyChange("selectionModel", listSelectionModel2, listSelectionModel);
    }

    public void setSelectionMode(int n) {
        this.getSelectionModel().setSelectionMode(n);
    }

    public int getSelectionMode() {
        return this.getSelectionModel().getSelectionMode();
    }

    public int getAnchorSelectionIndex() {
        return this.getSelectionModel().getAnchorSelectionIndex();
    }

    public int getLeadSelectionIndex() {
        return this.getSelectionModel().getLeadSelectionIndex();
    }

    public int getMinSelectionIndex() {
        return this.getSelectionModel().getMinSelectionIndex();
    }

    public int getMaxSelectionIndex() {
        return this.getSelectionModel().getMaxSelectionIndex();
    }

    public boolean isSelectedIndex(int n) {
        return this.getSelectionModel().isSelectedIndex(n);
    }

    public boolean isSelectionEmpty() {
        return this.getSelectionModel().isSelectionEmpty();
    }

    public void clearSelection() {
        this.getSelectionModel().clearSelection();
    }

    public void setSelectionInterval(int n, int n2) {
        this.getSelectionModel().setSelectionInterval(n, n2);
    }

    public void addSelectionInterval(int n, int n2) {
        this.getSelectionModel().addSelectionInterval(n, n2);
    }

    public void removeSelectionInterval(int n, int n2) {
        this.getSelectionModel().removeSelectionInterval(n, n2);
    }

    public void setValueIsAdjusting(boolean bl) {
        this.getSelectionModel().setValueIsAdjusting(bl);
    }

    public boolean getValueIsAdjusting() {
        return this.getSelectionModel().getValueIsAdjusting();
    }

    @Transient
    public int[] getSelectedIndices() {
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        int n = listSelectionModel.getMinSelectionIndex();
        int n2 = listSelectionModel.getMaxSelectionIndex();
        if (n < 0 || n2 < 0) {
            return new int[0];
        }
        int[] nArray = new int[1 + (n2 - n)];
        int n3 = 0;
        for (int i = n; i <= n2; ++i) {
            if (!listSelectionModel.isSelectedIndex(i)) continue;
            nArray[n3++] = i;
        }
        int[] nArray2 = new int[n3];
        System.arraycopy((Object)nArray, 0, (Object)nArray2, 0, n3);
        return nArray2;
    }

    public void setSelectedIndex(int n) {
        if (n >= this.getModel().getSize()) {
            return;
        }
        this.getSelectionModel().setSelectionInterval(n, n);
    }

    public void setSelectedIndices(int[] nArray) {
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        listSelectionModel.clearSelection();
        int n = this.getModel().getSize();
        for (int n2 : nArray) {
            if (n2 >= n) continue;
            listSelectionModel.addSelectionInterval(n2, n2);
        }
    }

    @Deprecated
    public Object[] getSelectedValues() {
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        ListModel<E> listModel = this.getModel();
        int n = listSelectionModel.getMinSelectionIndex();
        int n2 = listSelectionModel.getMaxSelectionIndex();
        if (n < 0 || n2 < 0) {
            return new Object[0];
        }
        Object[] objectArray = new Object[1 + (n2 - n)];
        int n3 = 0;
        for (int i = n; i <= n2; ++i) {
            if (!listSelectionModel.isSelectedIndex(i)) continue;
            objectArray[n3++] = listModel.getElementAt(i);
        }
        Object[] objectArray2 = new Object[n3];
        System.arraycopy((Object)objectArray, 0, (Object)objectArray2, 0, n3);
        return objectArray2;
    }

    public List<E> getSelectedValuesList() {
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        ListModel<E> listModel = this.getModel();
        int n = listSelectionModel.getMinSelectionIndex();
        int n2 = listSelectionModel.getMaxSelectionIndex();
        if (n < 0 || n2 < 0) {
            return Collections.emptyList();
        }
        ArrayList<E> arrayList = new ArrayList<E>();
        for (int i = n; i <= n2; ++i) {
            if (!listSelectionModel.isSelectedIndex(i)) continue;
            arrayList.add(listModel.getElementAt(i));
        }
        return arrayList;
    }

    public int getSelectedIndex() {
        return this.getMinSelectionIndex();
    }

    public E getSelectedValue() {
        int n = this.getMinSelectionIndex();
        return n == -1 ? null : (E)this.getModel().getElementAt(n);
    }

    public void setSelectedValue(Object object, boolean bl) {
        if (object == null) {
            this.setSelectedIndex(-1);
        } else if (!object.equals(this.getSelectedValue())) {
            ListModel<E> listModel = this.getModel();
            int n = listModel.getSize();
            for (int i = 0; i < n; ++i) {
                if (!object.equals(listModel.getElementAt(i))) continue;
                this.setSelectedIndex(i);
                if (bl) {
                    this.ensureIndexIsVisible(i);
                }
                this.repaint();
                return;
            }
            this.setSelectedIndex(-1);
        }
        this.repaint();
    }

    private void checkScrollableParameters(Rectangle rectangle, int n) {
        if (rectangle == null) {
            throw new IllegalArgumentException("visibleRect must be non-null");
        }
        switch (n) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("orientation must be one of: VERTICAL, HORIZONTAL");
            }
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        if (this.getLayoutOrientation() != 0) {
            return this.getPreferredSize();
        }
        Insets insets = this.getInsets();
        int n = insets.left + insets.right;
        int n2 = insets.top + insets.bottom;
        int n3 = this.getVisibleRowCount();
        int n4 = this.getFixedCellWidth();
        int n5 = this.getFixedCellHeight();
        if (n4 > 0 && n5 > 0) {
            int n6 = n4 + n;
            int n7 = n3 * n5 + n2;
            return new Dimension(n6, n7);
        }
        if (this.getModel().getSize() > 0) {
            int n8 = this.getPreferredSize().width;
            Rectangle rectangle = this.getCellBounds(0, 0);
            int n9 = rectangle != null ? n3 * rectangle.height + n2 : 1;
            return new Dimension(n8, n9);
        }
        n4 = n4 > 0 ? n4 : 256;
        n5 = n5 > 0 ? n5 : 16;
        return new Dimension(n4, n5 * n3);
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        Rectangle rectangle2;
        boolean bl;
        Point point;
        int n3;
        this.checkScrollableParameters(rectangle, n);
        if (n == 1) {
            int n4 = this.locationToIndex(rectangle.getLocation());
            if (n4 == -1) {
                return 0;
            }
            if (n2 > 0) {
                Rectangle rectangle3 = this.getCellBounds(n4, n4);
                return rectangle3 == null ? 0 : rectangle3.height - (rectangle.y - rectangle3.y);
            }
            Rectangle rectangle4 = this.getCellBounds(n4, n4);
            if (rectangle4.y == rectangle.y && n4 == 0) {
                return 0;
            }
            if (rectangle4.y == rectangle.y) {
                Point point2 = rectangle4.getLocation();
                --point2.y;
                int n5 = this.locationToIndex(point2);
                Rectangle rectangle5 = this.getCellBounds(n5, n5);
                if (rectangle5 == null || rectangle5.y >= rectangle4.y) {
                    return 0;
                }
                return rectangle5.height;
            }
            return rectangle.y - rectangle4.y;
        }
        if (n == 0 && this.getLayoutOrientation() != 0 && (n3 = this.locationToIndex(point = (bl = this.getComponentOrientation().isLeftToRight()) ? rectangle.getLocation() : new Point(rectangle.x + rectangle.width - 1, rectangle.y))) != -1 && (rectangle2 = this.getCellBounds(n3, n3)) != null && rectangle2.contains(point)) {
            int n6;
            int n7;
            if (bl) {
                n7 = rectangle.x;
                n6 = rectangle2.x;
            } else {
                n7 = rectangle.x + rectangle.width;
                n6 = rectangle2.x + rectangle2.width;
            }
            if (n6 != n7) {
                if (n2 < 0) {
                    return Math.abs(n7 - n6);
                }
                if (bl) {
                    return n6 + rectangle2.width - n7;
                }
                return n7 - rectangle2.x;
            }
            return rectangle2.width;
        }
        Font font = this.getFont();
        return font != null ? font.getSize() : 1;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        this.checkScrollableParameters(rectangle, n);
        if (n == 1) {
            int n3 = rectangle.height;
            if (n2 > 0) {
                Rectangle rectangle2;
                int n4 = this.locationToIndex(new Point(rectangle.x, rectangle.y + rectangle.height - 1));
                if (n4 != -1 && (rectangle2 = this.getCellBounds(n4, n4)) != null && (n3 = rectangle2.y - rectangle.y) == 0 && n4 < this.getModel().getSize() - 1) {
                    n3 = rectangle2.height;
                }
            } else {
                int n5 = this.locationToIndex(new Point(rectangle.x, rectangle.y - rectangle.height));
                int n6 = this.getFirstVisibleIndex();
                if (n5 != -1) {
                    if (n6 == -1) {
                        n6 = this.locationToIndex(rectangle.getLocation());
                    }
                    Rectangle rectangle3 = this.getCellBounds(n5, n5);
                    Rectangle rectangle4 = this.getCellBounds(n6, n6);
                    if (rectangle3 != null && rectangle4 != null) {
                        while (rectangle3.y + rectangle.height < rectangle4.y + rectangle4.height && rectangle3.y < rectangle4.y) {
                            rectangle3 = this.getCellBounds(++n5, n5);
                        }
                        n3 = rectangle.y - rectangle3.y;
                        if (n3 <= 0 && rectangle3.y > 0 && (rectangle3 = this.getCellBounds(--n5, n5)) != null) {
                            n3 = rectangle.y - rectangle3.y;
                        }
                    }
                }
            }
            return n3;
        }
        if (n == 0 && this.getLayoutOrientation() != 0) {
            boolean bl = this.getComponentOrientation().isLeftToRight();
            int n7 = rectangle.width;
            if (n2 > 0) {
                Rectangle rectangle5;
                int n8 = rectangle.x + (bl ? rectangle.width - 1 : 0);
                int n9 = this.locationToIndex(new Point(n8, rectangle.y));
                if (n9 != -1 && (rectangle5 = this.getCellBounds(n9, n9)) != null) {
                    n7 = bl ? rectangle5.x - rectangle.x : rectangle.x + rectangle.width - (rectangle5.x + rectangle5.width);
                    if (n7 < 0) {
                        n7 += rectangle5.width;
                    } else if (n7 == 0 && n9 < this.getModel().getSize() - 1) {
                        n7 = rectangle5.width;
                    }
                }
            } else {
                Rectangle rectangle6;
                int n10 = rectangle.x + (bl ? -rectangle.width : rectangle.width - 1 + rectangle.width);
                int n11 = this.locationToIndex(new Point(n10, rectangle.y));
                if (n11 != -1 && (rectangle6 = this.getCellBounds(n11, n11)) != null) {
                    int n12;
                    int n13 = rectangle6.x + rectangle6.width;
                    n7 = bl ? (rectangle6.x < rectangle.x - rectangle.width && n13 < rectangle.x ? rectangle.x - n13 : rectangle.x - rectangle6.x) : (n13 > (n12 = rectangle.x + rectangle.width) + rectangle.width && rectangle6.x > n12 ? rectangle6.x - n12 : n13 - n12);
                }
            }
            return n7;
        }
        return rectangle.width;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (this.getLayoutOrientation() == 2 && this.getVisibleRowCount() <= 0) {
            return true;
        }
        Container container = SwingUtilities.getUnwrappedParent(this);
        if (container instanceof JViewport) {
            return container.getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        if (this.getLayoutOrientation() == 1 && this.getVisibleRowCount() <= 0) {
            return true;
        }
        Container container = SwingUtilities.getUnwrappedParent(this);
        if (container instanceof JViewport) {
            return container.getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    @Override
    protected String paramString() {
        String string = this.selectionForeground != null ? this.selectionForeground.toString() : "";
        String string2 = this.selectionBackground != null ? this.selectionBackground.toString() : "";
        return super.paramString() + ",fixedCellHeight=" + this.fixedCellHeight + ",fixedCellWidth=" + this.fixedCellWidth + ",horizontalScrollIncrement=" + this.horizontalScrollIncrement + ",selectionBackground=" + string2 + ",selectionForeground=" + string + ",visibleRowCount=" + this.visibleRowCount + ",layoutOrientation=" + this.layoutOrientation;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJList();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJList
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection,
    PropertyChangeListener,
    ListSelectionListener,
    ListDataListener {
        int leadSelectionIndex;

        public AccessibleJList() {
            JList.this.addPropertyChangeListener(this);
            JList.this.getSelectionModel().addListSelectionListener(this);
            JList.this.getModel().addListDataListener(this);
            this.leadSelectionIndex = JList.this.getLeadSelectionIndex();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            Object object = propertyChangeEvent.getOldValue();
            Object object2 = propertyChangeEvent.getNewValue();
            if (string.compareTo("model") == 0) {
                if (object != null && object instanceof ListModel) {
                    ((ListModel)object).removeListDataListener(this);
                }
                if (object2 != null && object2 instanceof ListModel) {
                    ((ListModel)object2).addListDataListener(this);
                }
            } else if (string.compareTo("selectionModel") == 0) {
                if (object != null && object instanceof ListSelectionModel) {
                    ((ListSelectionModel)object).removeListSelectionListener(this);
                }
                if (object2 != null && object2 instanceof ListSelectionModel) {
                    ((ListSelectionModel)object2).addListSelectionListener(this);
                }
                this.firePropertyChange("AccessibleSelection", false, true);
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            Object object;
            Object object2;
            int n = this.leadSelectionIndex;
            this.leadSelectionIndex = JList.this.getLeadSelectionIndex();
            if (n != this.leadSelectionIndex) {
                object2 = n >= 0 ? this.getAccessibleChild(n) : null;
                object = this.leadSelectionIndex >= 0 ? this.getAccessibleChild(this.leadSelectionIndex) : null;
                this.firePropertyChange("AccessibleActiveDescendant", object2, object);
            }
            this.firePropertyChange("AccessibleVisibleData", false, true);
            this.firePropertyChange("AccessibleSelection", false, true);
            object2 = this.getAccessibleStateSet();
            object = JList.this.getSelectionModel();
            if (object.getSelectionMode() != 0) {
                if (!((AccessibleStateSet)object2).contains(AccessibleState.MULTISELECTABLE)) {
                    ((AccessibleStateSet)object2).add(AccessibleState.MULTISELECTABLE);
                    this.firePropertyChange("AccessibleState", null, AccessibleState.MULTISELECTABLE);
                }
            } else if (((AccessibleStateSet)object2).contains(AccessibleState.MULTISELECTABLE)) {
                ((AccessibleStateSet)object2).remove(AccessibleState.MULTISELECTABLE);
                this.firePropertyChange("AccessibleState", AccessibleState.MULTISELECTABLE, null);
            }
        }

        @Override
        public void intervalAdded(ListDataEvent listDataEvent) {
            this.firePropertyChange("AccessibleVisibleData", false, true);
        }

        @Override
        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.firePropertyChange("AccessibleVisibleData", false, true);
        }

        @Override
        public void contentsChanged(ListDataEvent listDataEvent) {
            this.firePropertyChange("AccessibleVisibleData", false, true);
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (JList.this.selectionModel.getSelectionMode() != 0) {
                accessibleStateSet.add(AccessibleState.MULTISELECTABLE);
            }
            return accessibleStateSet;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LIST;
        }

        @Override
        public Accessible getAccessibleAt(Point point) {
            int n = JList.this.locationToIndex(point);
            if (n >= 0) {
                return new ActionableAccessibleJListChild(JList.this, n);
            }
            return null;
        }

        @Override
        public int getAccessibleChildrenCount() {
            return JList.this.getModel().getSize();
        }

        @Override
        public Accessible getAccessibleChild(int n) {
            if (n >= JList.this.getModel().getSize()) {
                return null;
            }
            return new ActionableAccessibleJListChild(JList.this, n);
        }

        @Override
        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        @Override
        public int getAccessibleSelectionCount() {
            return JList.this.getSelectedIndices().length;
        }

        @Override
        public Accessible getAccessibleSelection(int n) {
            int n2 = this.getAccessibleSelectionCount();
            if (n < 0 || n >= n2) {
                return null;
            }
            return this.getAccessibleChild(JList.this.getSelectedIndices()[n]);
        }

        @Override
        public boolean isAccessibleChildSelected(int n) {
            return JList.this.isSelectedIndex(n);
        }

        @Override
        public void addAccessibleSelection(int n) {
            JList.this.addSelectionInterval(n, n);
        }

        @Override
        public void removeAccessibleSelection(int n) {
            JList.this.removeSelectionInterval(n, n);
        }

        @Override
        public void clearAccessibleSelection() {
            JList.this.clearSelection();
        }

        @Override
        public void selectAllAccessibleSelection() {
            JList.this.addSelectionInterval(0, this.getAccessibleChildrenCount() - 1);
        }

        /*
         * Signature claims super is javax.swing.JList$AccessibleJList.AccessibleJListChild, not javax.swing.JList$AccessibleJList$AccessibleJListChild - discarding signature.
         */
        private class ActionableAccessibleJListChild
        extends AccessibleJListChild
        implements AccessibleAction {
            ActionableAccessibleJListChild(JList<E> jList, int n) {
                super(jList, n);
            }

            @Override
            public AccessibleAction getAccessibleAction() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext == null) {
                    return null;
                }
                AccessibleAction accessibleAction = accessibleContext.getAccessibleAction();
                if (accessibleAction != null) {
                    return accessibleAction;
                }
                return this;
            }

            @Override
            public boolean doAccessibleAction(int n) {
                if (n == 0) {
                    JList.this.setSelectedIndex(this.indexInParent);
                    return true;
                }
                return false;
            }

            @Override
            public String getAccessibleActionDescription(int n) {
                if (n == 0) {
                    return UIManager.getString("AbstractButton.clickText");
                }
                return null;
            }

            @Override
            public int getAccessibleActionCount() {
                return 1;
            }
        }

        protected class AccessibleJListChild
        extends AccessibleContext
        implements Accessible,
        AccessibleComponent {
            private JList<E> parent = null;
            int indexInParent;
            private Component component = null;
            private AccessibleContext accessibleContext = null;
            private ListModel<E> listModel;
            private ListCellRenderer<? super E> cellRenderer = null;

            public AccessibleJListChild(JList<E> jList, int n) {
                this.parent = jList;
                this.setAccessibleParent(jList);
                this.indexInParent = n;
                if (jList != null) {
                    this.listModel = jList.getModel();
                    this.cellRenderer = jList.getCellRenderer();
                }
            }

            private Component getCurrentComponent() {
                return this.getComponentAtIndex(this.indexInParent);
            }

            AccessibleContext getCurrentAccessibleContext() {
                Component component = this.getComponentAtIndex(this.indexInParent);
                if (component instanceof Accessible) {
                    return component.getAccessibleContext();
                }
                return null;
            }

            private Component getComponentAtIndex(int n) {
                if (n < 0 || n >= this.listModel.getSize()) {
                    return null;
                }
                if (this.parent != null && this.listModel != null && this.cellRenderer != null) {
                    Object e = this.listModel.getElementAt(n);
                    boolean bl = this.parent.isSelectedIndex(n);
                    boolean bl2 = this.parent.isFocusOwner() && n == this.parent.getLeadSelectionIndex();
                    return this.cellRenderer.getListCellRendererComponent(this.parent, e, n, bl, bl2);
                }
                return null;
            }

            @Override
            public AccessibleContext getAccessibleContext() {
                return this;
            }

            @Override
            public String getAccessibleName() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleName();
                }
                return null;
            }

            @Override
            public void setAccessibleName(String string) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleName(string);
                }
            }

            @Override
            public String getAccessibleDescription() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleDescription();
                }
                return null;
            }

            @Override
            public void setAccessibleDescription(String string) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleDescription(string);
                }
            }

            @Override
            public AccessibleRole getAccessibleRole() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleRole();
                }
                return null;
            }

            @Override
            public AccessibleStateSet getAccessibleStateSet() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                AccessibleStateSet accessibleStateSet = accessibleContext != null ? accessibleContext.getAccessibleStateSet() : new AccessibleStateSet();
                accessibleStateSet.add(AccessibleState.SELECTABLE);
                accessibleStateSet.add(AccessibleState.VISIBLE);
                if (this.parent.isFocusOwner() && this.indexInParent == this.parent.getLeadSelectionIndex()) {
                    accessibleStateSet.add(AccessibleState.ACTIVE);
                }
                if (this.parent.isSelectedIndex(this.indexInParent)) {
                    accessibleStateSet.add(AccessibleState.SELECTED);
                }
                if (this.isShowing()) {
                    accessibleStateSet.add(AccessibleState.SHOWING);
                } else if (accessibleStateSet.contains(AccessibleState.SHOWING)) {
                    accessibleStateSet.remove(AccessibleState.SHOWING);
                }
                accessibleStateSet.add(AccessibleState.TRANSIENT);
                return accessibleStateSet;
            }

            @Override
            public int getAccessibleIndexInParent() {
                return this.indexInParent;
            }

            @Override
            public int getAccessibleChildrenCount() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleChildrenCount();
                }
                return 0;
            }

            @Override
            public Accessible getAccessibleChild(int n) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    Accessible accessible = accessibleContext.getAccessibleChild(n);
                    accessibleContext.setAccessibleParent(this);
                    return accessible;
                }
                return null;
            }

            @Override
            public Locale getLocale() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getLocale();
                }
                return null;
            }

            @Override
            public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.addPropertyChangeListener(propertyChangeListener);
                }
            }

            @Override
            public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.removePropertyChangeListener(propertyChangeListener);
                }
            }

            @Override
            public AccessibleComponent getAccessibleComponent() {
                return this;
            }

            @Override
            public AccessibleSelection getAccessibleSelection() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                return accessibleContext != null ? accessibleContext.getAccessibleSelection() : null;
            }

            @Override
            public AccessibleText getAccessibleText() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                return accessibleContext != null ? accessibleContext.getAccessibleText() : null;
            }

            @Override
            public AccessibleValue getAccessibleValue() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                return accessibleContext != null ? accessibleContext.getAccessibleValue() : null;
            }

            @Override
            public Color getBackground() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getBackground();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getBackground();
                }
                return null;
            }

            @Override
            public void setBackground(Color color) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setBackground(color);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setBackground(color);
                    }
                }
            }

            @Override
            public Color getForeground() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getForeground();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getForeground();
                }
                return null;
            }

            @Override
            public void setForeground(Color color) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setForeground(color);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setForeground(color);
                    }
                }
            }

            @Override
            public Cursor getCursor() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getCursor();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getCursor();
                }
                Accessible accessible = this.getAccessibleParent();
                if (accessible instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessible)).getCursor();
                }
                return null;
            }

            @Override
            public void setCursor(Cursor cursor) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setCursor(cursor);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setCursor(cursor);
                    }
                }
            }

            @Override
            public Font getFont() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getFont();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getFont();
                }
                return null;
            }

            @Override
            public void setFont(Font font) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setFont(font);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setFont(font);
                    }
                }
            }

            @Override
            public FontMetrics getFontMetrics(Font font) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getFontMetrics(font);
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getFontMetrics(font);
                }
                return null;
            }

            @Override
            public boolean isEnabled() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isEnabled();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isEnabled();
                }
                return false;
            }

            @Override
            public void setEnabled(boolean bl) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setEnabled(bl);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setEnabled(bl);
                    }
                }
            }

            @Override
            public boolean isVisible() {
                int n = this.parent.getFirstVisibleIndex();
                int n2 = this.parent.getLastVisibleIndex();
                if (n2 == -1) {
                    n2 = this.parent.getModel().getSize() - 1;
                }
                return this.indexInParent >= n && this.indexInParent <= n2;
            }

            @Override
            public void setVisible(boolean bl) {
            }

            @Override
            public boolean isShowing() {
                return this.parent.isShowing() && this.isVisible();
            }

            @Override
            public boolean contains(Point point) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    Rectangle rectangle = ((AccessibleComponent)((Object)accessibleContext)).getBounds();
                    return rectangle.contains(point);
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    Rectangle rectangle = component.getBounds();
                    return rectangle.contains(point);
                }
                return this.getBounds().contains(point);
            }

            @Override
            public Point getLocationOnScreen() {
                if (this.parent != null) {
                    Point point;
                    try {
                        point = this.parent.getLocationOnScreen();
                    }
                    catch (IllegalComponentStateException illegalComponentStateException) {
                        return null;
                    }
                    Point point2 = this.parent.indexToLocation(this.indexInParent);
                    if (point2 != null) {
                        point2.translate(point.x, point.y);
                        return point2;
                    }
                    return null;
                }
                return null;
            }

            @Override
            public Point getLocation() {
                if (this.parent != null) {
                    return this.parent.indexToLocation(this.indexInParent);
                }
                return null;
            }

            @Override
            public void setLocation(Point point) {
                if (this.parent != null && this.parent.contains(point)) {
                    JList.this.ensureIndexIsVisible(this.indexInParent);
                }
            }

            @Override
            public Rectangle getBounds() {
                if (this.parent != null) {
                    return this.parent.getCellBounds(this.indexInParent, this.indexInParent);
                }
                return null;
            }

            @Override
            public void setBounds(Rectangle rectangle) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setBounds(rectangle);
                }
            }

            @Override
            public Dimension getSize() {
                Rectangle rectangle = this.getBounds();
                if (rectangle != null) {
                    return rectangle.getSize();
                }
                return null;
            }

            @Override
            public void setSize(Dimension dimension) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setSize(dimension);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setSize(dimension);
                    }
                }
            }

            @Override
            public Accessible getAccessibleAt(Point point) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getAccessibleAt(point);
                }
                return null;
            }

            @Override
            public boolean isFocusTraversable() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isFocusTraversable();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isFocusTraversable();
                }
                return false;
            }

            @Override
            public void requestFocus() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).requestFocus();
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.requestFocus();
                    }
                }
            }

            @Override
            public void addFocusListener(FocusListener focusListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).addFocusListener(focusListener);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.addFocusListener(focusListener);
                    }
                }
            }

            @Override
            public void removeFocusListener(FocusListener focusListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).removeFocusListener(focusListener);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.removeFocusListener(focusListener);
                    }
                }
            }

            @Override
            public AccessibleIcon[] getAccessibleIcon() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleIcon();
                }
                return null;
            }
        }
    }

    private class ListSelectionHandler
    implements ListSelectionListener,
    Serializable {
        private ListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            JList.this.fireSelectionValueChanged(listSelectionEvent.getFirstIndex(), listSelectionEvent.getLastIndex(), listSelectionEvent.getValueIsAdjusting());
        }
    }

    public static final class DropLocation
    extends TransferHandler.DropLocation {
        private final int index;
        private final boolean isInsert;

        private DropLocation(Point point, int n, boolean bl) {
            super(point);
            this.index = n;
            this.isInsert = bl;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean isInsert() {
            return this.isInsert;
        }

        @Override
        public String toString() {
            return this.getClass().getName() + "[dropPoint=" + this.getDropPoint() + ",index=" + this.index + ",insert=" + this.isInsert + "]";
        }
    }
}

