/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr;

import com.ibm.j9ddr.FlagsHelper;
import com.ibm.j9ddr.PointerHelper;
import com.ibm.j9ddr.StructureHelper;
import com.ibm.j9ddr.StructureReader;
import com.ibm.j9ddr.StructureTypeManager;
import com.ibm.j9ddr.tools.FlagStructureList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class BytecodeGenerator {
    private static void addFlagAlias(Map<String, String> map, String string, String string2) {
        if (map.get(string) == null) {
            map.put(string, string2);
        }
    }

    private static Map<String, String> addFlagAliasesFor(Map<String, String> map, String string) {
        if (string.equals("J9BuildFlags")) {
            BytecodeGenerator.addFlagAlias(map, "arch_arm", "J9VM_ARCH_ARM");
            BytecodeGenerator.addFlagAlias(map, "arch_aarch64", "J9VM_ARCH_AARCH64");
            BytecodeGenerator.addFlagAlias(map, "arch_power", "J9VM_ARCH_POWER");
            BytecodeGenerator.addFlagAlias(map, "arch_riscv", "J9VM_ARCH_RISCV");
            BytecodeGenerator.addFlagAlias(map, "arch_x86", "J9VM_ARCH_X86");
        }
        return map;
    }

    static Map<String, String> getFlagAliasesFor(String string) {
        return BytecodeGenerator.addFlagAliasesFor(new HashMap<String, String>(), string);
    }

    public static Map<String, String> getConstantsAndAliases(StructureReader.StructureDescriptor structureDescriptor) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (StructureReader.ConstantDescriptor constantDescriptor : structureDescriptor.getConstants()) {
            String string = constantDescriptor.getName();
            treeMap.put(string, null);
        }
        return BytecodeGenerator.addFlagAliasesFor(treeMap, structureDescriptor.getName());
    }

    public static byte[] getPointerClassBytes(StructureReader structureReader, StructureTypeManager structureTypeManager, StructureReader.StructureDescriptor structureDescriptor, String string) {
        if (FlagStructureList.isFlagsStructure(structureDescriptor.getName())) {
            return FlagsHelper.getClassBytes(structureDescriptor, string);
        }
        return PointerHelper.getClassBytes(structureReader, structureTypeManager, structureDescriptor, string);
    }

    public static byte[] getStructureClassBytes(StructureReader.StructureDescriptor structureDescriptor, String string) {
        return StructureHelper.getClassBytes(structureDescriptor, string);
    }
}

