/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.aix;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.AbstractCoreReader;
import com.ibm.j9ddr.corereaders.ClosingFileReader;
import com.ibm.j9ddr.corereaders.ICore;
import com.ibm.j9ddr.corereaders.ILibraryDependentCore;
import com.ibm.j9ddr.corereaders.ILibraryResolver;
import com.ibm.j9ddr.corereaders.IModuleFile;
import com.ibm.j9ddr.corereaders.InvalidDumpFormatException;
import com.ibm.j9ddr.corereaders.LibraryDataSource;
import com.ibm.j9ddr.corereaders.LibraryResolverFactory;
import com.ibm.j9ddr.corereaders.Platform;
import com.ibm.j9ddr.corereaders.aix.AIX32DumpReader;
import com.ibm.j9ddr.corereaders.aix.AIX64DumpReader;
import com.ibm.j9ddr.corereaders.aix.AIXProcessAddressSpace;
import com.ibm.j9ddr.corereaders.aix.ARReader;
import com.ibm.j9ddr.corereaders.aix.BaseAIXOSThread;
import com.ibm.j9ddr.corereaders.aix.XCOFFReader;
import com.ibm.j9ddr.corereaders.memory.BaseModule;
import com.ibm.j9ddr.corereaders.memory.DumpMemorySource;
import com.ibm.j9ddr.corereaders.memory.IAddressSpace;
import com.ibm.j9ddr.corereaders.memory.IMemoryRange;
import com.ibm.j9ddr.corereaders.memory.IMemorySource;
import com.ibm.j9ddr.corereaders.memory.IModule;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.corereaders.memory.ISymbol;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.corereaders.memory.MemoryRange;
import com.ibm.j9ddr.corereaders.memory.MissingFileModule;
import com.ibm.j9ddr.corereaders.memory.Module;
import com.ibm.j9ddr.corereaders.memory.UnbackedMemorySource;
import com.ibm.j9ddr.corereaders.osthread.IOSThread;
import com.ibm.j9ddr.corereaders.osthread.IRegister;
import com.ibm.j9ddr.corereaders.osthread.Register;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.stream.ImageInputStream;

public abstract class AIXDumpReader
extends AbstractCoreReader
implements ILibraryDependentCore {
    private static final Logger logger = Logger.getLogger("j9ddr.core_readers");
    private static final int FAULTING_THREAD_OFFSET = 216;
    protected static final int S64BIT = 1;
    private static final int CORE_FILE_VERSION_OFFSET = 4;
    private static final int CORE_DUMP_XX_VERSION = 267312562;
    private static final int CORE_DUMP_X_VERSION = 267312561;
    private static final int CORE_DUMP_X_PI_FLAGS_2_OFFSET = 1056;
    private static final int POWER_RS1 = 1;
    private static final int POWER_RSC = 2;
    private static final int POWER_RS2 = 4;
    private static final int POWER_601 = 8;
    private static final int POWER_603 = 32;
    private static final int POWER_604 = 16;
    private static final int POWER_620 = 64;
    private static final int POWER_630 = 128;
    private static final int POWER_A35 = 256;
    private static final int POWER_RS64II = 512;
    private static final int POWER_RS64III = 1024;
    private static final int POWER_4 = 2048;
    private static final int POWER_MPC7450 = 4096;
    private static final int POWER_5 = 8192;
    private int _implementation;
    private int _threadCount;
    private long _threadOffset;
    private long _loaderOffset;
    private long _loaderSize;
    private AIXProcessAddressSpace _process = new AIXProcessAddressSpace(this.is64Bit() ? 8 : 4, ByteOrder.BIG_ENDIAN, this);
    long _highestOffset = -1L;
    private Properties props = new Properties();
    private long _structTopOfStackVirtualAddress;
    private boolean _isTruncated = false;
    private ILibraryResolver resolver = null;
    private ArrayList<XCOFFReader> openFileTracker = new ArrayList();
    private boolean _userInfoLoaded = false;
    private int _pid;
    private int _argc;
    private long _argv;
    private long _environmentHandle;
    private final List<IModule> _modules = new LinkedList<IModule>();
    private IModule _executable;
    private IMemorySource _executableTextSection;

    protected abstract Map<String, Number> readRegisters(long var1) throws IOException;

    protected abstract int readLoaderInfoFlags() throws IOException;

    protected abstract long userInfoOffset();

    protected abstract long threadSize(long var1);

    protected abstract int pointerSize();

    protected abstract long getStackPointerFrom(Map<String, Number> var1);

    protected abstract long getInstructionPointerFrom(Map<String, Number> var1);

    protected abstract long getLinkRegisterFrom(Map<String, Number> var1);

    protected abstract int sizeofTopOfStack();

    protected static boolean isAIXDump(ClosingFileReader closingFileReader) throws IOException {
        closingFileReader.seek(4L);
        int n = closingFileReader.readInt();
        if (n != 267312561 && n != 267312562) {
            return false;
        }
        long l = closingFileReader.readLong();
        long l2 = closingFileReader.readLong();
        long l3 = closingFileReader.length();
        return l > 0L && l2 > 0L && l2 > l && l < l3 && l2 < l3;
    }

    @Override
    public boolean isTruncated() {
        return this._isTruncated;
    }

    public boolean validDump(byte[] byArray, long l) {
        return AIXDumpReader.isAIXDump(byArray, l);
    }

    protected void readCore() throws IOException {
        this.seek(0L);
        this.readByte();
        byte by = this.readByte();
        if ((by & 0x80) != 0) {
            this._isTruncated = true;
        }
        this.readShort();
        this.readInt();
        this.readLong();
        this._loaderOffset = this.readLong();
        this._loaderSize = this.readLong();
        this._threadCount = this.readInt();
        this.readInt();
        this._threadOffset = this.readLong();
        long l = this.readLong();
        long l2 = this.readLong();
        long l3 = this.readLong();
        long l4 = this.readLong();
        long l5 = this.readLong();
        this._structTopOfStackVirtualAddress = l4 + l5 - (long)this.sizeofTopOfStack();
        DumpMemorySource dumpMemorySource = new DumpMemorySource(l4, l5, l3, 0, this, "stack", false, false, false);
        this.addMemorySource(dumpMemorySource);
        long l6 = this.readLong();
        long l7 = this.readLong();
        long l8 = this.readLong();
        DumpMemorySource dumpMemorySource2 = new DumpMemorySource(l7, l8, l6, this);
        this.addMemorySource(dumpMemorySource2);
        this.readLong();
        this.readLong();
        long l9 = this.readLong();
        long l10 = this.readLong();
        this._implementation = this.readInt();
        this.readInt();
        this.readLong();
        this.readLong();
        this.readBytes(48);
        this.readVMRegions(l10, l9);
        this.readSegments(l2, l);
        this.readLoaderInfoAsMemoryRanges();
        this.readModules();
        this._isTruncated |= this.checkHighestOffset();
        this.createProperties();
    }

    private void createProperties() {
        this.props.put("system.type", "AIX");
        this.props.put("cpu.type", this.getCPUType());
        this.props.put("cpu.subtype", this.getCPUSubType());
        this.props.put("core.creation.time", (Object)this.getCreationTime());
    }

    public String getCPUType() {
        return "PowerPC";
    }

    public String getCPUSubType() {
        switch (this._implementation) {
            case 1: {
                return "RS1";
            }
            case 2: {
                return "RSC";
            }
            case 4: {
                return "RS2";
            }
            case 8: {
                return "601";
            }
            case 32: {
                return "603";
            }
            case 16: {
                return "604";
            }
            case 64: {
                return "620";
            }
            case 128: {
                return "630";
            }
            case 256: {
                return "A35";
            }
            case 512: {
                return "RS64-II";
            }
            case 1024: {
                return "RS64-III";
            }
            case 2048: {
                return "POWER 4";
            }
            case 4096: {
                return "MPC7450";
            }
            case 8192: {
                return "POWER 5";
            }
        }
        return "";
    }

    public long getCreationTime() {
        return 0L;
    }

    private void addMemorySource(IMemorySource iMemorySource) {
        DumpMemorySource dumpMemorySource;
        if (iMemorySource instanceof DumpMemorySource && (dumpMemorySource = (DumpMemorySource)iMemorySource).getFileOffset() > this._highestOffset) {
            this._highestOffset = dumpMemorySource.getFileOffset();
        }
        this._process.addMemorySource(iMemorySource);
    }

    private boolean checkHighestOffset() throws IOException {
        if (this._highestOffset != -1L) {
            return !this.checkOffset(this._highestOffset);
        }
        return false;
    }

    private void readVMRegions(long l, long l2) throws IOException {
        this.seek(l);
        int n = 0;
        while ((long)n < l2) {
            long l3 = this.readLong();
            long l4 = this.readLong();
            long l5 = this.readLong();
            DumpMemorySource dumpMemorySource = new DumpMemorySource(l3, l4, l5, 0, this, "anon vm region");
            this.addMemorySource(dumpMemorySource);
            ++n;
        }
    }

    private void readSegments(long l, long l2) throws IOException {
        this.seek(l);
        int n = 0;
        while ((long)n < l2) {
            long l3 = this.readLong();
            long l4 = this.readLong();
            long l5 = this.readLong();
            this.readInt();
            this.readInt();
            DumpMemorySource dumpMemorySource = new DumpMemorySource(l3, l4, l5, 0, this, "anon segment");
            this.addMemorySource(dumpMemorySource);
            ++n;
        }
    }

    private void readLoaderInfoAsMemoryRanges() throws IOException {
        int n = 0;
        long l = this._loaderOffset;
        do {
            this.seek(l += (long)n);
            n = this.readInt();
            this.readLoaderInfoFlags();
            long l2 = this.readAddress();
            this.readAddress();
            this.readAddress();
            long l3 = this.readAddress();
            long l4 = this.readAddress();
            if (0L == l2) continue;
            DumpMemorySource dumpMemorySource = new DumpMemorySource(l3, l4, l2, this);
            this.addMemorySource(dumpMemorySource);
        } while (0 != n && l + (long)n < this._loaderOffset + this._loaderSize);
    }

    protected abstract boolean is64Bit();

    protected abstract long readAddress() throws IOException;

    private void loadUserInfo() throws IOException, MemoryFault {
        if (!this._userInfoLoaded) {
            this.seek(this.userInfoOffset());
            this._pid = this.readInt();
            AIXProcessAddressSpace aIXProcessAddressSpace = this.getProcess();
            long l = this._structTopOfStackVirtualAddress;
            int n = this.pointerSize() / 8;
            l += (long)(2 * n);
            long l2 = aIXProcessAddressSpace.getPointerAt(l += (long)n);
            this._argv = aIXProcessAddressSpace.getPointerAt(l += (long)n);
            this._environmentHandle = aIXProcessAddressSpace.getPointerAt(l += (long)n);
            this._argc = (int)l2;
            this._userInfoLoaded = true;
        }
    }

    String getCommandLine() throws CorruptDataException {
        try {
            this.loadUserInfo();
        }
        catch (IOException iOException) {
            throw new CorruptDataException(iOException);
        }
        AIXProcessAddressSpace aIXProcessAddressSpace = this.getProcess();
        int n = this.pointerSize() / 8;
        if (this._argc > 100) {
            throw new CorruptDataException("Argc too high. Likely corrupt data. Argc=" + this._argc + " structTopOfStackVirtualAddress = 0x" + Long.toHexString(this._structTopOfStackVirtualAddress));
        }
        long[] lArray = new long[this._argc];
        for (int i = 0; i < this._argc; ++i) {
            lArray[i] = aIXProcessAddressSpace.getPointerAt(this._argv + (long)(i * n));
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this._argc; ++i) {
            try {
                long l;
                long l2 = l = lArray[i];
                while (aIXProcessAddressSpace.getByteAt(l2) != 0) {
                    ++l2;
                }
                int n2 = (int)(l2 - l);
                byte[] byArray = new byte[n2];
                aIXProcessAddressSpace.getBytesAt(l, byArray);
                stringBuffer.append(new String(byArray, "ASCII"));
                stringBuffer.append(" ");
                continue;
            }
            catch (MemoryFault memoryFault) {
                stringBuffer.append(" <Fault reading argv[" + i + "] at 0x" + Long.toHexString(lArray[i]) + ">");
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
        }
        return stringBuffer.toString();
    }

    private void readModules() throws IOException {
        int n = 0;
        long l = this._loaderOffset;
        this.resolver = this.coreFile == null ? LibraryResolverFactory.getResolverForCoreFile(this._fileReader) : LibraryResolverFactory.getResolverForCoreFile(this.coreFile);
        AIXProcessAddressSpace aIXProcessAddressSpace = this.getProcess();
        boolean bl = true;
        do {
            this.seek(l += (long)n);
            n = this.readInt();
            this.readLoaderInfoFlags();
            this.readAddress();
            long l2 = this.readAddress();
            long l3 = this.readAddress();
            long l4 = this.readAddress();
            long l5 = this.readAddress();
            String string = this.readString();
            String string2 = this.readString();
            String string3 = string;
            if (0 < string2.length()) {
                string3 = string3 + "(" + string2 + ")";
            }
            this.loadModule(this.resolver, aIXProcessAddressSpace, l2, l3, l4, l5, string, string2, string3, bl);
            bl = false;
        } while (0 != n && l + (long)n < this._loaderOffset + this._loaderSize);
    }

    @Override
    public void executablePathHint(String string) {
        if (this._executable instanceof MissingFileModule) {
            try {
                if (!this.getFileName(this._executable.getName()).equals(this.getFileName(string))) {
                    return;
                }
            }
            catch (CorruptDataException corruptDataException) {
                return;
            }
            this._process.removeMemorySource(this._executableTextSection);
            IModule iModule = this._executable;
            IMemorySource iMemorySource = this._executableTextSection;
            ILibraryResolver iLibraryResolver = LibraryResolverFactory.getResolverForCoreFile(this.coreFile);
            AIXProcessAddressSpace aIXProcessAddressSpace = this.getProcess();
            try {
                this.seek(this._loaderOffset);
                this.readInt();
                this.readLoaderInfoFlags();
                this.readAddress();
                long l = this.readAddress();
                long l2 = this.readAddress();
                long l3 = this.readAddress();
                long l4 = this.readAddress();
                this.readString();
                String string2 = string;
                String string3 = this.readString();
                String string4 = string2;
                if (0 < string3.length()) {
                    string4 = string4 + "(" + string3 + ")";
                }
                this.loadModule(iLibraryResolver, aIXProcessAddressSpace, l, l2, l3, l4, string2, string3, string4, true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this._executable instanceof MissingFileModule) {
                this._process.removeMemorySource(this._executableTextSection);
                this._executableTextSection = iMemorySource;
                this._process.addMemorySource(this._executableTextSection);
                this._executable = iModule;
            }
        }
    }

    private String getFileName(String string) {
        File file = new File(string);
        return file.getName();
    }

    private void loadModule(ILibraryResolver iLibraryResolver, IProcess iProcess, long l, long l2, long l3, long l4, String string, String string2, String string3, boolean bl) {
        BaseModule baseModule;
        IMemorySource iMemorySource;
        MemoryRange memoryRange = new MemoryRange(iProcess.getAddressSpace(), l3, l4, ".data");
        try {
            LibraryDataSource libraryDataSource = null;
            libraryDataSource = bl ? iLibraryResolver.getLibrary(string, true) : iLibraryResolver.getLibrary(string);
            IModuleFile iModuleFile = this.loadModuleFile(libraryDataSource, string2);
            iMemorySource = iModuleFile.getTextSegment(l, l2);
            List<? extends ISymbol> list = iModuleFile.getSymbols(l);
            LinkedList<IMemoryRange> linkedList = new LinkedList<IMemoryRange>();
            linkedList.add(iMemorySource);
            linkedList.add(memoryRange);
            baseModule = new Module(iProcess, string3, list, linkedList, l, iModuleFile.getProperties());
        }
        catch (Exception exception) {
            iMemorySource = new UnbackedMemorySource(l, l2, "Native library " + string3 + " couldn't be found", 0, ".text");
            LinkedList<IMemoryRange> linkedList = new LinkedList<IMemoryRange>();
            linkedList.add(iMemorySource);
            linkedList.add(memoryRange);
            baseModule = new MissingFileModule(iProcess, string3, linkedList);
        }
        this.addMemorySource(iMemorySource);
        if (bl) {
            this._executable = baseModule;
            this._executableTextSection = iMemorySource;
        } else {
            this._modules.add(baseModule);
        }
    }

    private IModuleFile loadModuleFile(LibraryDataSource libraryDataSource, String string) throws IOException {
        XCOFFReader xCOFFReader = null;
        try {
            switch (libraryDataSource.getType()) {
                case FILE: {
                    xCOFFReader = new XCOFFReader(libraryDataSource.getFile());
                    break;
                }
                case STREAM: {
                    xCOFFReader = new XCOFFReader(libraryDataSource.getName(), libraryDataSource.getStream(), 0L, libraryDataSource.getStream().length());
                    break;
                }
                default: {
                    String string2 = String.format("The library %s could not be read from a source type of %s", libraryDataSource.getName(), libraryDataSource.getType().name());
                    throw new IllegalArgumentException(string2);
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ARReader aRReader = null;
            switch (libraryDataSource.getType()) {
                case FILE: {
                    aRReader = new ARReader(libraryDataSource.getFile());
                    break;
                }
                case STREAM: {
                    aRReader = new ARReader(libraryDataSource.getStream());
                    break;
                }
                default: {
                    String string3 = String.format("The library %s could not be read from a source type of %s", libraryDataSource.getName(), libraryDataSource.getType().name());
                    throw new IllegalArgumentException(string3);
                }
            }
            long l = aRReader.offsetOfModule(string);
            long l2 = aRReader.offsetOfModule(string);
            if (l < 0L || l2 < 0L) {
                throw new IOException("Can't find object " + string + " in module " + libraryDataSource.getName() + ". offset = " + l + ", size = " + l2);
            }
            switch (libraryDataSource.getType()) {
                case FILE: {
                    xCOFFReader = new XCOFFReader(libraryDataSource.getFile(), l, l2);
                    break;
                }
                case STREAM: {
                    xCOFFReader = new XCOFFReader(libraryDataSource.getName(), libraryDataSource.getStream(), l, l2);
                    break;
                }
                default: {
                    String string4 = String.format("The library %s could not be read from a source type of %s", libraryDataSource.getName(), libraryDataSource.getType().name());
                    throw new IllegalArgumentException(string4);
                }
            }
        }
        this.openFileTracker.add(xCOFFReader);
        return xCOFFReader;
    }

    List<? extends IOSThread> getThreads() {
        LinkedList<IOSThread> linkedList = new LinkedList<IOSThread>();
        long l = this.threadSize(216L);
        try {
            linkedList.add(this.readThread(216L));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (int i = 0; i < this._threadCount; ++i) {
            try {
                linkedList.add(this.readThread(this._threadOffset + (long)i * l));
                continue;
            }
            catch (IOException iOException) {
                logger.logp(Level.WARNING, "com.ibm.j9ddr.corereaders.aix.AIXDumpReader", "getThreads", "Error adding thread", iOException);
            }
        }
        return linkedList;
    }

    private IOSThread readThread(long l) throws IOException {
        this.seek(l);
        long l2 = this.readAddress();
        this.readInt();
        int n = this.readInt();
        int n2 = this.readInt();
        int n3 = this.readInt();
        int n4 = this.readInt();
        int n5 = this.readInt();
        int n6 = this.readInt();
        int n7 = this.readInt();
        int n8 = this.readInt();
        int n9 = this.readInt();
        this.readSigset();
        this.readSigset();
        this.readInt();
        this.readAddress();
        int n10 = 0xFF & this.readByte();
        Map<String, Number> map = this.readRegisters(l);
        Properties properties = new Properties();
        properties.put("scheduling policy", Integer.toHexString(n));
        properties.put("current effective priority", Integer.toHexString(n2));
        properties.put("thread state", Integer.toHexString(n3));
        properties.put("thread flags", Integer.toHexString(n4));
        properties.put("suspend count", Integer.toHexString(n5));
        properties.put("type of thread wait", Integer.toHexString(n6));
        properties.put("wait channel", Integer.toHexString(n7));
        properties.put("processor usage", Integer.toHexString(n8));
        properties.put("processor on which I'm bound", Integer.toHexString(n9));
        properties.put("current/last signal taken", Integer.toHexString(n10));
        long l3 = this.getStackPointerFrom(map);
        IMemoryRange iMemoryRange = this.getProcess().getMemoryRangeForAddress(l3);
        if (null == iMemoryRange) {
            throw new IOException("Cannot find memory range for stackPointer " + Long.toHexString(l3));
        }
        MemoryRange memoryRange = new MemoryRange(this.getProcess().getAddressSpace(), iMemoryRange, "stack");
        return new AIXOSThread(this.getProcess(), l2, Collections.singletonList(memoryRange), properties, map);
    }

    private void readSigset() throws IOException {
        this.readBytes(this.is64Bit() ? 32 : 8);
    }

    @Override
    public String getDumpFormat() {
        return "xcoff";
    }

    protected AIXProcessAddressSpace getProcess() {
        return this._process;
    }

    public List<IAddressSpace> getAddressSpaces() {
        return Collections.singletonList(this._process);
    }

    @Override
    public Platform getPlatform() {
        return Platform.AIX;
    }

    @Override
    public Properties getProperties() {
        return this.props;
    }

    long getEnvironmentHandle() throws CorruptDataException {
        try {
            this.loadUserInfo();
        }
        catch (IOException iOException) {
            throw new CorruptDataException(iOException);
        }
        return this._environmentHandle;
    }

    List<IModule> getModules() {
        return this._modules;
    }

    IModule getExecutable() {
        return this._executable;
    }

    long getProcessId() {
        return this._pid;
    }

    public static boolean isAIXDump(byte[] byArray, long l) {
        int n = AIXDumpReader.readInt(byArray, 4);
        if (n != 267312561 && n != 267312562) {
            return false;
        }
        long l2 = AIXDumpReader.readLong(byArray, 8);
        long l3 = AIXDumpReader.readLong(byArray, 16);
        return l2 > 0L && l3 > 0L && l3 > l2 && l2 < l && l3 < l;
    }

    public static ICore getReaderForFile(File file) throws IOException, InvalidDumpFormatException {
        ClosingFileReader closingFileReader = new ClosingFileReader(file, ByteOrder.BIG_ENDIAN);
        byte[] byArray = new byte[128];
        closingFileReader.readFully(byArray);
        if (!AIXDumpReader.isAIXDump(byArray, file.length())) {
            closingFileReader.close();
            throw new InvalidDumpFormatException("File " + file.getAbsolutePath() + " is not an AIX dump");
        }
        closingFileReader.seek(4L);
        int n = closingFileReader.readInt();
        boolean bl = false;
        if (n == 267312561) {
            closingFileReader.seek(1056L);
            int n2 = closingFileReader.readInt();
            bl = (1 & n2) != 0;
        } else if (n == 267312562) {
            bl = true;
        } else {
            throw new InvalidDumpFormatException("Unrecognised core file version: " + Long.toHexString(n));
        }
        if (bl) {
            return new AIX64DumpReader(file, closingFileReader);
        }
        return new AIX32DumpReader(file, closingFileReader);
    }

    public static ICore getReaderForFile(ImageInputStream imageInputStream) throws IOException, InvalidDumpFormatException {
        byte[] byArray = new byte[128];
        imageInputStream.seek(0L);
        imageInputStream.read(byArray);
        if (!AIXDumpReader.isAIXDump(byArray, Long.MAX_VALUE)) {
            throw new InvalidDumpFormatException("The supplied input stream is not an AIX dump");
        }
        imageInputStream.seek(4L);
        int n = imageInputStream.readInt();
        boolean bl = false;
        if (n == 267312561) {
            imageInputStream.seek(1056L);
            int n2 = imageInputStream.readInt();
            bl = (1 & n2) != 0;
        } else if (n == 267312562) {
            bl = true;
        } else {
            throw new InvalidDumpFormatException("Unrecognised core file version: " + Long.toHexString(n));
        }
        if (bl) {
            return new AIX64DumpReader(imageInputStream);
        }
        return new AIX32DumpReader(imageInputStream);
    }

    @Override
    public void close() throws IOException {
        for (XCOFFReader xCOFFReader : this.openFileTracker) {
            xCOFFReader.close();
        }
        this.resolver.dispose();
        super.close();
    }

    class AIXOSThread
    extends BaseAIXOSThread {
        private final long tid;
        private final List<? extends IMemoryRange> memoryRanges;
        private final Properties properties;
        private final Map<String, Number> registers;

        protected AIXOSThread(IProcess iProcess, long l, List<? extends IMemoryRange> list, Properties properties, Map<String, Number> map) {
            super(iProcess);
            this.tid = l;
            this.memoryRanges = list;
            this.properties = properties;
            this.registers = map;
        }

        @Override
        public Collection<? extends IMemoryRange> getMemoryRanges() {
            return Collections.unmodifiableList(this.memoryRanges);
        }

        @Override
        public Properties getProperties() {
            return this.properties;
        }

        public List<? extends IRegister> getRegisters() {
            ArrayList<Register> arrayList = new ArrayList<Register>(this.registers.size());
            for (String string : this.registers.keySet()) {
                Number number = this.registers.get(string);
                arrayList.add(new Register(string, number));
            }
            return arrayList;
        }

        @Override
        public long getThreadId() throws CorruptDataException {
            return this.tid;
        }

        @Override
        public long getInstructionPointer() {
            return AIXDumpReader.this.getInstructionPointerFrom(this.registers);
        }

        @Override
        public long getBasePointer() {
            return AIXDumpReader.this.getLinkRegisterFrom(this.registers);
        }

        @Override
        public long getStackPointer() {
            return AIXDumpReader.this.getStackPointerFrom(this.registers);
        }
    }
}

