/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.memory;

import com.ibm.j9ddr.corereaders.AbstractCoreReader;
import com.ibm.j9ddr.corereaders.memory.IMemorySource;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.corereaders.memory.ProtectedMemoryRange;
import java.io.IOException;

public class DumpMemorySource
extends ProtectedMemoryRange
implements IMemorySource {
    private final long fileOffset;
    private final AbstractCoreReader coreReader;
    private final int addressSpaceId;
    private final String name;

    protected DumpMemorySource(DumpMemorySource dumpMemorySource) {
        this(dumpMemorySource.baseAddress, dumpMemorySource.size, dumpMemorySource.fileOffset, dumpMemorySource.addressSpaceId, dumpMemorySource.coreReader, dumpMemorySource.name, dumpMemorySource.shared, dumpMemorySource.readOnly, dumpMemorySource.executable);
    }

    public DumpMemorySource(long l, long l2, long l3, AbstractCoreReader abstractCoreReader) {
        this(l, l2, l3, 0, abstractCoreReader, null, false, false, true);
    }

    public DumpMemorySource(long l, long l2, long l3, AbstractCoreReader abstractCoreReader, boolean bl, boolean bl2, boolean bl3) {
        this(l, l2, l3, 0, abstractCoreReader, null, bl, bl2, bl3);
    }

    public DumpMemorySource(long l, long l2, long l3, int n, AbstractCoreReader abstractCoreReader, String string) {
        this(l, l2, l3, n, abstractCoreReader, string, false, false, true);
    }

    public DumpMemorySource(long l, long l2, long l3, int n, AbstractCoreReader abstractCoreReader, String string, boolean bl, boolean bl2, boolean bl3) {
        super(l, l2);
        this.fileOffset = l3;
        this.addressSpaceId = n;
        this.coreReader = abstractCoreReader;
        this.shared = bl;
        this.readOnly = bl2;
        this.executable = bl3;
        this.name = string;
    }

    @Override
    public int getAddressSpaceId() {
        return this.addressSpaceId;
    }

    @Override
    public int getBytes(long l, byte[] byArray, int n, int n2) throws MemoryFault {
        long l2 = l - this.baseAddress;
        if (l2 < 0L || l2 > this.size) {
            throw new IllegalArgumentException("Address " + Long.toHexString(l) + " is not in this range");
        }
        try {
            this.coreReader.seek(this.fileOffset + l2);
            this.coreReader.readFully(byArray, n, n2);
        }
        catch (IOException iOException) {
            throw new MemoryFault(l, "Memory fault caused by IOException reading dump.", iOException);
        }
        return n2;
    }

    public long getFileOffset() {
        return this.fileOffset;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

