/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.minidump;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.memory.Addresses;
import com.ibm.j9ddr.corereaders.memory.IMemoryRange;
import com.ibm.j9ddr.corereaders.memory.IModule;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.corereaders.minidump.unwind.RuntimeFunction;
import com.ibm.j9ddr.corereaders.minidump.unwind.UnwindInfo;
import com.ibm.j9ddr.corereaders.minidump.unwind.UnwindModule;
import com.ibm.j9ddr.corereaders.osthread.IOSStackFrame;
import com.ibm.j9ddr.corereaders.osthread.IOSThread;
import com.ibm.j9ddr.corereaders.osthread.IRegister;
import com.ibm.j9ddr.corereaders.osthread.OSStackFrame;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class BaseWindowsOSThread
implements IOSThread {
    private static final Logger logger = Logger.getLogger("j9ddr.core_readers");
    private List<IOSStackFrame> stackFrames;
    protected final IProcess process;

    protected BaseWindowsOSThread(IProcess iProcess) {
        this.process = iProcess;
    }

    public List<IOSStackFrame> getStackFrames() {
        if (null == this.stackFrames) {
            this.stackFrames = new LinkedList<IOSStackFrame>();
            try {
                if (this.process.bytesPerPointer() == 4) {
                    this.walkStack32();
                } else {
                    this.walkStack64();
                }
            }
            catch (CorruptDataException corruptDataException) {
                logger.logp(Level.FINE, "com.ibm.j9ddr.corereaders.minidump.BaseWindowsOSThread", "getStackFrames", "Problem walking native stack: " + corruptDataException.getMessage());
            }
        }
        return Collections.unmodifiableList(this.stackFrames);
    }

    protected abstract long getStackStart();

    protected abstract long getStackEnd();

    private void walkStack32() throws CorruptDataException {
        long l = this.getBasePointer();
        long l2 = this.getInstructionPointer();
        long l3 = this.getStackPointer();
        long l4 = this.getStackStart();
        long l5 = this.getStackEnd();
        if (-1L == l2 && l4 <= l3 && l3 < l5) {
            try {
                l2 = this.process.getPointerAt(l3);
            }
            catch (MemoryFault memoryFault) {
                // empty catch block
            }
        }
        int n = this.process.bytesPerPointer();
        if (Addresses.lessThanOrEqual(l4, l) && Addresses.lessThan(l, l5)) {
            this.stackFrames.add(new OSStackFrame(l, l2));
        } else if (Addresses.lessThan(l4, l3) && Addresses.lessThan(l3, l5)) {
            this.stackFrames.add(new OSStackFrame(l3, l2));
            l = l3 + (long)n;
        }
        while (l4 <= l && l < l5) {
            try {
                long l6 = this.process.getPointerAt(l);
                long l7 = this.process.getPointerAt(l + (long)n);
                this.stackFrames.add(new OSStackFrame(l6, l7));
                l = l6;
            }
            catch (MemoryFault memoryFault) {
                break;
            }
        }
    }

    private void walkStack64() throws CorruptDataException {
        long l = this.getInstructionPointer();
        long l2 = this.getStackPointer();
        while (l != 0L) {
            this.stackFrames.add(new OSStackFrame(l2, l));
            UnwindModule unwindModule = this.getModuleForInstructionAddress(l);
            RuntimeFunction runtimeFunction = null;
            if (unwindModule == null || (runtimeFunction = unwindModule.getUnwindDataForAddress(l - unwindModule.getLoadAddress())) == null) break;
            UnwindInfo unwindInfo = new UnwindInfo(this.process.getAddressSpace(), unwindModule, runtimeFunction.getUnwindInfoAddress());
            l2 = unwindInfo.apply(l2);
            l = this.process.getPointerAt(l2);
            l2 += 8L;
        }
    }

    public UnwindModule getModuleForInstructionAddress(long l) throws CorruptDataException {
        Collection<? extends IModule> collection = this.process.getModules();
        IModule iModule = null;
        block0: for (IModule iModule2 : collection) {
            for (IMemoryRange iMemoryRange : iModule2.getMemoryRanges()) {
                if (!iMemoryRange.contains(l)) continue;
                iModule = iModule2;
                break block0;
            }
        }
        if (iModule == null || !(iModule instanceof UnwindModule)) {
            return null;
        }
        return (UnwindModule)iModule;
    }

    protected long getValueOfNamedRegister(Collection<? extends IRegister> collection, String string) {
        for (IRegister iRegister : collection) {
            if (!iRegister.getName().equals(string)) continue;
            return iRegister.getValue().longValue();
        }
        return -1L;
    }
}

