/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.tdump.zebedee.util;

import com.ibm.j9ddr.corereaders.tdump.zebedee.util.IntEnumeration;

public class BitSetArray {
    private int[] roots;
    private int setsSize;
    private BitSet[] sets;
    private int[] tmpintervals;
    private int[] tmplengths;
    IntEnumeration nullEnum = new IntEnumeration(){

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            return null;
        }

        @Override
        public long nextInt() {
            return 0L;
        }
    };

    public BitSetArray(int n) {
        this.roots = new int[n];
        this.sets = new BitSet[n];
    }

    public BitSetArray() {
        this(16);
    }

    public void set(int n, int n2) {
        assert (n2 >= 0);
        assert (n >= 0);
        this.ensureRootsCapacity(n + 1);
        int n3 = this.roots[n];
        if (n3 == 0) {
            this.roots[n] = n2 | Integer.MIN_VALUE;
        } else if (n3 < 0) {
            this.roots[n] = this.addSet(new TwoMemberSet(n3 & Integer.MAX_VALUE, n2));
        } else {
            this.sets[n3 - 1] = this.sets[n3 - 1].set(n2);
        }
    }

    public void or(int n, int n2) {
        assert (n >= 0 && n < this.roots.length) : n;
        assert (n2 >= 0 && n2 < this.roots.length) : n2;
        if (this.roots[n2] < 0) {
            this.set(n, this.roots[n2] & Integer.MAX_VALUE);
        } else if (this.roots[n2] > 0) {
            int n3 = this.roots[n2] - 1;
            if (this.roots[n] == 0) {
                this.roots[n] = this.addSet(this.sets[n3].cloneSet());
            } else if (this.roots[n] < 0) {
                int n4 = this.roots[n] & Integer.MAX_VALUE;
                this.roots[n] = this.addSet(this.sets[n3].cloneSet());
                this.set(n, n4);
            } else {
                int n5 = this.roots[n] - 1;
                this.sets[n5] = this.sets[n5].or(this.sets[n3]);
            }
        }
    }

    private int addSet(BitSet bitSet) {
        this.ensureSetsCapacity(this.setsSize + 1);
        this.sets[this.setsSize++] = bitSet;
        return this.setsSize;
    }

    private void ensureRootsCapacity(int n) {
        int n2 = this.roots.length;
        if (n > n2) {
            int n3 = n2 * 3 / 2 + 1;
            if (n3 < n) {
                n3 = n;
            }
            int[] nArray = new int[n3];
            System.arraycopy(this.roots, 0, nArray, 0, n2);
            this.roots = nArray;
        }
    }

    private void ensureSetsCapacity(int n) {
        int n2 = this.sets.length;
        if (n > n2) {
            int n3 = n2 * 3 / 2 + 1;
            if (n3 < n) {
                n3 = n;
            }
            BitSet[] bitSetArray = new BitSet[n3];
            System.arraycopy(this.sets, 0, bitSetArray, 0, n2);
            this.sets = bitSetArray;
        }
    }

    static int[] arraycopy(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    public IntEnumeration elements(int n) {
        int n2 = this.roots[n];
        if (n2 == 0) {
            return this.nullEnum;
        }
        if (n2 < 0) {
            return null;
        }
        return null;
    }

    class IntervalSet
    implements BitSet,
    Cloneable {
        private int size;
        private int[] intervals;
        private int[] lengths;

        IntervalSet(int[] nArray, int n) {
            this.intervals = new int[nArray.length << 1];
            this.lengths = new int[nArray.length << 1];
            for (int i = 0; i < nArray.length; ++i) {
                this.set(nArray[i]);
            }
            this.set(n);
        }

        @Override
        public BitSet set(int n) {
            int n2 = 0;
            int n3 = this.size - 1;
            int n4 = -1;
            int n5 = -1;
            int n6 = this.intervals.length;
            if (this.size == 0) {
                this.intervals[0] = n;
                this.lengths[0] = 1;
                this.size = 1;
                return this;
            }
            while (n2 <= n3) {
                n4 = n2 + n3 >> 1;
                n5 = this.intervals[n4];
                if (n >= n5) {
                    if (n < n5 + this.lengths[n4]) {
                        return this;
                    }
                    if (n == n5 + this.lengths[n4]) {
                        this.lengths[n4] = this.lengths[n4] + 1;
                        if (n4 < this.size - 1 && n + 1 == this.intervals[n4 + 1]) {
                            this.intervalMerge(n4);
                        }
                        return this;
                    }
                    n2 = n4 + 1;
                    continue;
                }
                if (n == n5 - 1) {
                    this.intervals[n4] = this.intervals[n4] - 1;
                    this.lengths[n4] = this.lengths[n4] + 1;
                    if (n4 > 0 && n == this.intervals[n4 - 1] + this.lengths[n4 - 1]) {
                        this.intervalMerge(n4 - 1);
                    }
                    return this;
                }
                n3 = n4 - 1;
            }
            if (this.size == n6) {
                this.intervals = BitSetArray.arraycopy(this.intervals, n6 <<= 1);
                this.lengths = BitSetArray.arraycopy(this.lengths, n6);
            }
            if (n < this.intervals[0]) {
                System.arraycopy(this.intervals, 0, this.intervals, 1, this.size);
                System.arraycopy(this.lengths, 0, this.lengths, 1, this.size);
                this.intervals[0] = n;
                this.lengths[0] = 1;
            } else if (n > this.intervals[this.size - 1]) {
                this.intervals[this.size] = n;
                this.lengths[this.size] = 1;
            } else {
                if (n < n5) {
                    --n4;
                }
                assert (this.size - n4 - 1 > 0);
                System.arraycopy(this.intervals, n4 + 1, this.intervals, n4 + 2, this.size - n4 - 1);
                System.arraycopy(this.lengths, n4 + 1, this.lengths, n4 + 2, this.size - n4 - 1);
                this.intervals[n4 + 1] = n;
                this.lengths[n4 + 1] = 1;
            }
            ++this.size;
            return this;
        }

        private void intervalMerge(int n) {
            int n2;
            int n3 = this.intervals.length;
            int n4 = this.intervals[n];
            int n5 = this.intervals[n + 1];
            int n6 = this.lengths[n];
            int n7 = this.lengths[n + 1];
            int n8 = n4 + n6;
            int n9 = n5 + n7;
            if (n4 < n5) {
                this.intervals[n] = n4;
                n2 = n4;
            } else {
                this.intervals[n] = n5;
                n2 = n5;
            }
            this.lengths[n] = n8 < n9 ? n9 - n2 : n8 - n2;
            if (n < this.size - 2) {
                int n10 = this.size - (n + 2);
                System.arraycopy(this.intervals, n + 2, this.intervals, n + 1, n10);
                System.arraycopy(this.lengths, n + 2, this.lengths, n + 1, n10);
            }
            --this.size;
            assert (this.size > 0);
            if (this.size * 3 < n3) {
                int[] nArray = new int[n3 >>= 1];
                int[] nArray2 = new int[n3];
                System.arraycopy(this.intervals, 0, nArray, 0, this.size);
                System.arraycopy(this.lengths, 0, nArray2, 0, this.size);
                this.intervals = nArray;
                this.lengths = nArray2;
            }
            if (n > 0 && this.intervals[n] <= this.intervals[n - 1] + this.lengths[n - 1]) {
                this.intervalMerge(n - 1);
            }
            if (n < this.size - 1 && this.intervals[n] + this.lengths[n] >= this.intervals[n + 1]) {
                this.intervalMerge(n);
            }
        }

        @Override
        public BitSet or(BitSet bitSet) {
            assert (false);
            return null;
        }

        @Override
        public BitSet cloneSet() {
            try {
                IntervalSet intervalSet = (IntervalSet)super.clone();
                intervalSet.intervals = (int[])this.intervals.clone();
                intervalSet.lengths = (int[])this.lengths.clone();
                return intervalSet;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new Error("impossible");
            }
        }
    }

    class SmallSet
    implements BitSet,
    Cloneable {
        private int[] bits = new int[8];
        private int numBits = 4;
        private static final int MAX_SIZE = 16;

        SmallSet(int n, int n2, int n3, int n4) {
            this.bits[0] = n;
            this.bits[1] = n2;
            this.bits[2] = n3;
            this.bits[3] = n4;
        }

        @Override
        public BitSet set(int n) {
            int[] nArray;
            int[] nArray2 = nArray = this.bits;
            int n2 = this.numBits;
            for (int i = 0; i <= n2; ++i) {
                if (i == n2 || n < nArray[i]) {
                    int n3;
                    if (n2 == nArray.length) {
                        if (n2 < 16) {
                            this.bits = nArray2 = new int[n2 << 1];
                            for (n3 = 0; n3 < i; ++n3) {
                                nArray2[n3] = nArray[n3];
                            }
                        } else {
                            return new IntervalSet(this.bits, n);
                        }
                    }
                    for (n3 = n2; n3 > i; --n3) {
                        nArray2[n3] = nArray[n3 - 1];
                    }
                    nArray2[i] = n;
                    ++this.numBits;
                    return this;
                }
                if (n != nArray[i]) continue;
                return this;
            }
            assert (false) : "should never reach here";
            return null;
        }

        @Override
        public BitSet or(BitSet bitSet) {
            if (bitSet.getClass() == TwoMemberSet.class) {
                TwoMemberSet twoMemberSet = (TwoMemberSet)bitSet;
                return this.set(twoMemberSet.l).set(twoMemberSet.h);
            }
            if (bitSet.getClass() == ThreeMemberSet.class) {
                ThreeMemberSet threeMemberSet = (ThreeMemberSet)bitSet;
                return this.set(threeMemberSet.l).set(threeMemberSet.m).set(threeMemberSet.h);
            }
            if (bitSet.getClass() == SmallSet.class) {
                SmallSet smallSet = (SmallSet)bitSet;
                BitSet bitSet2 = this;
                int n = smallSet.numBits;
                int[] nArray = smallSet.bits;
                for (int i = 0; i < n; ++i) {
                    bitSet2 = bitSet2.set(nArray[i]);
                }
                return bitSet2;
            }
            assert (bitSet.getClass() == IntervalSet.class);
            return bitSet.cloneSet().or(this);
        }

        @Override
        public BitSet cloneSet() {
            try {
                SmallSet smallSet = (SmallSet)super.clone();
                smallSet.bits = (int[])this.bits.clone();
                return smallSet;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new Error("impossible");
            }
        }
    }

    class ThreeMemberSet
    implements BitSet,
    Cloneable {
        private int l;
        private int m;
        private int h;

        ThreeMemberSet(int n, int n2, int n3) {
            this.l = n;
            this.m = n2;
            this.h = n3;
        }

        @Override
        public BitSet set(int n) {
            if (n == this.l || n == this.m || n == this.h) {
                return this;
            }
            if (n < this.l) {
                return new SmallSet(n, this.l, this.m, this.h);
            }
            if (n < this.m) {
                return new SmallSet(this.l, n, this.m, this.h);
            }
            if (n < this.h) {
                return new SmallSet(this.l, this.m, n, this.h);
            }
            return new SmallSet(this.l, this.m, this.h, n);
        }

        @Override
        public BitSet or(BitSet bitSet) {
            if (bitSet.getClass() == TwoMemberSet.class) {
                TwoMemberSet twoMemberSet = (TwoMemberSet)bitSet;
                return this.set(twoMemberSet.l).set(twoMemberSet.h);
            }
            if (bitSet.getClass() == ThreeMemberSet.class) {
                ThreeMemberSet threeMemberSet = (ThreeMemberSet)bitSet;
                return this.set(threeMemberSet.l).set(threeMemberSet.m).set(threeMemberSet.h);
            }
            return bitSet.cloneSet().or(this);
        }

        @Override
        public BitSet cloneSet() {
            try {
                return (ThreeMemberSet)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new Error("impossible");
            }
        }
    }

    class TwoMemberSet
    implements BitSet,
    Cloneable {
        private int l;
        private int h;

        TwoMemberSet(int n, int n2) {
            if (n < n2) {
                this.l = n;
                this.h = n2;
            } else {
                this.l = n2;
                this.h = n;
            }
        }

        @Override
        public BitSet set(int n) {
            if (n == this.l || n == this.h) {
                return this;
            }
            if (n < this.l) {
                return new ThreeMemberSet(n, this.l, this.h);
            }
            if (n < this.h) {
                return new ThreeMemberSet(this.l, n, this.h);
            }
            return new ThreeMemberSet(this.l, this.h, n);
        }

        @Override
        public BitSet or(BitSet bitSet) {
            if (bitSet.getClass() == TwoMemberSet.class) {
                TwoMemberSet twoMemberSet = (TwoMemberSet)bitSet;
                return this.set(twoMemberSet.l).set(twoMemberSet.h);
            }
            return bitSet.cloneSet().or(this);
        }

        @Override
        public BitSet cloneSet() {
            try {
                return (TwoMemberSet)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new Error("impossible");
            }
        }
    }

    static interface BitSet {
        public BitSet set(int var1);

        public BitSet or(BitSet var1);

        public BitSet cloneSet();
    }

    class SmallEnum
    implements IntEnumeration {
        int[] bits = new int[16];
        int size;
        int index;

        SmallEnum(int n) {
            this.reset(n);
        }

        void reset(int n) {
            this.bits[0] = n;
            this.size = 1;
            this.index = 0;
        }

        @Override
        public boolean hasMoreElements() {
            return this.index < this.size;
        }

        public Object nextElement() {
            return null;
        }

        @Override
        public long nextInt() {
            return this.bits[this.index++];
        }
    }
}

