/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.HashTable;
import com.ibm.j9ddr.vm29.j9.IHashTable;
import com.ibm.j9ddr.vm29.pointer.generated.J9JVMTIEnvPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JVMTIObjectTagPointer;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.util.Iterator;

public class JVMTIObjectTagTable
implements IHashTable<J9JVMTIObjectTagPointer> {
    protected HashTable<J9JVMTIObjectTagPointer> objectTagTable;

    protected JVMTIObjectTagTable(HashTable<J9JVMTIObjectTagPointer> hashTable) throws CorruptDataException {
        this.objectTagTable = hashTable;
    }

    public static JVMTIObjectTagTable fromJ9JVMTIEnv(J9JVMTIEnvPointer j9JVMTIEnvPointer) throws CorruptDataException {
        HashTable<J9JVMTIObjectTagPointer> hashTable = HashTable.fromJ9HashTable(j9JVMTIEnvPointer.objectTagTable(), true, J9JVMTIObjectTagPointer.class, new ObjectTagEqualFunction(), new ObjectTagHashFunction());
        return new JVMTIObjectTagTable(hashTable);
    }

    @Override
    public Iterator<J9JVMTIObjectTagPointer> iterator() {
        return this.objectTagTable.iterator();
    }

    @Override
    public long getCount() {
        return this.objectTagTable.getCount();
    }

    @Override
    public String getTableName() {
        return this.objectTagTable.getTableName();
    }

    protected static class ObjectTagEqualFunction
    implements HashTable.HashEqualFunction<J9JVMTIObjectTagPointer> {
        protected ObjectTagEqualFunction() {
        }

        @Override
        public boolean equal(J9JVMTIObjectTagPointer j9JVMTIObjectTagPointer, J9JVMTIObjectTagPointer j9JVMTIObjectTagPointer2) {
            try {
                return j9JVMTIObjectTagPointer.ref().equals(j9JVMTIObjectTagPointer2.ref());
            }
            catch (CorruptDataException corruptDataException) {
                EventManager.raiseCorruptDataEvent("Error checking equality", corruptDataException, true);
                return false;
            }
        }
    }

    protected static class ObjectTagHashFunction
    implements HashTable.HashFunction<J9JVMTIObjectTagPointer> {
        protected ObjectTagHashFunction() {
        }

        @Override
        public UDATA hash(J9JVMTIObjectTagPointer j9JVMTIObjectTagPointer) {
            try {
                UDATA uDATA = UDATA.cast(j9JVMTIObjectTagPointer.ref());
                if (4 == UDATA.SIZEOF) {
                    return uDATA.rightShift(2);
                }
                return uDATA.rightShift(3);
            }
            catch (CorruptDataException corruptDataException) {
                EventManager.raiseCorruptDataEvent("Error getting hash", corruptDataException, false);
                return new UDATA(0L);
            }
        }
    }
}

