/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.Pool;
import com.ibm.j9ddr.vm29.j9.SlotIterator;
import com.ibm.j9ddr.vm29.j9.SystemMonitor;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9PoolPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ThreadLibraryPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ThreadMonitorPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ThreadPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.structure.J9AbstractThread;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class SystemMonitorSingleTier_V1
extends SystemMonitor {
    private static final HashMap<J9ThreadMonitorPointer, List<J9ThreadPointer>> blockedThreads = new HashMap();
    private static final HashMap<J9ThreadMonitorPointer, List<J9ThreadPointer>> waitingThreads = new HashMap();

    private static void addToMap(HashMap<J9ThreadMonitorPointer, List<J9ThreadPointer>> hashMap, J9ThreadMonitorPointer j9ThreadMonitorPointer, J9ThreadPointer j9ThreadPointer) {
        if (!hashMap.containsKey(j9ThreadMonitorPointer)) {
            hashMap.put(j9ThreadMonitorPointer, new LinkedList());
        }
        hashMap.get(j9ThreadMonitorPointer).add(j9ThreadPointer);
    }

    protected SystemMonitorSingleTier_V1(J9ThreadMonitorPointer j9ThreadMonitorPointer) {
        this.monitor = j9ThreadMonitorPointer;
    }

    @Override
    public boolean isContended() throws CorruptDataException {
        return blockedThreads.containsKey(this.monitor);
    }

    private static List<J9ThreadPointer> threadListHelper(HashMap<J9ThreadMonitorPointer, List<J9ThreadPointer>> hashMap, J9ThreadMonitorPointer j9ThreadMonitorPointer) throws CorruptDataException {
        if (hashMap.containsKey(j9ThreadMonitorPointer)) {
            return hashMap.get(j9ThreadMonitorPointer);
        }
        return new LinkedList<J9ThreadPointer>();
    }

    @Override
    public List<J9ThreadPointer> getWaitingThreads() throws CorruptDataException {
        return SystemMonitorSingleTier_V1.threadListHelper(waitingThreads, this.monitor);
    }

    @Override
    public List<J9ThreadPointer> getBlockedThreads() throws CorruptDataException {
        return SystemMonitorSingleTier_V1.threadListHelper(blockedThreads, this.monitor);
    }

    static {
        try {
            J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
            J9VMThreadPointer j9VMThreadPointer = j9JavaVMPointer.mainThread();
            J9ThreadLibraryPointer j9ThreadLibraryPointer = j9VMThreadPointer.osThread().library();
            J9PoolPointer j9PoolPointer = j9ThreadLibraryPointer.thread_pool();
            Pool<J9ThreadPointer> pool = Pool.fromJ9Pool(j9PoolPointer, J9ThreadPointer.class);
            SlotIterator<J9ThreadPointer> slotIterator = pool.iterator();
            while (slotIterator.hasNext()) {
                J9ThreadPointer j9ThreadPointer = (J9ThreadPointer)slotIterator.next();
                J9ThreadMonitorPointer j9ThreadMonitorPointer = j9ThreadPointer.monitor();
                UDATA uDATA = j9ThreadPointer.flags();
                if (!j9ThreadMonitorPointer.notNull()) continue;
                if (uDATA.allBitsIn(J9AbstractThread.J9THREAD_FLAG_BLOCKED)) {
                    SystemMonitorSingleTier_V1.addToMap(blockedThreads, j9ThreadMonitorPointer, j9ThreadPointer);
                }
                if (!uDATA.allBitsIn(J9AbstractThread.J9THREAD_FLAG_WAITING)) continue;
                SystemMonitorSingleTier_V1.addToMap(waitingThreads, j9ThreadMonitorPointer, j9ThreadPointer);
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new RuntimeException(corruptDataException);
        }
    }
}

